/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.documentation;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageDataSource;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageInfo;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class NoteImageDataSource
implements ImageDataSource {
    private List<ImageInfo> m_additions = new ArrayList<ImageInfo>();
    private List<ImageInfo> m_deletions = new ArrayList<ImageInfo>();

    public void addImage(ImageInfo info) {
        this.m_additions.add(info);
    }

    public void deleteImage(ImageInfo info) {
        this.m_deletions.add(info);
    }

    public List<ImageInfo> getAdditions() {
        return this.m_additions;
    }

    public List<ImageInfo> getDeletions() {
        return this.m_deletions;
    }

    public List<ImageInfo> getImages() {
        ArrayList<ImageInfo> result = new ArrayList<ImageInfo>();
        result.addAll(this.m_additions);
        URL imgDir = BPELAddin.getUserDocumentationImagesDirectory();
        File dir = Helper.getFile((URL)imgDir);
        String[] files = dir.list();
        if (files == null) {
            return result;
        }
        for (String file : files) {
            URL imgURL;
            ImageInfo info;
            if (!file.endsWith(".gif") && !file.endsWith(".png") && !file.endsWith(".jpg") || this.isInDeletionList((info = new ImageInfo(imgURL = ImageCache.getUserDocumentationPath(file))).getURL())) continue;
            result.add(info);
        }
        return result;
    }

    protected boolean isInDeletionList(URL url) {
        for (ImageInfo info : this.m_deletions) {
            if (!info.getURL().equals(url)) continue;
            return true;
        }
        return false;
    }
}

