/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.documentation;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.DynamicFileFilter;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageBrowser;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageBrowserPanel;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageDataSource;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageInfo;
import oracle.tip.tools.ide.pm.bpelgraph.editors.documentation.NoteImageDataSource;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class NoteImageBrowser
extends ImageBrowser
implements ActionListener {
    protected JButton m_addBtn;
    protected JButton m_deleteBtn;

    public NoteImageBrowser(JFrame f, ImageDataSource ds) {
        super(f, ds);
    }

    protected void helpInvoked() {
        HelpSystem.showHelp((Component)((Object)this), "f1_bpelscopeimage_html");
    }

    protected JPanel getMainPanel() {
        this.m_addBtn = new JButton(ImageCache.getIcon("add16"));
        this.m_addBtn.addActionListener(this);
        this.m_deleteBtn = new JButton(ImageCache.getIcon("delete16"));
        this.m_deleteBtn.addActionListener(this);
        JToolBar tb = UIHelper.createToolBar();
        tb.add(this.m_addBtn);
        tb.add(this.m_deleteBtn);
        this.m_pnl = new ImageBrowserPanel(this.m_dataSource);
        this.m_pnl.load();
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)tb, (int)0, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 0, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JScrollPane((Component)this.m_pnl), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected void handleAddImage() {
        File[] files;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".gif", "GIF Files (*.gif)"));
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".jpg", "JPEG Files (*.jpg)"));
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".png", "PNG Files (*.png)"));
        chooser.setDialogTitle(BPELStringTranslator.getString("ADD_IMAGE", "Add Image"));
        int returnVal = chooser.showOpenDialog(GraphUtils.getFrame((Component)((Object)this)));
        if (returnVal != 0) {
            return;
        }
        for (File file : files = chooser.getSelectedFiles()) {
            URL u = null;
            try {
                u = Helper.getURL((File)file);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                continue;
            }
            ImageInfo info = new ImageInfo(u);
            NoteImageDataSource ds = (NoteImageDataSource)this.m_dataSource;
            ds.addImage(info);
            this.m_pnl.reload();
        }
    }

    protected void handleDeleteImage() {
        ImageInfo info = this.m_pnl.getSelection();
        if (info != null) {
            NoteImageDataSource ds = (NoteImageDataSource)this.m_dataSource;
            ds.deleteImage(info);
            this.m_pnl.reload();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleAddImage();
        } else if (src == this.m_deleteBtn) {
            this.handleDeleteImage();
        }
    }

    protected void handleOK() {
        URL url;
        NoteImageDataSource ds = (NoteImageDataSource)this.m_dataSource;
        for (ImageInfo info : ds.getAdditions()) {
            url = info.getURL();
            String file = URLFileSystem.getFileName((URL)url);
            try {
                URLFileSystem.copy((URL)url, (URL)ImageCache.getUserDocumentationPath(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (ImageInfo info : ds.getDeletions()) {
            url = info.getURL();
            URLFileSystem.delete((URL)url);
        }
        this.closeDialog(1);
    }
}

