/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.documentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.DynamicFileFilter;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.documentation.ListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.documentation.ListRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ImageBrowserPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JList m_imageLst;
    protected JLabel m_imageLbl;
    protected JButton m_addBtn;
    protected JButton m_deleteBtn;
    protected BPELXmlModel m_model;
    protected List<String> m_deleteList;
    protected List<URL> m_addList;
    protected Scope m_scope;

    public ImageBrowserPanel(BPELXmlModel model, Scope scope) {
        this.m_model = model;
        this.m_scope = scope;
        this.m_deleteList = new ArrayList<String>();
        this.m_addList = new ArrayList<URL>();
        this.createControls();
        this.layoutControls();
    }

    public URL getSelectedImage() {
        ListItem item = (ListItem)this.m_imageLst.getSelectedValue();
        if (item != null) {
            return item.m_url;
        }
        return null;
    }

    public void save() {
        if (this.m_deleteList.size() > 0) {
            URL imgDir = BPELAddin.getUserDocumentationImagesDirectory();
            String s = BPELStringTranslator.getString("DEL_IMG_MSG") + "\n";
            String files = "";
            Iterator<String> it = this.m_deleteList.iterator();
            int cnt = 0;
            while (it.hasNext()) {
                String s1 = it.next();
                if (cnt > 0) {
                    files = files + ", ";
                }
                files = files + s1;
                ++cnt;
            }
            if (GraphUtils.showConfirmDialog((Component)this, (String)(s = s + files), (String)BPELStringTranslator.getString("DEL_IMG")) == 0) {
                for (String s1 : this.m_deleteList) {
                    URL u = URLFactory.newURL((URL)imgDir, (String)s1);
                    if (!URLFileSystem.exists((URL)u)) continue;
                    URLFileSystem.delete((URL)u);
                }
            }
        }
        if (this.m_addList.size() > 0) {
            for (URL src : this.m_addList) {
                URL dest = URLFactory.newURL((URL)BPELAddin.getUserDocumentationImagesDirectory(), (String)URLFileSystem.getFileName((URL)src));
                try {
                    URLFileSystem.copy((URL)src, (URL)dest);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("ERROR_COPY_IMG_TO_MODEL_DIR"), (int)0);
                }
            }
        }
        this.m_addList.clear();
        this.m_deleteList.clear();
    }

    public void loadData() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ImageBrowserPanel.this.loadDirImages();
            }
        };
        new Thread(r).start();
    }

    protected void loadDirImages() {
        String userImg = this.m_scope.getUserImage();
        final DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
        URL imgDir = BPELAddin.getUserDocumentationImagesDirectory();
        File dir = Helper.getFile((URL)imgDir);
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        ListItem selection = null;
        for (String file : files) {
            Icon icon;
            if (!file.endsWith(".gif") && !file.endsWith(".png") && !file.endsWith(".jpg") || (icon = ImageCache.getUserDocumentationIcon(file)) == null) continue;
            ListItem item = new ListItem(icon, file, ImageCache.getUserDocumentationPath(file));
            model.addElement(item);
            if (userImg == null || !Helper.isEqual((String)userImg, (String)file)) continue;
            selection = item;
        }
        final ListItem selectedItem = selection;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ImageBrowserPanel.this.m_imageLst.setModel(model);
                ImageBrowserPanel.this.m_imageLst.setSelectedValue(selectedItem, true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void createControls() {
        this.m_addBtn = new JButton(GlobalImageCache.getIcon((String)"create16"));
        this.m_addBtn.addActionListener(this);
        this.m_deleteBtn = new JButton(GlobalImageCache.getIcon((String)"delete16"));
        this.m_deleteBtn.setEnabled(false);
        this.m_deleteBtn.addActionListener(this);
        ImageIcon icon = new ImageIcon(ImageCache.getImage("graph/bpel/partnerlink_20x20.png"));
        this.m_imageLbl = new JLabel(icon);
        this.m_imageLst = new JList(new DefaultListModel());
        this.m_imageLst.setSelectionMode(0);
        this.m_imageLst.setCellRenderer(new ListRenderer());
        this.m_imageLst.addListSelectionListener(this);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.createBrowserPanel(), (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected JComponent createBrowserPanel() {
        JToolBar tb = UIHelper.createToolBar();
        tb.add(this.m_addBtn);
        tb.add(this.m_deleteBtn);
        JPanel imgPnl = new JPanel();
        imgPnl.setBackground(Color.white);
        JPanel p = new JPanel(new GridBagLayout());
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, this.m_imageLst, BPELStringTranslator.getString("IMAGE_LBL"));
        GraphUtils.addComponent((Container)p, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(10, 0, 2, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JScrollPane(this.m_imageLst), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected void updateButtons() {
        this.m_deleteBtn.setEnabled(this.m_imageLst.getSelectedIndex() != -1);
    }

    protected void handleDeleteImage() {
        DefaultListModel model = (DefaultListModel)this.m_imageLst.getModel();
        int[] indices = this.m_imageLst.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            ListItem item = (ListItem)model.elementAt(indices[i]);
            if (item.m_entryName != null) {
                this.m_deleteList.add(item.m_entryName);
            }
            model.removeElementAt(indices[i]);
        }
        this.updateButtons();
    }

    protected void handleAddImage() {
        File[] files;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".gif", "GIF Files (*.gif)"));
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".jpg", "JPEG Files (*.jpg)"));
        chooser.addChoosableFileFilter((FileFilter)new DynamicFileFilter(".png", "PNG Files (*.png)"));
        chooser.setDialogTitle(BPELStringTranslator.getString("ADD_IMAGE", "Add Image"));
        int returnVal = chooser.showOpenDialog(GraphUtils.getFrame((Component)this));
        if (returnVal != 0) {
            return;
        }
        for (File file : files = chooser.getSelectedFiles()) {
            URL u = null;
            try {
                u = Helper.getURL((File)file);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                continue;
            }
            ImageIcon icon = new ImageIcon(u);
            ListItem item = new ListItem(icon, URLFileSystem.getFileName((URL)u), u);
            DefaultListModel model = (DefaultListModel)this.m_imageLst.getModel();
            model.insertElementAt(item, 0);
            this.m_imageLst.setSelectedValue(item, true);
            URL imgDir = BPELAddin.getUserDocumentationImagesDirectory();
            if (!URLFileSystem.exists((URL)imgDir)) {
                URLFileSystem.mkdir((URL)imgDir);
            }
            this.m_addList.add(u);
        }
        this.updateButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src == this.m_imageLst) {
            this.handleImageSelection();
        }
    }

    protected void handleImageSelection() {
        ListItem item = (ListItem)this.m_imageLst.getSelectedValue();
        if (item != null) {
            this.m_imageLbl.setIcon(item.m_icon);
        }
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleAddImage();
        } else if (src == this.m_deleteBtn) {
            this.handleDeleteImage();
        }
    }
}

