/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.documentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageInfo;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.documentation.NoteImageBrowser;
import oracle.tip.tools.ide.pm.bpelgraph.editors.documentation.NoteImageDataSource;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class DocumentationPanel
extends JPanel
implements ActionListener {
    protected JTextPane m_commentPane;
    protected JTextField m_labelField;
    protected JLabel m_imageLbl;
    protected JButton m_browseBtn;
    protected JButton m_clearBtn;
    protected BPELXmlModel m_model;
    protected Scope m_scope;
    protected String m_imageFile;

    public DocumentationPanel() {
        this.createControls();
        this.layoutControls();
    }

    public void setModels(BPELXmlModel model, Scope scope) {
        this.m_model = model;
        this.m_scope = scope;
    }

    public void save() {
        this.m_scope.setUserLabel(this.getLabel());
        this.m_scope.setUserComment(this.getComment());
        URL u = this.getSelectedImage();
        String img = u != null ? URLFileSystem.getFileName((URL)u) : "";
        this.m_scope.setUserImage(img);
    }

    public void load() {
        this.m_labelField.setText(this.m_scope.getUserLabel());
        this.m_commentPane.setText(this.m_scope.getUserComment());
        this.m_imageFile = this.m_scope.getUserImage();
        if (this.m_imageFile != null) {
            this.m_imageLbl.setIcon(ImageCache.getUserDocumentationIcon(this.m_imageFile));
        }
    }

    public URL getSelectedImage() {
        if (this.m_imageFile != null) {
            return ImageCache.getUserDocumentationPath(this.m_imageFile);
        }
        return null;
    }

    public String getLabel() {
        return this.m_labelField.getText();
    }

    public String getComment() {
        return this.m_commentPane.getText();
    }

    protected void createControls() {
        this.m_browseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_browseBtn.setToolTipText(BPELStringTranslator.getString("BROWSE_IMAGES"));
        this.m_browseBtn.addActionListener(this);
        this.m_clearBtn = new JButton(ImageCache.getIcon("garbage_empty16"));
        this.m_clearBtn.setToolTipText(BPELStringTranslator.getString("CLEAR_IMAGE"));
        this.m_clearBtn.addActionListener(this);
        this.m_imageLbl = new JLabel("", null, 0);
        this.m_imageLbl.setOpaque(true);
        this.m_imageLbl.setBorder(new LineBorder(Color.gray));
        this.m_imageLbl.setBackground(Color.white);
        this.m_labelField = new JTextField();
        this.m_commentPane = new JTextPane();
    }

    protected void layoutControls() {
        JToolBar tb = UIHelper.createToolBar();
        tb.add(this.m_browseBtn);
        tb.add(this.m_clearBtn);
        JLabel labelLbl = new JLabel();
        BPELStringTranslator.setLabel(labelLbl, this.m_labelField, BPELStringTranslator.getString("LABEL_LBL"));
        JLabel commentLbl = new JLabel();
        BPELStringTranslator.setLabel(commentLbl, this.m_commentPane, BPELStringTranslator.getString("COMMENT_LBL"));
        JLabel imgLbl = new JLabel();
        BPELStringTranslator.setLabel(imgLbl, this.m_imageLbl, BPELStringTranslator.getString("IMAGE_LBL"));
        JPanel imgPnl = new JPanel(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)imgPnl, (Component)imgLbl, (int)0, (int)row, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(0, 0, 2, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)imgPnl, (Component)tb, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)imgPnl, (Component)this.m_imageLbl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        this.setLayout(new GridBagLayout());
        row = 0;
        GraphUtils.addComponent((Container)this, (Component)labelLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_labelField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)commentLbl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JScrollPane(this.m_commentPane), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)imgPnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleBrowse() {
        ImageInfo info;
        NoteImageBrowser dlg = new NoteImageBrowser(IDEResolver.getIDE().getFrame(), new NoteImageDataSource());
        if (dlg.display() == 1 && (info = dlg.getSelection()) != null) {
            this.m_imageFile = URLFileSystem.getFileName((URL)info.getURL());
            this.m_imageLbl.setIcon(new ImageIcon(info.getImage()));
        }
    }

    protected void handleClear() {
        this.m_imageFile = null;
        this.m_imageLbl.setIcon(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_browseBtn) {
            this.handleBrowse();
        } else if (src == this.m_clearBtn) {
            this.handleClear();
        }
    }
}

