/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.assertions;

import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.IAssert;
import oracle.tip.tools.ide.common.ui.BaseTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class AssertionsTableModel
extends BaseTableModel<IAssert> {
    public static final int IMAGE_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int EXPRESSION_COLUMN = 2;
    public static final int FAULT_NAME_COLUMN = 3;
    public static final int MESSAGE_COLUMN = 4;

    public Object getValueAt(int row, int col) {
        if (row < this.m_data.size()) {
            IAssert assertion = (IAssert)this.getRowData(row);
            switch (col) {
                case 1: {
                    return assertion.getName();
                }
                case 2: {
                    return assertion.getExpression();
                }
                case 3: {
                    QName qname = assertion.getFaultName();
                    if (qname != null) {
                        return qname.toString();
                    }
                    return "";
                }
                case 4: {
                    return assertion.getMessage();
                }
            }
            return "";
        }
        return null;
    }

    public void setValueAt(Object obj, int i, int j) {
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return BPELStringTranslator.getString("NAME");
            }
            case 2: {
                return BPELStringTranslator.getString("EXPRESSION");
            }
            case 3: {
                return BPELStringTranslator.getString("FAULT_NAME");
            }
            case 4: {
                return BPELStringTranslator.getString("MESSAGE");
            }
        }
        return " ";
    }
}

