/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.assertions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.IAssert;
import oracle.tip.tools.ide.common.bpelparser.iface.ICanAssert;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.JTableCellRendererExtendor;
import oracle.tip.tools.ide.common.ui.SortableTable;
import oracle.tip.tools.ide.common.ui.SortedTableHeaderRenderer;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.assertions.AssertDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.assertions.AssertionsTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;

public class AssertionsPage
extends BaseEditingPage
implements ActionListener,
ListSelectionListener {
    protected JButton m_addBtn;
    protected JButton m_deleteBtn;
    protected JButton m_editBtn;
    protected JTable m_table;
    protected ICanAssert m_assertionActivity;

    public AssertionsPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void setUserObject(Object obj) {
        super.setUserObject(obj);
        this.m_assertionActivity = (ICanAssert)obj;
        this.load();
    }

    protected void load() {
        AssertionsTableModel model = (AssertionsTableModel)((Object)this.m_table.getModel());
        ArrayList data = new ArrayList();
        data.addAll(this.m_assertionActivity.getAssertions());
        model.setData(data);
        model.refresh();
        this.updateButtons();
    }

    @Override
    public void saveChanges() {
        AssertionsTableModel model = (AssertionsTableModel)((Object)this.m_table.getModel());
        List uiAsserts = model.getData();
        List modelAsserts = this.m_assertionActivity.getAssertions();
        ArrayList<IAssert> deleteLst = new ArrayList<IAssert>();
        for (IAssert modelAssert : modelAsserts) {
            if (uiAsserts.contains(modelAssert)) continue;
            deleteLst.add(modelAssert);
        }
        ArrayList<IAssert> addLst = new ArrayList<IAssert>();
        for (IAssert uiAssert : uiAsserts) {
            if (modelAsserts.contains(uiAssert)) continue;
            addLst.add(uiAssert);
        }
        if (deleteLst.size() > 0) {
            this.m_assertionActivity.deleteAssertions(deleteLst);
        }
        for (IAssert a : addLst) {
            this.m_assertionActivity.addAssertion(a);
        }
    }

    protected void updateButtons() {
        ListSelectionModel selModel = this.m_table.getSelectionModel();
        int minIdx = selModel.getMinSelectionIndex();
        int maxIdx = selModel.getMaxSelectionIndex();
        this.m_deleteBtn.setEnabled(!selModel.isSelectionEmpty());
        this.m_editBtn.setEnabled(minIdx == maxIdx && !selModel.isSelectionEmpty());
    }

    protected void sortTable(final int col, final boolean bAscending) {
        AssertionsTableModel model = (AssertionsTableModel)((Object)this.m_table.getModel());
        Comparator<IAssert> c = new Comparator<IAssert>(){

            @Override
            public int compare(IAssert a1, IAssert a2) {
                String s1 = null;
                String s2 = null;
                switch (col) {
                    case 1: {
                        s1 = a1.getName();
                        s2 = a2.getName();
                        break;
                    }
                    case 2: {
                        s1 = a1.getExpression();
                        s2 = a2.getExpression();
                        break;
                    }
                    case 4: {
                        s1 = a1.getMessage();
                        s2 = a2.getMessage();
                        break;
                    }
                    case 3: {
                        QName q2;
                        QName q1 = a1.getFaultName();
                        if (q1 != null) {
                            s1 = q1.toString();
                        }
                        if ((q2 = a2.getFaultName()) == null) break;
                        s2 = q2.toString();
                        break;
                    }
                }
                if (s1 == null || s2 == null) {
                    return 0;
                }
                if (bAscending) {
                    return s1.compareTo(s2);
                }
                return s2.compareTo(s1);
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof IAssert && obj.equals(this);
            }
        };
        Collections.sort(model.getData(), c);
        model.refresh();
    }

    protected void setupTable() {
        this.m_table = new JTable((TableModel)((Object)new AssertionsTableModel()));
        new JTableCellRendererExtendor(this.m_table);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        SortableTable st = new SortableTable(){

            public void sortColumn(int col, boolean bAscending) {
                AssertionsPage.this.sortTable(col, bAscending);
            }

            public JTable getJTable() {
                return AssertionsPage.this.m_table;
            }

            public int getSortingColumn() {
                return 1;
            }

            public boolean getSortAscending() {
                return true;
            }
        };
        SortedTableHeaderRenderer header = new SortedTableHeaderRenderer(st);
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setHeaderRenderer((TableCellRenderer)header);
            col.setPreferredWidth(60);
            col.setWidth(60);
            if (i != 0) continue;
            col.setMinWidth(30);
            col.setMaxWidth(30);
            col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(ImageCache.getIcon("assert16")));
        }
        this.m_table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    e.consume();
                    AssertionsPage.this.handleDelete();
                } else if (e.getKeyCode() == 10) {
                    AssertionsPage.this.handleEdit();
                    e.consume();
                }
            }
        });
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = AssertionsPage.this.m_table.rowAtPoint(origin);
                int column = AssertionsPage.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    AssertionsPage.this.handleEdit();
                }
            }
        });
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("ASSERTIONS");
    }

    protected void createControls() {
        this.m_addBtn = new JButton(ImageCache.getIcon("add16"));
        this.m_addBtn.addActionListener(this);
        this.m_deleteBtn = new JButton(ImageCache.getIcon("delete16"));
        this.m_deleteBtn.addActionListener(this);
        this.m_editBtn = new JButton(ImageCache.getIcon("edit16"));
        this.m_editBtn.addActionListener(this);
        this.setupTable();
    }

    protected void layoutControls() {
        JToolBar tb = UIHelper.createToolBar();
        tb.add(this.m_addBtn);
        tb.add(this.m_editBtn);
        tb.add(this.m_deleteBtn);
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, this.m_table, BPELStringTranslator.getString("ASSERTIONS_LBL"));
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(10, 10, 2, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleCreate() {
        Document doc = this.m_processModel.getDOMElement().getOwnerDocument();
        IAssert a = (IAssert)BPELParser.getImplementationFactory().createImplementation(IAssert.class);
        a.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        AssertionsTableModel model = (AssertionsTableModel)((Object)this.m_table.getModel());
        int cnt = Math.max(1, model.getRowCount());
        String testName = "Assert_" + cnt;
        while (true) {
            boolean bUnique = true;
            for (IAssert as : model.getData()) {
                if (!Helper.isEqual((String)as.getName(), (String)testName)) continue;
                bUnique = false;
                break;
            }
            if (bUnique) break;
            testName = "Assert_" + ++cnt;
        }
        a.setName(testName);
        AssertDialog dlg = new AssertDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_graphPane.getBPELXmlModel(), (Activity)this.m_assertionActivity);
        if (dlg.display(a) == 1) {
            model.getData().add(a);
            model.refresh();
            this.updateButtons();
        }
    }

    protected void handleEdit() {
        AssertionsTableModel model = (AssertionsTableModel)((Object)this.m_table.getModel());
        int row = this.m_table.getSelectionModel().getLeadSelectionIndex();
        if (row != -1) {
            IAssert a = (IAssert)model.getRowData(row);
            AssertDialog dlg = new AssertDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_graphPane.getBPELXmlModel(), (Activity)this.m_assertionActivity);
            dlg.display(a);
            model.refreshRow(row);
        }
    }

    protected void handleDelete() {
        AssertionsTableModel model = (AssertionsTableModel)((Object)this.m_table.getModel());
        int[] rows = this.m_table.getSelectedRows();
        if (rows != null) {
            model.removeRows(rows);
        }
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleCreate();
        } else if (src == this.m_editBtn) {
            this.handleEdit();
        } else if (src == this.m_deleteBtn) {
            this.handleDelete();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }
}

