/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors.assertions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.wsdl.Fault;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.IAssert;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.expressionbuilder.BpelExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.ExpressionBuilderUsecases;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault.FaultChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class AssertPanel
extends JPanel
implements ActionListener {
    protected JButton m_wsdlFaultBrowseBtn;
    protected JTextField m_faultNamespaceURIField;
    protected JTextField m_faultLocalPartField;
    protected JTextField m_nameField;
    protected JTextField m_messageField;
    protected JTextField m_expressionField;
    protected JButton m_expressionBtn;
    protected JPanel m_faultPnl;
    protected BPELXmlModel m_model;
    protected BPELGraphPane m_graph;
    protected Activity m_activity;
    protected IAssert m_assert;

    public AssertPanel(BPELGraphPane graph, BPELXmlModel model, Activity a) {
        this.m_graph = graph;
        this.m_model = model;
        this.m_activity = a;
        this.createControls();
        this.layoutControls();
    }

    protected JPanel createFaultNamePanel() {
        this.m_faultNamespaceURIField = new JTextField();
        this.m_faultLocalPartField = new JTextField();
        this.m_wsdlFaultBrowseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_wsdlFaultBrowseBtn.setToolTipText(BPELStringTranslator.getString("BROWSE_FAULTS_TIP"));
        this.m_wsdlFaultBrowseBtn.addActionListener(this);
        JToolBar tb3 = UIHelper.createToolBar();
        tb3.add(this.m_wsdlFaultBrowseBtn);
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_CGE_FAULT_QNAME")));
        int row = 0;
        JLabel lblNS = new JLabel();
        BPELStringTranslator.setLabel(lblNS, this.m_faultNamespaceURIField, BPELStringTranslator.getString("EDITOR_CGE_FAULT_NS"));
        GraphUtils.addComponent((Container)p, (Component)tb3, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)lblNS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_faultNamespaceURIField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel lblLP = new JLabel();
        BPELStringTranslator.setLabel(lblLP, this.m_faultLocalPartField, BPELStringTranslator.getString("EDITOR_CGE_FAULT_LP"));
        GraphUtils.addComponent((Container)p, (Component)lblLP, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_faultLocalPartField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }

    public void save() {
        this.m_assert.setName(this.m_nameField.getText());
        this.m_assert.setExpression(this.m_expressionField.getText());
        this.m_assert.setMessage(this.m_messageField.getText());
        String ns = this.m_faultNamespaceURIField.getText();
        String local = this.m_faultLocalPartField.getText();
        Process process = this.m_model.getProcess();
        String prefix = process.addNamespace(ns);
        QName qname = new QName(ns, local, prefix);
        this.m_assert.setFaultName(qname);
    }

    public void load(IAssert a) {
        this.m_assert = a;
        this.m_nameField.setText(a.getName());
        this.m_messageField.setText(a.getMessage());
        this.m_expressionField.setText(a.getExpression());
        QName fault = a.getFaultName();
        if (fault != null) {
            String ns = fault.getNamespaceURI();
            if (ns != null) {
                this.m_faultNamespaceURIField.setText(ns);
            } else {
                ns = this.m_model.getProcess().getNamespaceForPrefix(fault.getPrefix());
                if (ns != null) {
                    this.m_faultNamespaceURIField.setText(ns);
                }
            }
            this.m_faultLocalPartField.setText(fault.getLocalPart());
        } else {
            this.m_faultNamespaceURIField.setText("");
            this.m_faultLocalPartField.setText("");
        }
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_messageField = new JTextField();
        this.m_expressionField = new JTextField();
        this.m_expressionBtn = new JButton(ImageCache.getIcon("edit_expression16"));
        this.m_expressionBtn.setToolTipText(BPELStringTranslator.getString("LAUNCH_EXPRESSION_BUILDER_TIP"));
        this.m_expressionBtn.addActionListener(this);
        this.m_faultPnl = this.createFaultNamePanel();
    }

    protected void layoutControls() {
        JToolBar tb2 = UIHelper.createToolBar();
        tb2.add(this.m_expressionBtn);
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("NAME_LBL"));
        JLabel msgLbl = new JLabel();
        BPELStringTranslator.setLabel(msgLbl, this.m_messageField, BPELStringTranslator.getString("MESSAGE_LBL"));
        JLabel exprLbl = new JLabel();
        BPELStringTranslator.setLabel(exprLbl, this.m_expressionField, BPELStringTranslator.getString("EXPRESSION_LBL"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)msgLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(7, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_messageField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(7, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)exprLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_expressionField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb2, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(4, 5, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_faultPnl, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(7, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(10, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void showExpressionBuilder() {
        MapperNSResolver nsResolver = NSResolverFactory.getNSResolver((Activity)this.m_activity, (Process)this.m_model.getProcess());
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(this.m_model, this.m_activity, (NamespaceResolver)nsResolver);
        VariablePickerPanel p = new VariablePickerPanel(this.m_graph, dataCallBack, (NamespaceResolver)nsResolver);
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, this.m_activity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, ExpressionBuilderUsecases.createFunctionsExpressionBuilderPicker((NamespaceResolver)nsResolver, (int)2)};
        XPathEditorPane pane = new XPathEditorPane();
        pane.initializeDocument();
        pane.initializeEditorPane((VariableDataCallBack)dataCallBack, this.m_expressionField.getText(), (NamespaceResolver)nsResolver, false);
        BpelExpressionBuilder dlg = new BpelExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.m_graph)), (JTextComponent)pane, pickers);
        if (dlg.display() == 0) {
            this.m_expressionField.setText(dlg.getExpressionText());
        }
    }

    protected void handleWSDLFaultBrowse() {
        Fault f;
        FaultChooser chooser = new FaultChooser(GraphUtils.getFrame((Component)this), this.m_graph);
        if (chooser.display() == 0 && (f = chooser.getFault()) != null) {
            String nsURI = chooser.getFaultNamespace();
            this.m_faultNamespaceURIField.setText(nsURI);
            this.m_faultLocalPartField.setText(f.getName());
            if (f.getMessage() != null) {
                QName faultQName = f.getMessage().getQName();
            } else if ("http://schemas.oracle.com/bpel/extension".equals(nsURI)) {
                QName faultQName = new QName(nsURI, "RuntimeFaultMessage");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_expressionBtn) {
            this.showExpressionBuilder();
        } else if (src == this.m_wsdlFaultBrowseBtn) {
            this.handleWSDLFaultBrowse();
        }
    }
}

