/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ide.util.ModelUtil;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.While;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class WhileGenEditPage
extends BaseEditingPage
implements ActionListener {
    private JScrollPane m_condScrollPane;
    private XPathEditorPane m_condExpBuilder;
    protected JButton m_expressionBuilderBtn;
    protected While m_activity;

    public WhileGenEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_condExpBuilder = new XPathEditorPane();
        this.m_condScrollPane = new JScrollPane((Component)this.m_condExpBuilder, 20, 30);
        this.m_condExpBuilder.setEditable(true);
        this.m_expressionBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_expressionBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_expressionBuilderBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JLabel exprLbl = new JLabel();
        BPELStringTranslator.setLabel(exprLbl, (Component)this.m_condExpBuilder, BPELStringTranslator.getString("EDITOR_WHILE_EXP"));
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_expressionBuilderBtn);
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)exprLbl, (int)0, (int)row, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(10, 10, 2, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_condScrollPane, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (While)model;
        this.loadControls();
    }

    protected void loadControls() {
        if (this.m_activity == null) {
            return;
        }
        this.m_nsResolver = NSResolverFactory.getNSResolver((Activity)this.m_activity, (Process)this.m_processModel);
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        VariableDataCallBackImpl forDataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)this.m_activity, this.m_nsResolver);
        this.m_condExpBuilder.initializeDocument();
        this.m_condExpBuilder.initializeEditorPane((VariableDataCallBack)forDataCallBack, this.m_activity.getCondition(), this.m_nsResolver, false, false);
    }

    @Override
    public boolean validateEditorChanges() {
        if (!ModelUtil.hasLength((String)this.m_condExpBuilder.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_SW_CASE_GEN_NO_EXP"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)0);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setCondition(this.m_condExpBuilder.getText());
        this.m_condExpBuilder.saveCachedNS();
        this.fireProcessChangedEvent(28);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_expressionBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_condExpBuilder, (Activity)this.m_activity);
        }
    }
}

