/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import oracle.ide.util.ModelUtil;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Duration;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.DatetimeExpressionUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.DurationExpressionUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Wait;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.DurationSpinner;
import oracle.tip.tools.ide.common.ui.DurationSpinnerModel;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.XPathScrollPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TextFieldListener;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class WaitEditPage
extends BaseEditingPage
implements ActionListener {
    protected static int MAX_YEARS_ALLOWED = 100;
    protected static int MAX_MONTHS_ALLOWED = 1200;
    protected static int MAX_DAYS_ALLOWED = 36500;
    protected JTextField m_nameField;
    protected JScrollPane m_forScrollPane;
    protected XPathEditorPane m_forExpBuilder;
    protected JButton m_forExpressionBuilderBtn;
    protected JRadioButton m_forTimeBtn;
    protected JRadioButton m_forExpBtn;
    protected JSpinner m_forYearSpinner;
    protected JSpinner m_forMonthSpinner;
    protected JSpinner m_forDaySpinner;
    protected JSpinner m_forTimeSpinner;
    protected JSpinner m_untilDateSpinner;
    protected JScrollPane m_untilScrollPane;
    protected XPathEditorPane m_untilExpBuilder;
    protected JButton m_untilExpressionBuilderBtn;
    protected JLabel m_untilExprLbl;
    protected JLabel m_untilTimeLbl;
    protected JLabel m_forTimeLbl;
    protected JLabel m_forExprLbl;
    protected JRadioButton m_untilTimeBtn;
    protected JRadioButton m_untilExpBtn;
    protected DurationSpinner m_forSpinner;
    protected Wait m_activity;

    public WaitEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Wait)model;
        this.loadControls();
    }

    public void setFocus() {
        this.m_nameField.requestFocus();
    }

    protected void loadControls() {
        if (this.m_activity == null) {
            return;
        }
        if (this.m_activity.getName() != null) {
            this.m_nameField.setText(this.m_activity.getName());
        }
        String forInitStr = "";
        String untilInitStr = "";
        if (this.m_activity.getFor() != null) {
            String forStr = this.m_activity.getFor();
            if (forStr.startsWith("'") && forStr.endsWith("'")) {
                forStr = forStr.substring(1, forStr.length() - 1);
            }
            Duration dur = null;
            try {
                dur = DurationExpressionUtil.parseDurationExpression((String)forStr);
            }
            catch (IllegalArgumentException ile) {
                // empty catch block
            }
            if (dur != null) {
                DurationSpinnerModel model = (DurationSpinnerModel)this.m_forSpinner.getModel();
                model.setDuration(dur);
                this.setIntModelValue(this.m_forYearSpinner, dur.getYear());
                this.setIntModelValue(this.m_forMonthSpinner, dur.getMonth());
                this.setIntModelValue(this.m_forDaySpinner, dur.getDay());
                this.setTimeModelValue(this.m_forTimeSpinner, dur);
                this.m_forTimeBtn.setSelected(true);
            } else {
                forInitStr = this.m_activity.getFor();
                this.m_forExpBtn.setSelected(true);
            }
        } else if (this.m_activity.getUntil() != null) {
            String untilStr = this.m_activity.getUntil();
            if (untilStr.startsWith("'") && untilStr.endsWith("'")) {
                untilStr = untilStr.substring(1, untilStr.length() - 1);
            }
            Calendar cal = null;
            try {
                cal = DatetimeExpressionUtil.parseDateTimeExpression((String)untilStr);
            }
            catch (IllegalArgumentException ile) {
                // empty catch block
            }
            if (cal != null) {
                this.m_untilDateSpinner.getModel().setValue(cal.getTime());
                this.m_untilTimeBtn.setSelected(true);
            } else {
                untilInitStr = this.m_activity.getUntil();
                this.m_untilExpBtn.setSelected(true);
            }
        } else {
            this.m_forTimeBtn.setSelected(true);
        }
        this.m_nsResolver = NSResolverFactory.getNSResolver((Activity)this.m_activity, (Process)this.m_processModel);
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        VariableDataCallBackImpl forDataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)this.m_activity, this.m_nsResolver);
        this.m_forExpBuilder.initializeEditorPane((VariableDataCallBack)forDataCallBack, forInitStr, this.m_nsResolver, false, false);
        this.m_untilExpBuilder.initializeEditorPane((VariableDataCallBack)forDataCallBack, untilInitStr, this.m_nsResolver, false, false);
        this.enablePanels();
    }

    private void setIntModelValue(JSpinner spinner, Integer i) {
        if (i == null) {
            return;
        }
        spinner.getModel().setValue(i);
    }

    private void setTimeModelValue(JSpinner spinner, Duration d) {
        Calendar cal = Calendar.getInstance();
        if (d.getHour() != null) {
            cal.set(11, d.getHour());
        } else {
            cal.set(11, 0);
        }
        if (d.getMinute() != null) {
            cal.set(12, d.getMinute());
        } else {
            cal.set(12, 0);
        }
        if (d.getSecond() != null) {
            cal.set(13, d.getSecond());
        } else {
            cal.set(13, 0);
        }
        spinner.getModel().setValue(cal.getTime());
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_nameField.getDocument().addDocumentListener(new TextFieldListener(this));
        FieldFocusListner listener = new FieldFocusListner();
        this.m_forExpBuilder = new XPathEditorPane();
        this.m_forScrollPane = new XPathScrollPane((Component)this.m_forExpBuilder, 21, 31);
        this.m_forExpBuilder.setEditable(true);
        this.m_forExpBuilder.addFocusListener((FocusListener)listener);
        this.m_forExpressionBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_forExpressionBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_forExpressionBuilderBtn.addActionListener(this);
        this.m_forYearSpinner = this.createNumberSpinner(MAX_YEARS_ALLOWED, listener);
        this.m_forMonthSpinner = this.createNumberSpinner(MAX_MONTHS_ALLOWED, listener);
        this.m_forDaySpinner = this.createNumberSpinner(MAX_DAYS_ALLOWED, listener);
        this.m_forTimeSpinner = this.createTimeSpinner(listener);
        this.m_untilExpBuilder = new XPathEditorPane();
        this.m_untilScrollPane = new XPathScrollPane((Component)this.m_untilExpBuilder, 21, 31);
        this.m_untilExpBuilder.setEditable(true);
        this.m_untilExpBuilder.addFocusListener((FocusListener)listener);
        this.m_untilExpressionBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_untilExpressionBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_untilExpressionBuilderBtn.addActionListener(this);
        this.m_untilDateSpinner = this.createDateTimeSpinner(listener);
        this.m_untilTimeBtn = new JRadioButton();
        this.m_untilTimeBtn.addActionListener(this);
        this.m_untilExpBtn = new JRadioButton();
        this.m_untilExpBtn.addActionListener(this);
        this.m_forTimeBtn = new JRadioButton();
        this.m_forTimeBtn.addActionListener(this);
        this.m_forExpBtn = new JRadioButton();
        this.m_forExpBtn.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_forTimeBtn);
        group.add(this.m_forExpBtn);
        group.add(this.m_untilTimeBtn);
        group.add(this.m_untilExpBtn);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JLabel lblName = new JLabel();
        BPELStringTranslator.setLabel(lblName, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        GraphUtils.addComponent((Container)this, (Component)lblName, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.createForPanel(), (int)0, (int)1, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.createUntilPanel(), (int)0, (int)2, (int)2, (int)1, (int)18, (int)2, (Insets)new Insets(0, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    private JSpinner createNumberSpinner(int max, FocusListener listener) {
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, max, 1);
        JSpinner spinner = new JSpinner(model);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "#");
        spinner.setEditor(editor);
        JFormattedTextField ftf = editor.getTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ftf.addFocusListener(listener);
        return spinner;
    }

    private JSpinner createTimeSpinner(FocusListener listener) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 1);
        SpinnerDateModel timeModel = new SpinnerDateModel(cal.getTime(), null, null, 13);
        JSpinner spinner = new JSpinner(timeModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(spinner, BPELStringTranslator.getString("EDITOR_TIME_SPINNER_FORMAT"));
        spinner.setEditor(dateEditor);
        JFormattedTextField ftf = dateEditor.getTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        ftf.addFocusListener(listener);
        return spinner;
    }

    private JSpinner createDateTimeSpinner(FocusListener listener) {
        Calendar calTime = Calendar.getInstance();
        calTime.add(13, 2);
        Date initDate = calTime.getTime();
        calTime.add(1, MAX_YEARS_ALLOWED);
        Date endDate = calTime.getTime();
        SpinnerDateModel timeModel = new SpinnerDateModel(initDate, null, endDate, 13);
        JSpinner spinner = new JSpinner(timeModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(spinner, BPELStringTranslator.getString("EDITOR_DATE_SPINNER_FORMAT"));
        spinner.setEditor(dateEditor);
        JFormattedTextField ftf = dateEditor.getTextField();
        ftf.setHorizontalAlignment(4);
        ftf.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        ftf.addFocusListener(listener);
        return spinner;
    }

    private JPanel createForPanel() {
        JPanel forPanel = new JPanel(new GridBagLayout());
        forPanel.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_WAIT_ALARM_FOR")));
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel lblYear = new JLabel();
        BPELStringTranslator.setLabel(lblYear, this.getTextField(this.m_forYearSpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_YEAR"));
        JLabel lblMonth = new JLabel();
        BPELStringTranslator.setLabel(lblMonth, this.getTextField(this.m_forMonthSpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_MON"));
        JLabel lblDay = new JLabel();
        BPELStringTranslator.setLabel(lblDay, this.getTextField(this.m_forDaySpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_DAY"));
        JLabel lblTime = new JLabel();
        BPELStringTranslator.setLabel(lblTime, this.getTextField(this.m_forTimeSpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_FOR_TIME"));
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_forExpressionBuilderBtn);
        this.m_forTimeLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_forTimeLbl, (Component)this.m_forSpinner, "T&ime:");
        this.m_forSpinner = new DurationSpinner();
        GraphUtils.addComponent((Container)panel, (Component)this.m_forTimeLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_forSpinner, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        JPanel expressionPnl = new JPanel(new GridBagLayout());
        this.m_forExprLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_forExprLbl, (Component)this.m_forExpBuilder, BPELStringTranslator.getString("EDITOR_WAIT_ALARM_FOR_EXP") + ":");
        GraphUtils.addComponent((Container)expressionPnl, (Component)this.m_forExprLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)expressionPnl, (Component)this.m_forScrollPane, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.5, (double)0.0);
        GraphUtils.addComponent((Container)expressionPnl, (Component)tb, (int)2, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)forPanel, (Component)this.m_forTimeBtn, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)forPanel, (Component)panel, (int)1, (int)0, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)forPanel, (Component)this.m_forExpBtn, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)forPanel, (Component)expressionPnl, (int)1, (int)1, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return forPanel;
    }

    private JPanel createUntilPanel() {
        JPanel untilPanel = new JPanel(new GridBagLayout());
        untilPanel.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_WAIT_ALARM_UNTIL")));
        JPanel panel = new JPanel(new GridBagLayout());
        this.m_untilTimeLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_untilTimeLbl, this.getTextField(this.m_untilDateSpinner), BPELStringTranslator.getString("EDITOR_WAIT_ALARM_UNTIL_TIME") + ":");
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_untilExpressionBuilderBtn);
        GraphUtils.addComponent((Container)panel, (Component)this.m_untilTimeLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_untilDateSpinner, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JPanel expanel = new JPanel(new GridBagLayout());
        this.m_untilExprLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_untilExprLbl, (Component)this.m_untilExpBuilder, BPELStringTranslator.getString("EDITOR_WAIT_ALARM_UNTIL_EXP") + ":");
        GraphUtils.addComponent((Container)expanel, (Component)this.m_untilExprLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)expanel, (Component)this.m_untilScrollPane, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.5, (double)0.0);
        GraphUtils.addComponent((Container)expanel, (Component)tb, (int)2, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)untilPanel, (Component)this.m_untilTimeBtn, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)untilPanel, (Component)panel, (int)1, (int)0, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)untilPanel, (Component)this.m_untilExpBtn, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)untilPanel, (Component)expanel, (int)1, (int)1, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return untilPanel;
    }

    private JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return null;
    }

    @Override
    public boolean validateEditorChanges() {
        if (!ModelUtil.hasLength((String)this.m_nameField.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_ERROR"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)0);
            return false;
        }
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)0);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setName(this.m_nameField.getText());
        if (this.m_forTimeBtn.isSelected()) {
            Duration duration = new Duration();
            DurationSpinnerModel m = (DurationSpinnerModel)this.m_forSpinner.getModel();
            duration.setYear(new Integer(m.getYears()));
            duration.setMonth(new Integer(m.getMonths()));
            duration.setDay(new Integer(m.getDays()));
            duration.setHourOfDay(new Integer(m.getHours()));
            duration.setMinute(new Integer(m.getMinutes()));
            duration.setSecond(new Integer(m.getSeconds()));
            this.m_activity.setFor("'" + DurationExpressionUtil.getDurationExpression((Duration)duration) + "'");
            this.m_activity.setUntil(null);
        } else if (this.m_forExpBtn.isSelected()) {
            this.m_activity.setFor(this.m_forExpBuilder.getText());
            this.m_activity.setUntil(null);
            this.m_forExpBuilder.saveCachedNS();
        } else if (this.m_untilTimeBtn.isSelected()) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime((Date)this.m_untilDateSpinner.getValue());
            this.m_activity.setUntil("'" + DatetimeExpressionUtil.getDateTimeString((Calendar)cal) + "'");
            this.m_activity.setFor(null);
        } else {
            this.m_activity.setUntil(this.m_untilExpBuilder.getText());
            this.m_activity.setFor(null);
            this.m_untilExpBuilder.saveCachedNS();
        }
        this.fireProcessChangedEvent(28);
    }

    protected void enableForUntil(boolean bEnable) {
        this.m_forSpinner.setEnabled(bEnable);
        this.m_forTimeLbl.setEnabled(bEnable);
    }

    protected void enableForExpression(boolean bEnable) {
        this.m_forExpressionBuilderBtn.setEnabled(bEnable);
        this.m_forExpBuilder.setEnabled(bEnable);
        this.m_forExprLbl.setEnabled(bEnable);
    }

    protected void enableUntilTime(boolean bEnable) {
        this.m_untilDateSpinner.setEnabled(bEnable);
        this.m_untilTimeLbl.setEnabled(bEnable);
    }

    protected void enableUntilExpression(boolean bEnable) {
        this.m_untilExpBuilder.setEnabled(bEnable);
        this.m_untilExprLbl.setEnabled(bEnable);
        this.m_untilExpressionBuilderBtn.setEnabled(bEnable);
    }

    protected void enablePanels() {
        if (this.m_forExpBtn.isSelected()) {
            this.enableForUntil(false);
            this.enableForExpression(true);
            this.enableUntilTime(false);
            this.enableUntilExpression(false);
        } else if (this.m_forTimeBtn.isSelected()) {
            this.enableForUntil(true);
            this.enableForExpression(false);
            this.enableUntilTime(false);
            this.enableUntilExpression(false);
        } else if (this.m_untilExpBtn.isSelected()) {
            this.enableForUntil(false);
            this.enableForExpression(false);
            this.enableUntilTime(false);
            this.enableUntilExpression(true);
        } else if (this.m_untilTimeBtn.isSelected()) {
            this.enableForUntil(false);
            this.enableForExpression(false);
            this.enableUntilTime(true);
            this.enableUntilExpression(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_forExpressionBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_forExpBuilder, (Activity)this.m_activity);
            if (this.m_forExpBuilder.getText() != null) {
                this.m_forExpBtn.setSelected(true);
            }
        } else if (src == this.m_untilExpressionBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_untilExpBuilder, (Activity)this.m_activity);
            if (this.m_untilExpBuilder.getText() != null) {
                this.m_untilExpBtn.setSelected(true);
            }
        } else if (src == this.m_forExpBtn || src == this.m_forTimeBtn || src == this.m_untilExpBtn || src == this.m_untilTimeBtn) {
            this.enablePanels();
        }
    }

    class FieldFocusListner
    implements FocusListener {
        FieldFocusListner() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object src = e.getSource();
            WaitEditPage.this.setModified(true);
            if (src == WaitEditPage.this.m_forExpBuilder) {
                WaitEditPage.this.m_forExpBtn.setSelected(true);
            } else if (src == WaitEditPage.this.m_untilExpBuilder) {
                WaitEditPage.this.m_untilExpBtn.setSelected(true);
            } else if (src == WaitEditPage.this.getTextField(WaitEditPage.this.m_untilDateSpinner)) {
                WaitEditPage.this.m_untilTimeBtn.setSelected(true);
            } else {
                WaitEditPage.this.m_forTimeBtn.setSelected(true);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

