/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.JTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.TreeTableModelAdapter;

public class VariablesTreeTable
extends JTreeTable {
    TreeTableModel m_model;

    public VariablesTreeTable(TreeTableModel model) {
        super(model);
        this.getTableHeader().setReorderingAllowed(false);
    }

    public TreeTableModel getTreeTableModel() {
        return this.m_model;
    }

    public void refreshSelectedNode() {
        int row = this.getSelectedRow();
        this.fireTableRowsInserted(row, this.tree.getRowCount() + 1);
    }

    public void printRowCount() {
        TreeTableModelAdapter adapter = (TreeTableModelAdapter)this.getModel();
        System.out.println("printRowCount rowcount = " + adapter.getRowCount());
    }

    public void fireTableRowsInserted(final int firstRow, final int lastRow) {
        final TreeTableModelAdapter adapter = (TreeTableModelAdapter)this.getModel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("fireTableRowsInserted firstRow = " + firstRow + "  lastRow=" + lastRow);
                adapter.fireTableRowsInserted(firstRow, lastRow);
            }
        });
    }

    public void setModel(TreeTableModel treeTableModel) {
        this.m_model = treeTableModel;
        MyAdapter adapter = new MyAdapter(treeTableModel, (JTree)this.tree);
        this.tree.setModel((TreeModel)treeTableModel);
        super.setModel((TableModel)((Object)adapter));
    }

    public void expandAll() {
        VariablesTreeTable.expandTree((JTree)this.tree);
    }

    public static void expandTree(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreePath path = new TreePath(root);
        for (int k = 0; k < root.getChildCount(); ++k) {
            TreeNode child = root.getChildAt(k);
            VariablesTreeTable.expandTree(tree, path, child);
        }
    }

    public static void expandTree(JTree tree, TreePath path, TreeNode node) {
        if (path == null || node == null) {
            return;
        }
        tree.expandPath(path);
        TreePath newPath = path.pathByAddingChild(node);
        for (int k = 0; k < node.getChildCount(); ++k) {
            TreeNode child = node.getChildAt(k);
            if (child == null) continue;
            VariablesTreeTable.expandTree(tree, newPath, child);
        }
    }

    public TreePath getSelectedPath() {
        int row = this.getSelectedRow();
        if (row != -1) {
            return this.tree.getPathForRow(row);
        }
        return null;
    }

    class MyAdapter
    extends TreeTableModelAdapter {
        public MyAdapter(TreeTableModel treeTableModel, JTree tree) {
            super(treeTableModel, tree);
        }

        public int getRowCount() {
            int rowCnt = super.getRowCount();
            System.out.println("MyAdapter rowCnt = " + rowCnt);
            return rowCnt;
        }
    }
}

