/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class VariablesTableModel
extends BaseTableModel {
    public static final int IMAGE_COL = 0;
    public static final int NAME_COL = 1;
    public static final int TYPE_COL = 2;
    public static final int QNAME_COL = 3;
    public static final int PLINK_COL = 4;
    private boolean m_bExpandNamespaces = false;

    public void setExpandNamespaces(boolean bExpand) {
        this.m_bExpandNamespaces = bExpand;
        this.refresh();
    }

    public int getColumnCount() {
        return 5;
    }

    public Object getValueAt(int row, int col) {
        Variable v = (Variable)this.m_data.get(row);
        switch (col) {
            case 0: {
                return "";
            }
            case 1: {
                return v.getName();
            }
            case 2: {
                QName name = v.getMessageType();
                if (name != null) {
                    return "MessageType";
                }
                name = v.getElement();
                if (name != null) {
                    return "Element";
                }
                name = v.getType();
                if (name != null) {
                    return "Simple Type";
                }
                return "";
            }
            case 3: {
                QName qname = v.getVariableTypeQName();
                if (qname != null) {
                    return this.m_bExpandNamespaces ? BPELModelUtil.getExpandedName((QName)qname) : BPELModelUtil.getPrefixQualifiedName((QName)qname);
                }
                return null;
            }
            case 4: {
                String plink = v.getPartnerlink();
                return plink;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return BPELStringTranslator.getString("EDITOR_VAR_TBL_MDL_NAME");
            }
            case 2: {
                return BPELStringTranslator.getString("EDITOR_VAR_TBL_MDL_TYPE");
            }
            case 3: {
                return BPELStringTranslator.getString("EDITOR_MSG_PART_TBL_MDL_QNAME");
            }
            case 4: {
                return BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_PL_SEL", "Partner Link");
            }
        }
        return " ";
    }
}

