/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ButtonMenu;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesSelectionTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.ElementVariableChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.generalpurpose.TablePanel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class VariablesSelectionPanel
extends TablePanel
implements ActionListener,
ListSelectionListener {
    protected ButtonMenu m_btnMenu;
    protected JCheckBox m_namespaceCB;
    protected Scope m_activity;
    protected BPELGraphPane m_graphPane;
    protected JButton m_upBtn;
    protected JButton m_downBtn;
    protected JButton m_okBtn;
    protected boolean m_enabled = true;

    public VariablesSelectionPanel(BaseTableModel tabModel, BPELGraphPane graph, Scope activty) {
        super(tabModel, new Insets(0, 0, 0, 0));
        this.setTableLabelText(BPELStringTranslator.getString("RULE_CREATION_DIALOG_INPUTS_OUTPUTS", "Inputs and Outputs:"));
        this.createControls();
        this.updateButtons();
        this.m_graphPane = graph;
        this.m_activity = activty;
    }

    public List getVariables() {
        VariablesSelectionTableModel model = (VariablesSelectionTableModel)((Object)this.m_table.getModel());
        return new ArrayList(model.getData());
    }

    protected void setColumnSizes() {
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(100);
                col.setMaxWidth(100);
                continue;
            }
            if (i == 3) {
                col.setPreferredWidth(30);
                continue;
            }
            col.setPreferredWidth(30);
        }
    }

    protected void createControls() {
        this.m_upBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("arrow_up_blue16"), (String)BPELStringTranslator.getString("MOVE_UP_TIP"), (String)BPELStringTranslator.getString("MOVE_UP_MNEMONIC"));
        this.m_downBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("arrow_down_blue16"), (String)BPELStringTranslator.getString("MOVE_DOWN_TIP"), (String)BPELStringTranslator.getString("MOVE_DOWN_MNEMONIC"));
        this.m_upBtn.addActionListener(this);
        this.m_downBtn.addActionListener(this);
        this.setColumnSizes();
        this.m_btnMenu = new ButtonMenu("", ImageCache.getIcon("create16"));
        Action[] actions = new Action[]{new CreateInputAction(), new CreateOutputAction()};
        this.m_btnMenu.setActions(actions);
        this.m_toolBar.removeAll();
        this.m_toolBar.add((Component)this.m_btnMenu);
        this.m_toolBar.add((Component)this.m_removeBtn);
        this.m_toolBar.add((Component)this.m_upBtn);
        this.m_toolBar.add((Component)this.m_downBtn);
    }

    protected void handleCreate(boolean isInput) {
        this.m_btnMenu.grabFocus();
        ElementVariableChooser dlg = new ElementVariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_activity);
        if (isInput) {
            dlg.setTitle(BPELStringTranslator.getString("RULE_CREATION_DIALOG_CREATE_INPUT"));
        } else {
            dlg.setTitle(BPELStringTranslator.getString("RULE_CREATION_DIALOG_CREATE_OUTPUT"));
        }
        VariablesSelectionTableModel tabModel = (VariablesSelectionTableModel)((Object)this.m_table.getModel());
        if (dlg.display() == 0) {
            Variable v = ((VariableChooser)dlg).getSelectedVariable();
            VariablesSelectionTableModel.VarRowData data = new VariablesSelectionTableModel.VarRowData();
            data.m_isInputVar = isInput;
            data.m_variable = v;
            tabModel.getData().addElement(data);
        }
        tabModel.refresh();
        this.updateButtons();
    }

    protected void handleRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_table.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
        }
    }

    @Override
    public void updateButtons() {
        ApplyCancelPanel p;
        super.updateButtons();
        ListSelectionModel model = this.m_table.getSelectionModel();
        int sel = model.getMinSelectionIndex();
        if (sel == -1) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(false);
        } else if (sel == 0) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(this.m_table.getModel().getRowCount() > 1 && this.m_enabled);
        } else {
            this.m_upBtn.setEnabled(this.m_enabled);
            if (sel + 1 == this.m_table.getModel().getRowCount()) {
                this.m_downBtn.setEnabled(false);
            } else {
                this.m_downBtn.setEnabled(this.m_enabled);
            }
        }
        if (this.m_okBtn == null && (p = this.getApplyCancelPanel()) != null) {
            this.m_okBtn = p.getOKButton();
            JButton btn = this.findButton(p, BPELStringTranslator.getString("APPLY_BUTTON_TEXT"));
            if (btn != null) {
                btn.setEnabled(false);
            }
        }
        if (this.m_okBtn != null) {
            VariablesSelectionTableModel m = (VariablesSelectionTableModel)((Object)this.m_table.getModel());
            Vector data = m.getData();
            boolean hasInputVars = false;
            for (Object o : data) {
                VariablesSelectionTableModel.VarRowData var = (VariablesSelectionTableModel.VarRowData)o;
                if (!var.m_isInputVar) continue;
                hasInputVars = true;
                break;
            }
            this.m_okBtn.setEnabled((hasInputVars || data.size() == 0) && this.m_enabled);
        }
        this.m_removeBtn.setEnabled(!model.isSelectionEmpty() && this.m_enabled);
    }

    private JButton findButton(Container c, String name) {
        Component[] comps = c.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JButton b;
            if (comps[i] instanceof JButton) {
                JButton btn = (JButton)comps[i];
                if ((btn.getName() == null || !btn.getName().contains(name)) && (btn.getText() == null || !btn.getText().contains(name))) continue;
                return btn;
            }
            if (!(comps[i] instanceof Container) || (b = this.findButton((Container)comps[i], name)) == null) continue;
            return b;
        }
        return null;
    }

    private ApplyCancelPanel getApplyCancelPanel() {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof ApplyCancelPanel); p = p.getParent()) {
        }
        if (p instanceof ApplyCancelPanel) {
            return (ApplyCancelPanel)p;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_removeBtn) {
            this.handleRemove();
        } else if (src == this.m_upBtn) {
            this.performMoveUp();
        } else if (src == this.m_downBtn) {
            this.performMoveDown();
        }
    }

    public void performMoveUp() {
        VariablesSelectionTableModel model = (VariablesSelectionTableModel)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveUp(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel - 1, sel - 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel - 1, 0, true));
        }
    }

    public void performMoveDown() {
        VariablesSelectionTableModel model = (VariablesSelectionTableModel)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveDown(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel + 1, sel + 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel + 1, 0, true));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    public void setOKButton(JButton okBtn) {
        this.m_okBtn = okBtn;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.m_createBtn.setEnabled(enable);
        this.m_downBtn.setEnabled(enable);
        this.m_upBtn.setEnabled(enable);
        this.m_editBtn.setEnabled(enable);
        this.m_removeBtn.setEnabled(enable);
        this.m_btnMenu.setEnabled(false);
        this.m_enabled = enable;
    }

    class CreateOutputAction
    extends AbstractAction {
        public CreateOutputAction() {
            super(BPELStringTranslator.getString("RULE_CREATION_DIALOG_CREATE_OUTPUT") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesSelectionPanel.this.handleCreate(false);
        }
    }

    class CreateInputAction
    extends AbstractAction {
        public CreateInputAction() {
            super(BPELStringTranslator.getString("RULE_CREATION_DIALOG_CREATE_INPUT") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesSelectionPanel.this.handleCreate(true);
        }
    }
}

