/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Validate;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class VariablesListEditPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JTable m_table;
    protected JButton m_addBtn;
    protected JButton m_editBtn;
    protected JButton m_removeBtn;
    protected JCheckBox m_namespaceCB;
    protected BPELGraphPane m_graph;
    protected Activity m_activity;

    public VariablesListEditPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public List getVariables() {
        VariablesTableModel model = (VariablesTableModel)((Object)this.m_table.getModel());
        return new ArrayList(model.getData());
    }

    public void load(Activity a) {
        this.m_activity = a;
        if (a == null) {
            VariablesTableModel model = (VariablesTableModel)((Object)this.m_table.getModel());
            model.getData().removeAllElements();
            model.refresh();
            return;
        }
        List vars = null;
        if (a instanceof Validate) {
            vars = BPELModelUtil.findVariableForValidateActivity((Validate)((Validate)a));
        }
        if (vars == null) {
            return;
        }
        Vector<Variable> data = new Vector<Variable>();
        VariablesTableModel model = (VariablesTableModel)((Object)this.m_table.getModel());
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            data.addElement(v);
        }
        model.setData(data);
        this.setColumnSizes();
        this.updateButtons();
    }

    protected void setModified(boolean b) {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof BaseEditingPage); p = p.getParent()) {
        }
        if (p instanceof BaseEditingPage) {
            BaseEditingPage page = (BaseEditingPage)p;
            page.setModified(b);
        }
    }

    protected void setColumnSizes() {
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(ImageCache.getIcon("variable16")));
                continue;
            }
            if (i == 3) {
                col.setPreferredWidth(180);
                continue;
            }
            col.setPreferredWidth(120);
        }
    }

    protected void createControls() {
        this.m_namespaceCB = new JCheckBox("", false);
        BPELStringTranslator.setButton(this.m_namespaceCB, BPELStringTranslator.getString("EDITOR_VARS_EDIT_PNL_SHOW_NS_URI"));
        this.m_namespaceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariablesTableModel model = (VariablesTableModel)((Object)VariablesListEditPanel.this.m_table.getModel());
                model.setExpandNamespaces(VariablesListEditPanel.this.m_namespaceCB.isSelected());
            }
        });
        this.m_addBtn = UIHelper.createToolBarButton((int)3);
        this.m_addBtn.addActionListener(this);
        this.m_removeBtn = UIHelper.createToolBarButton((int)2);
        this.m_removeBtn.addActionListener(this);
        this.m_editBtn = UIHelper.createToolBarButton((int)1);
        this.m_editBtn.addActionListener(this);
        this.m_table = new JTable((TableModel)((Object)new VariablesTableModel()));
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setAutoResizeMode(0);
        this.m_table.setRowHeight(18);
        this.setColumnSizes();
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = VariablesListEditPanel.this.m_table.rowAtPoint(origin);
                int column = VariablesListEditPanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    VariablesListEditPanel.this.handleEdit();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_addBtn);
        tb.add((Component)this.m_editBtn);
        tb.add((Component)this.m_removeBtn);
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, this.m_table, BPELStringTranslator.getString("EDITOR_VARS_EDIT_PNL_VARS"));
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_namespaceCB, (int)0, (int)2, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected void handleEdit() {
        ArrayList<Variable> list = new ArrayList<Variable>();
        VariableCreationDialog dlg = new VariableCreationDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        VariablesTableModel tabModel = (VariablesTableModel)((Object)this.m_table.getModel());
        Vector data = tabModel.getData();
        for (int i = 0; i < data.size(); ++i) {
            Variable var = (Variable)data.elementAt(i);
            list.add(var);
        }
        Variable v = this.getSelectedVariable();
        if (dlg.edit(this.m_activity, v, list) == 0) {
            tabModel.refresh();
        }
        this.setModified(true);
    }

    protected void handleAdd() {
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graph, this.m_activity);
        if (dlg.display() != 0) {
            return;
        }
        VariablesTableModel tabModel = (VariablesTableModel)((Object)this.m_table.getModel());
        tabModel.getData().addElement(dlg.getSelectedVariable());
        tabModel.refresh();
        this.updateButtons();
        this.setModified(true);
    }

    protected void handleRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_table.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
        }
        this.setModified(true);
    }

    protected Variable getSelectedVariable() {
        ListSelectionModel model = this.m_table.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return null;
        }
        int row = model.getLeadSelectionIndex();
        VariablesTableModel tabModel = (VariablesTableModel)((Object)this.m_table.getModel());
        return (Variable)tabModel.getRowData(row);
    }

    protected void updateButtons() {
        int numSelectedRows = this.m_table.getSelectedRowCount();
        if (numSelectedRows > 0) {
            this.m_removeBtn.setEnabled(true);
            this.m_editBtn.setEnabled(true);
        } else {
            this.m_removeBtn.setEnabled(false);
            this.m_editBtn.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleAdd();
        } else if (src == this.m_editBtn) {
            this.handleEdit();
        } else if (src == this.m_removeBtn) {
            this.handleRemove();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }
}

