/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class VariablesEditPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JTable m_table;
    protected JButton m_addBtn;
    protected JButton m_editBtn;
    protected JButton m_removeBtn;
    protected JCheckBox m_namespaceCB;
    protected BPELGraphPane m_graph;
    protected Scope m_activity;

    public VariablesEditPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public List getVariables() {
        VariablesTableModel model = (VariablesTableModel)((Object)this.m_table.getModel());
        return new ArrayList(model.getData());
    }

    public void load(Scope a) {
        this.m_activity = a;
        if (a == null) {
            VariablesTableModel model = (VariablesTableModel)((Object)this.m_table.getModel());
            model.getData().removeAllElements();
            model.refresh();
            return;
        }
        Variables vars = a.getVariables();
        if (vars == null) {
            return;
        }
        Vector<Variable> data = new Vector<Variable>();
        VariablesTableModel model = (VariablesTableModel)((Object)this.m_table.getModel());
        for (Variable v : vars.getVariables()) {
            data.addElement(v);
        }
        model.setData(data);
        this.setColumnSizes();
        this.updateButtons();
    }

    protected void setColumnSizes() {
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(ImageCache.getIcon("variable16")));
                continue;
            }
            if (i == 3) {
                col.setPreferredWidth(180);
                continue;
            }
            col.setPreferredWidth(120);
        }
    }

    protected void createControls() {
        this.m_namespaceCB = new JCheckBox("", false);
        BPELStringTranslator.setButton(this.m_namespaceCB, BPELStringTranslator.getString("EDITOR_VARS_EDIT_PNL_SHOW_NS_URI"));
        this.m_namespaceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariablesTableModel model = (VariablesTableModel)((Object)VariablesEditPanel.this.m_table.getModel());
                model.setExpandNamespaces(VariablesEditPanel.this.m_namespaceCB.isSelected());
            }
        });
        this.m_addBtn = UIHelper.createToolBarButton((int)0);
        this.m_addBtn.addActionListener(this);
        this.m_removeBtn = UIHelper.createToolBarButton((int)2);
        this.m_removeBtn.addActionListener(this);
        this.m_editBtn = UIHelper.createToolBarButton((int)1);
        this.m_editBtn.addActionListener(this);
        this.m_table = new JTable((TableModel)((Object)new VariablesTableModel()));
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setAutoResizeMode(0);
        this.m_table.setRowHeight(18);
        this.setColumnSizes();
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = VariablesEditPanel.this.m_table.rowAtPoint(origin);
                int column = VariablesEditPanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    VariablesEditPanel.this.handleEdit();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_addBtn);
        tb.add((Component)this.m_editBtn);
        tb.add((Component)this.m_removeBtn);
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, this.m_table, BPELStringTranslator.getString("EDITOR_VARS_EDIT_PNL_VARS"));
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_namespaceCB, (int)0, (int)2, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected void handleEdit() {
        ArrayList<Variable> list = new ArrayList<Variable>();
        VariableCreationDialog dlg = new VariableCreationDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        VariablesTableModel tabModel = (VariablesTableModel)((Object)this.m_table.getModel());
        Vector data = tabModel.getData();
        for (int i = 0; i < data.size(); ++i) {
            Variable var = (Variable)data.elementAt(i);
            list.add(var);
        }
        Variable v = this.getSelectedVariable();
        if (dlg.edit((Activity)this.m_activity, v, list) == 0) {
            tabModel.refresh();
        }
    }

    protected void handleCreate() {
        ArrayList<Variable> list = new ArrayList<Variable>();
        VariableCreationDialog dlg = new VariableCreationDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        VariablesTableModel tabModel = (VariablesTableModel)((Object)this.m_table.getModel());
        Vector data = tabModel.getData();
        for (int i = 0; i < data.size(); ++i) {
            Variable var = (Variable)data.elementAt(i);
            list.add(var);
        }
        if (dlg.create((Activity)this.m_activity, list) != 0) {
            return;
        }
        Variable v = dlg.getVariable();
        tabModel.getData().addElement(v);
        tabModel.refresh();
        this.updateButtons();
    }

    protected void handleRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_table.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
            Process p = graphModel.getProcess();
            p.fireModelChanged((Object)this, 1, null);
        }
    }

    protected Variable getSelectedVariable() {
        ListSelectionModel model = this.m_table.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return null;
        }
        int row = model.getLeadSelectionIndex();
        VariablesTableModel tabModel = (VariablesTableModel)((Object)this.m_table.getModel());
        return (Variable)tabModel.getRowData(row);
    }

    protected void updateButtons() {
        int numSelectedRows = this.m_table.getSelectedRowCount();
        if (numSelectedRows > 0) {
            this.m_removeBtn.setEnabled(true);
            this.m_editBtn.setEnabled(true);
        } else {
            this.m_removeBtn.setEnabled(false);
            this.m_editBtn.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleCreate();
        } else if (src == this.m_editBtn) {
            this.handleEdit();
        } else if (src == this.m_removeBtn) {
            this.handleRemove();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }
}

