/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPickerListener;
import oracle.tip.tools.ide.common.expressionbuilder.PickerEvent;
import oracle.tip.tools.ide.common.ui.DraggableJTree;
import oracle.tip.tools.ide.common.ui.DraggableJTreeListener;
import oracle.tip.tools.ide.common.ui.JTreeCellRendererExtendor;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class VariableExpressionBuilderPicker
implements ExpressionBuilderPicker {
    protected EventListenerList m_listenerList = new EventListenerList();
    protected VariablePickerPanel m_variablePicker;
    protected Activity m_activity;

    public VariableExpressionBuilderPicker(VariablePickerPanel p, Activity a) {
        this.m_variablePicker = p;
        this.m_activity = a;
        this.m_variablePicker.getProcessExplorer().getExplorerTree().showDetailsCheckBox(false);
        DraggableJTree tree = this.m_variablePicker.getProcessExplorer().getExplorerTree().getTree();
        this.m_variablePicker.getProcessExplorer().getExplorerTree().getJTreeCellRendererExtendor().disconnect();
        new JTreeCellRendererExtendor((JTree)tree);
        DraggableJTreeListener l = new DraggableJTreeListener(){

            public boolean handleDragGestureRecognized(DragGestureEvent event) {
                String expression;
                DraggableJTree tree = VariableExpressionBuilderPicker.this.m_variablePicker.getProcessExplorer().getExplorerTree().getTree();
                if (event.getComponent() == tree && (expression = VariableExpressionBuilderPicker.this.m_variablePicker.getXPathExpression()) != null) {
                    StringSelection text = new StringSelection(expression);
                    tree.getDragSource().startDrag(event, DragSource.DefaultMoveDrop, ImageCache.getImage("auction_hammer.png"), new Point(5, 5), text, (DragSourceListener)tree);
                }
                return true;
            }
        };
        tree.setListener(l);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    String expression = VariableExpressionBuilderPicker.this.m_variablePicker.getXPathExpression();
                    VariableExpressionBuilderPicker.this.fireInsertEvent(expression);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VariableExpressionBuilderPicker.this.handleSelection();
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                VariableExpressionBuilderPicker.this.handleSelection();
            }
        });
    }

    protected void handleSelection() {
        String desc = "";
        String preview = "";
        String expression = this.m_variablePicker.getXPathExpression();
        if (Helper.hasValue((String)expression)) {
            desc = "Variable XPath expression";
            preview = expression;
        }
        this.fireSelectionEvent(expression, preview, desc);
    }

    public String getTitle() {
        return "BPEL Variables";
    }

    public void addExpressionBuilderPickerListener(ExpressionBuilderPickerListener l) {
        this.m_listenerList.add(ExpressionBuilderPickerListener.class, l);
    }

    public JComponent getComponent() {
        return this.m_variablePicker;
    }

    public void load() {
        try {
            this.m_variablePicker.load(this.m_activity);
        }
        catch (Exception e) {
            // empty catch block
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                VariableExpressionBuilderPicker.this.m_variablePicker.getProcessExplorer().getExplorerTree().expandVariableContainerNodes();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void removeExpressionBuilderPickerListener(ExpressionBuilderPickerListener l) {
        this.m_listenerList.remove(ExpressionBuilderPickerListener.class, l);
    }

    protected void fireInsertEvent(String val) {
        PickerEvent evt = new PickerEvent((Object)this, 1);
        evt.setPreview(val);
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ExpressionBuilderPickerListener.class) continue;
            ((ExpressionBuilderPickerListener)listeners[i + 1]).pickerEventOccurred(evt);
        }
    }

    protected void fireSelectionEvent(String val, String preview, String desc) {
        PickerEvent evt = new PickerEvent((Object)this, 0);
        evt.setPreview(val);
        evt.setDescription(desc);
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ExpressionBuilderPickerListener.class) continue;
            ((ExpressionBuilderPickerListener)listeners[i + 1]).pickerEventOccurred(evt);
        }
    }
}

