/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.SchemaResolvedObj;
import oracle.tip.tools.ide.common.bpeldesigner.models.wsdl.PartItem;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLImport;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableData;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.xpathselection.XPathSelectionDialog;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;

public class VariableDataEditPage
extends BaseEditingPage
implements ActionListener {
    protected JTextField m_varField;
    protected JButton m_varBrowseBtn;
    protected JComboBox m_part;
    protected JScrollPane m_xpathScrollPane;
    protected XPathEditorPane m_xpathBuilder;
    protected JButton m_selectXPathBtn;
    protected Variable m_selVar;
    protected String m_initXPath;
    protected Activity m_activity;
    protected VariableData m_varData;
    protected Document m_doc;

    public VariableDataEditPage(BPELGraphPane pane, Activity activity) {
        super(pane);
        this.m_activity = activity;
        this.createControls();
        this.layoutControls();
        this.m_nsResolver = NSResolverFactory.getNSResolver((Activity)this.m_activity, (Process)this.m_processModel);
    }

    public VariableDataEditPage(BPELGraphPane pane, Activity activity, VariableData varData) {
        super(pane);
        this.m_activity = activity;
        this.m_varData = varData;
        this.createControls();
        this.layoutControls();
        this.loadControls();
    }

    public boolean validateData() {
        if (!BPELModelUtil.isStringValueSet((String)this.m_varField.getText())) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_VAR_DT_EDIT_PAGE_INV_VAR"), (int)0);
            return false;
        }
        return true;
    }

    public void showVariableBrowser(boolean bShow) {
        this.m_varBrowseBtn.setVisible(bShow);
    }

    public VariableData getVariableData() {
        return this.m_varData;
    }

    public void saveVariableData() {
        if (this.m_varData == null) {
            this.m_varData = new VariableData();
        }
        this.m_varData.setVariable(this.m_selVar);
        this.m_varData.setVariableText(this.m_varField.getText());
        String str = this.getSelectedPart(this.m_part);
        if (str != null && !str.trim().equals("")) {
            this.m_varData.setPart(this.getSelectedPart(this.m_part));
            this.m_varData.setPartQName(this.getSelectedPartQName(this.m_part));
        } else {
            this.m_varData.setPart(null);
            this.m_varData.setPartQName(null);
        }
        str = this.m_xpathBuilder.getText();
        this.m_xpathBuilder.saveCachedNS();
        if (str != null && !str.trim().equals("")) {
            this.m_varData.setXPathQuery(str);
        } else {
            this.m_varData.setXPathQuery(null);
        }
        this.m_varData.setDocument(this.m_doc);
    }

    protected void setSelectedVariable(Variable v) {
        this.m_selVar = v;
        if (this.m_selVar != null) {
            this.m_varField.setText(this.m_selVar.getName());
            this.asyncLoadPart(this.m_selVar, this.m_part, null, this.m_xpathBuilder, null);
        } else {
            this.m_varField.setText("");
        }
    }

    protected void createControls() {
        this.m_selectXPathBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("browse_xpath16"));
        this.m_selectXPathBtn.setToolTipText(BPELStringTranslator.getString("BROWSE_XPATH", "Browse XPath..."));
        this.m_selectXPathBtn.addActionListener(this);
        this.m_selectXPathBtn.setEnabled(false);
        this.m_varField = new JTextField();
        this.m_varField.setEditable(false);
        this.m_varBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableChooser chooser = new VariableChooser(GraphUtils.getFrame((Component)VariableDataEditPage.this), VariableDataEditPage.this.m_graphPane, VariableDataEditPage.this.m_activity);
                if (chooser.display() == 0) {
                    VariableDataEditPage.this.m_selectXPathBtn.setEnabled(false);
                    VariableDataEditPage.this.setSelectedVariable(chooser.getSelectedVariable());
                }
            }
        };
        this.m_varBrowseBtn.addActionListener(lst);
        this.m_part = new JComboBox();
        this.m_part.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("message_part_node")));
        this.m_xpathBuilder = new XPathEditorPane(2);
        this.m_xpathScrollPane = new JScrollPane((Component)this.m_xpathBuilder, 21, 31);
        this.m_xpathBuilder.setEditable(true);
        this.m_part.addItemListener(new PartItemListener());
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JLabel lblVariable = new JLabel();
        BPELStringTranslator.setLabel(lblVariable, this.m_varField, BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_VAR"));
        JLabel lblPart = new JLabel();
        BPELStringTranslator.setLabel(lblPart, this.m_part, BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_PART"));
        ToolBar tb1 = new ToolBar();
        tb1.add((Component)this.m_varBrowseBtn);
        ToolBar tb2 = new ToolBar();
        tb2.add((Component)this.m_selectXPathBtn);
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)lblVariable, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_varField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 3), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb1, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblPart, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_part, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel lblXpath = new JLabel();
        BPELStringTranslator.setLabel(lblXpath, (Component)this.m_xpathBuilder, BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_XPATH"));
        GraphUtils.addComponent((Container)this, (Component)lblXpath, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_xpathScrollPane, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 3), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb2, (int)2, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    protected void loadControls() {
        if (this.m_varData == null) {
            return;
        }
        this.m_varField.setText(this.m_varData.getVariableText());
        this.m_initXPath = this.m_varData.getXPathQuery();
        this.asyncLoadPart(this.getSelectedVariable(this.m_varData.getVariableText()), this.m_part, this.m_varData.getPart(), this.m_xpathBuilder, this.m_initXPath);
    }

    protected void asyncLoadPart(Variable var, JComboBox partCombo, String part, XPathEditorPane xPathBuilder, String initXPath) {
        if (var == null) {
            return;
        }
        final QName msgQName = var.getMessageType();
        if (msgQName == null) {
            partCombo.removeAllItems();
            partCombo.setEnabled(false);
            QName qName = var.getElement();
            String namespaceURI = null;
            if (qName != null) {
                namespaceURI = qName.getNamespaceURI();
            } else {
                qName = var.getType();
                if (qName != null) {
                    namespaceURI = qName.getNamespaceURI();
                }
            }
            if (namespaceURI != null) {
                if (xPathBuilder != null && "http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                    xPathBuilder.setText("");
                    xPathBuilder.setEnabled(false);
                } else {
                    this.invokeXPathBuilder(partCombo, xPathBuilder, initXPath, var);
                }
            }
            return;
        }
        final JComboBox combo = partCombo;
        final String strText = part;
        final List list = this.getURIForNamespaceURI(msgQName.getNamespaceURI());
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final ComboBoxModel model = VariableDataEditPage.this.getModelForMessagePart(msgQName, combo, list);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            combo.setModel(model);
                            if (!combo.isEnabled()) {
                                combo.setEnabled(true);
                            }
                            if (strText != null) {
                                VariableDataEditPage.this.selectPartValue(combo, strText);
                            } else if (model.getSize() > 0) {
                                combo.setSelectedIndex(0);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
                finally {
                    VariableDataEditPage.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected List getURIForNamespaceURI(String namespaceURI) {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        BPELXmlModel mainModel = graphModel.getBPELXmlModel();
        BPELProject prj = mainModel.getBPELProject();
        WSDLModel wsdlModel = mainModel.getWSDLModel();
        List<Object> list = BPELModelUtil.getWSDLFromNamespaceURI((Process)graphModel.getProcess());
        if (list != null && list.size() > 0) {
            return list;
        }
        list = new ArrayList<URI>();
        List<WSDLImport> implist = null;
        try {
            implist = wsdlModel.getImports();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (implist != null) {
            for (int i = 0; i < implist.size(); ++i) {
                WSDLImport imp = implist.get(i);
                if (!imp.getNamespaceURI().equals(namespaceURI)) continue;
                try {
                    list.add(new URI(URIUtil.escapeURIString((String)imp.getLocationURI())));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (list.size() > 0) {
                return list;
            }
        }
        DeploymentFile depFile = this.m_graphPane.getBPELProject().getDeploymentFile();
        List plList = BPELModelUtil.getPartnerLinkWSDLLocations((Process)graphModel.getProcess(), (DeploymentFile)depFile);
        if (plList != null) {
            for (int i = 0; i < plList.size(); ++i) {
                try {
                    URI uri = (URI)plList.get(i);
                    URI retURI = WSDLUtil.getSchemaURI((URI)uri, (String)namespaceURI);
                    if (retURI == null) continue;
                    list.add(retURI);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (list.size() > 0) {
            return list;
        }
        list = wsdlModel.getURIForNamespaceURI(namespaceURI);
        return list == null || list.size() == 0 ? null : list;
    }

    protected ComboBoxModel getModelForMessagePart(QName msgQName, JComboBox partCombo, List list) {
        DefaultComboBoxModel<PartItem> model = new DefaultComboBoxModel<PartItem>();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String realNamespace = msgQName.getNamespaceURI();
                WSDLPartData[] parts = null;
                try {
                    parts = WSDLUtil.getParts((URI)((URI)it.next()), (String)msgQName.getLocalPart(), (String)realNamespace);
                }
                catch (Exception e) {
                    UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_CPY_EDIT_UNBL_READ_PART"));
                }
                if (parts == null) continue;
                model.addElement(new PartItem(null, null, null));
                for (int i = 0; i < parts.length; ++i) {
                    model.addElement(new PartItem(parts[i].getPartName(), parts[i].getTargetNamespace(), parts[i].getPartType(), parts[i].getPartXSDType()));
                }
            }
        }
        return model;
    }

    protected void selectPartValue(JComboBox partCombo, String part) {
        ComboBoxModel model = partCombo.getModel();
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            PartItem item;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof PartItem) || !(item = (PartItem)obj).getName().equals(part)) continue;
            partCombo.setSelectedItem(item);
            return;
        }
    }

    protected String getSelectedPart(JComboBox cb) {
        Object obj = cb.getSelectedItem();
        if (obj instanceof PartItem) {
            return ((PartItem)obj).getPart();
        }
        return null;
    }

    protected QName getSelectedPartQName(JComboBox cb) {
        Object obj = cb.getSelectedItem();
        if (obj instanceof PartItem) {
            PartItem p = (PartItem)obj;
            return new QName(p.getNamespaceURI(), p.getPartType());
        }
        return null;
    }

    protected PartItem getSelectedPartItem(JComboBox cb) {
        Object obj = cb.getSelectedItem();
        if (obj instanceof PartItem) {
            return (PartItem)obj;
        }
        return null;
    }

    protected void invokeXPathBuilder(JComboBox cb, XPathEditorPane xPathBuilder, String initXPath, Variable var) {
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        WSDLModel wsdlModel = mainModel.getWSDLModel();
        if (!xPathBuilder.isEnabled()) {
            xPathBuilder.setEnabled(true);
        }
        PartItem part = this.getSelectedPartItem(cb);
        try {
            QName rootQName;
            String namespaceURI;
            String rootElement;
            boolean isElement = true;
            if (part != null) {
                if (part.getName().equals("---- No Selection ----")) {
                    xPathBuilder.setText("");
                    xPathBuilder.setEnabled(false);
                    return;
                }
                rootElement = part.getPartType();
                namespaceURI = part.getNamespaceURI();
                isElement = part.getPartXSDType() != 2;
            } else {
                QName qname = var.getElement();
                if (qname == null) {
                    xPathBuilder.setText("");
                    xPathBuilder.setEnabled(false);
                    return;
                }
                rootElement = qname.getLocalPart();
                namespaceURI = qname.getNamespaceURI();
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                xPathBuilder.setText("");
                xPathBuilder.setEnabled(false);
                return;
            }
            SchemaResolvedObj obj = wsdlModel.resolveNamespace(this.m_processModel, namespaceURI, rootElement, isElement);
            if (obj == null) {
                xPathBuilder.setText(initXPath);
                return;
            }
            QName typeQName = null;
            if (part != null && part.getPartXSDType() == 2) {
                rootQName = new QName("", part.getPart());
                typeQName = new QName(namespaceURI, part.getPartType());
            } else {
                rootQName = new QName(namespaceURI, rootElement);
            }
            this.m_doc = SchemaResolvedObj.buildDocument((SchemaResolvedObj)obj, (QName)rootQName, typeQName, (MapperNSResolver)((MapperNSResolver)this.m_nsResolver));
        }
        catch (MalformedURLException me) {
            System.out.println("Getting mal form exception" + me);
            me.printStackTrace();
        }
        catch (Exception sge) {
            System.out.println("Getting SchemaGrammarException exception" + sge);
            sge.printStackTrace();
        }
        if (this.m_doc != null) {
            xPathBuilder.initializeEditorPane(this.m_doc, initXPath, this.m_nsResolver);
        } else {
            xPathBuilder.setText(initXPath);
        }
    }

    protected Variable getSelectedVariable(String varName) {
        Variables variables;
        List list = BPELModelUtil.findAllParentScopes((Activity)this.m_activity);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Scope scope = (Scope)list.get(i);
                variables = scope.getVariables();
                if (variables == null) continue;
                List lst = variables.getVariables();
                for (Variable v : lst) {
                    if (!v.getName().equals(varName)) continue;
                    return v;
                }
            }
        }
        if ((variables = this.m_processModel.getVariables()) != null) {
            List lst = variables.getVariables();
            for (Variable v : lst) {
                if (!v.getName().equals(varName)) continue;
                return v;
            }
        }
        return null;
    }

    protected void handleSelectXPath() {
        XPathSelectionDialog dlg = new XPathSelectionDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_doc);
        if (dlg.display() == 0) {
            String xPath = dlg.getSelectedXPath();
            if (xPath != null) {
                this.m_xpathBuilder.setText(xPath);
            } else {
                this.m_xpathBuilder.setText("");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_selectXPathBtn) {
            this.handleSelectXPath();
        }
    }

    class PartItemListener
    implements ItemListener {
        PartItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object src = e.getSource();
            if (e.getStateChange() == 1 && src == VariableDataEditPage.this.m_part) {
                VariableDataEditPage.this.m_selectXPathBtn.setEnabled(true);
                VariableDataEditPage.this.invokeXPathBuilder(VariableDataEditPage.this.m_part, VariableDataEditPage.this.m_xpathBuilder, VariableDataEditPage.this.m_initXPath, VariableDataEditPage.this.m_selVar);
            }
        }
    }
}

