/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableData;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class VariableDataDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected int m_retVal = 1;
    protected VariableDataEditPage m_panel;

    public VariableDataDialog(JFrame f, BPELGraphPane graph, Activity activity) {
        super(f, BPELStringTranslator.getString("EDITOR_VAR_SENS_PNL_XPATH_BLD"), true);
        this.m_panel = new VariableDataEditPage(graph, activity);
        this.createControls();
        this.layoutControls();
    }

    public VariableDataDialog(JFrame f, BPELGraphPane graph, Activity activity, VariableData data) {
        super(f, BPELStringTranslator.getString("EDITOR_VAR_DT_DLG_EDIT"), true);
        this.m_panel = new VariableDataEditPage(graph, activity, data);
        this.createControls();
        this.layoutControls();
    }

    public int display(Variable v) {
        this.m_panel.setSelectedVariable(v);
        this.m_panel.showVariableBrowser(v == null);
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createControls() {
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_panel, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)2, (int)1, (int)13, (int)0, (Insets)new Insets(5, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(420, 170);
        this.setLocationRelativeTo(this.getParent());
    }

    public VariableData getVariableData() {
        return this.m_panel.getVariableData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (this.m_panel.validateData()) {
                this.m_panel.saveVariableData();
                this.m_retVal = 0;
                this.dispose();
            }
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }
}

