/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.SchemaResolvedObj;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.PropertyModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import org.w3c.dom.Document;

public class VariableDataCallBackImpl
implements VariableDataCallBack {
    protected BPELXmlModel m_mainModel;
    protected Activity m_activity;
    protected Process m_processModel;
    protected List m_varList;
    protected NamespaceResolver m_nsResolver;

    public VariableDataCallBackImpl(BPELXmlModel mainModel, Activity curActivity) {
        this.m_mainModel = mainModel;
        this.m_activity = curActivity;
        this.m_processModel = mainModel.getProcess();
        this.m_varList = new ArrayList();
        this.m_nsResolver = NSResolverFactory.getNSResolver((Activity)curActivity, (Process)this.m_processModel);
    }

    public VariableDataCallBackImpl(BPELXmlModel mainModel, Activity curActivity, NamespaceResolver nsResolver) {
        this.m_mainModel = mainModel;
        this.m_activity = curActivity;
        this.m_processModel = mainModel.getProcess();
        this.m_varList = new ArrayList();
        this.m_nsResolver = nsResolver;
    }

    public List getVariableNames() {
        List sList;
        List lst;
        ArrayList<String> list = new ArrayList<String>();
        Variables variables = this.m_processModel.getVariables();
        if (variables != null) {
            lst = variables.getVariables();
            for (Variable v : lst) {
                this.m_varList.add(v);
                list.add(v.getName());
            }
        }
        if (this.m_activity instanceof Scope && (variables = ((Scope)this.m_activity).getVariables()) != null) {
            lst = variables.getVariables();
            for (Variable v : lst) {
                this.m_varList.add(v);
                list.add(v.getName());
            }
        }
        if ((sList = BPELModelUtil.findAllParentScopes((Activity)this.m_activity)) != null && sList.size() > 0) {
            for (int i = 0; i < sList.size(); ++i) {
                Scope scope = (Scope)sList.get(i);
                variables = scope.getVariables();
                if (variables == null) continue;
                List lst2 = variables.getVariables();
                for (Variable v : lst2) {
                    this.m_varList.add(v);
                    list.add(v.getName());
                }
            }
        }
        return list;
    }

    public List getParts(String varName) {
        Variable selVar = this.getSelectedVar(varName);
        if (selVar == null) {
            return new ArrayList();
        }
        QName msgQName = selVar.getMessageType();
        if (msgQName == null) {
            return new ArrayList();
        }
        BPELProject proj = this.m_mainModel.getBPELProject();
        List list = BPELModelerUtil.getWSDLFromNamespaceURI((Process)this.m_processModel, (DeploymentFile)proj.getDeploymentFile(), (String)msgQName.getNamespaceURI());
        if (list == null) {
            return new ArrayList();
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String realNamespace = msgQName.getNamespaceURI();
            List wsdlPart = null;
            try {
                wsdlPart = WSDLUtil.getWSDLParts((URI)((URI)it.next()), (String)msgQName.getLocalPart(), (String)realNamespace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (wsdlPart == null) continue;
            return wsdlPart;
        }
        return new ArrayList();
    }

    public List getProperties(String varName) {
        Variable selVar = this.getSelectedVar(varName);
        if (selVar == null || selVar.getMessageType() == null) {
            return null;
        }
        List<CorrelationPropertyAlias> list = null;
        PropertyModel propertyModel = this.m_mainModel.getPropertyModel();
        try {
            list = propertyModel.getPropertyAliases();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        QName qname = selVar.getMessageType();
        ArrayList<String> propList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            CorrelationPropertyAlias alias = list.get(i);
            if (!qname.equals(alias.getMessageType())) continue;
            propList.add(alias.getPropertyName().getLocalPart());
        }
        return propList.size() > 0 ? propList : null;
    }

    public Document getDocument(String variableName) {
        Variable selVar = this.getSelectedVar(variableName);
        if (selVar == null) {
            return null;
        }
        QName qname = selVar.getElement();
        if (qname == null) {
            return null;
        }
        return this.createDocument(qname.getNamespaceURI(), qname.getLocalPart(), null);
    }

    public Document getDocument(QName qName) {
        if (qName == null) {
            return null;
        }
        return this.createDocument(qName.getNamespaceURI(), qName.getLocalPart(), null);
    }

    public Document getDocument(String partName, QName qName) {
        if (partName == null || qName == null) {
            return null;
        }
        return this.createDocument(qName.getNamespaceURI(), qName.getLocalPart(), partName);
    }

    protected Variable getSelectedVar(String varName) {
        Variable selVar = null;
        for (int i = 0; i < this.m_varList.size() && selVar == null; ++i) {
            Variable var = (Variable)this.m_varList.get(i);
            if (!var.getName().equals(varName)) continue;
            selVar = var;
        }
        return selVar;
    }

    protected Document createDocument(String namespaceURI, String rootElement, String partName) {
        Document doc = null;
        try {
            boolean bIsElement = partName == null;
            WSDLModel wsdlModel = this.m_mainModel.getWSDLModel();
            SchemaResolvedObj obj = wsdlModel.resolveNamespace(this.m_processModel, namespaceURI, rootElement, bIsElement);
            QName rootQName = null;
            QName typeQName = null;
            if (partName != null) {
                rootQName = new QName("", partName);
                typeQName = new QName(namespaceURI, rootElement);
            } else {
                rootQName = new QName(namespaceURI, rootElement);
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                return null;
            }
            doc = SchemaResolvedObj.buildDocument((SchemaResolvedObj)obj, (QName)rootQName, (QName)typeQName, (MapperNSResolver)((MapperNSResolver)this.m_nsResolver));
        }
        catch (MalformedURLException me) {
            System.out.println("Getting mal form exception" + me);
            me.printStackTrace();
        }
        catch (Exception sge) {
            System.out.println("Getting SchemaGrammarException exception" + sge);
            sge.printStackTrace();
        }
        return doc;
    }
}

