/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.datasources.schema.SchemaTypesDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.ProjectWSDLDataSource;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProjectUtil;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.typeexplorer.TypeObjectPanel;
import oracle.tip.tools.ide.common.typeexplorer.WSDLImportHandler;
import oracle.tip.tools.ide.common.ui.ComponentBorderPane;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkSelectionDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkTypesDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ProjectSchemaImportHandler;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ProjectWSDLImportHandler;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.AbstractActivityNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink.PartnerLinkChooser;
import oracle.tip.tools.ide.pm.gui.explorer.MessageTypeDataSource;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;

public class VariableCreationDialog
extends BPELBaseDialog
implements ActionListener,
KeyListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JTextField m_nameField;
    protected JButton m_okBtn;
    protected JButton m_applyBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected TypeObjectPanel m_typePanel;
    protected BPELGraphPane m_graph;
    protected JTabbedPane m_tab;
    protected JPanel m_genPanel;
    protected JLabel m_entityPartnerLinkLbl;
    protected boolean m_bCreating = false;
    protected boolean m_bModified = false;
    protected boolean m_bNeedAddImport = false;
    protected URL m_selectedPartnerLinkURL;
    protected List m_variablesFilter;
    protected int m_retVal = 1;
    protected Process m_process;
    protected Activity m_activity;
    protected Variable m_variable;
    protected JCheckBox m_entityVarBox;
    protected JButton m_partnerLinkBrowseBtn;
    protected JTextField m_partnerLinkField;
    protected PartnerLink m_link;
    protected int m_creationMask;
    protected JCheckBox m_sdoCapable;

    public VariableCreationDialog(JFrame f, BPELGraphPane graph) {
        this(f, graph, -1);
    }

    public VariableCreationDialog(JFrame f, BPELGraphPane graph, int creationMask) {
        super(f, BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG"), true);
        this.m_creationMask = creationMask;
        this.m_graph = graph;
        if (graph != null) {
            BPELGraphModel model = (BPELGraphModel)graph.getModel();
            this.m_process = model.getProcess();
        }
        this.createControls();
        this.layoutControls();
        this.handleEntityVariableSelection();
    }

    public int create(Activity a, List variablesFilter) {
        this.m_activity = a;
        this.m_variablesFilter = variablesFilter;
        this.m_bCreating = true;
        this.m_variable = (Variable)BPELParser.createImplementation(Variable.class);
        String vname = BPELModelUtil.generateUniqueName((Process)this.m_process, (String)BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_TBL_VAR"), Variable.class);
        List nameLst = this.getNames(this.m_variablesFilter);
        if (this.doesNameExist(this.m_variablesFilter, vname)) {
            this.m_variable.setName(BPELModelUtil.createUniqueName((String)BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_TBL_VAR"), (String)vname, (List)nameLst));
        } else {
            this.m_variable.setName(vname);
        }
        this.loadControls();
        this.installListeners();
        return this.display();
    }

    protected boolean doesNameExist(List variableLst, String name) {
        if (variableLst != null) {
            for (Variable obj : variableLst) {
                if (obj.getName() == null || !obj.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected List getNames(List variableLst) {
        ArrayList<String> nameLst = new ArrayList<String>();
        if (variableLst != null) {
            for (Variable obj : variableLst) {
                nameLst.add(obj.getName());
            }
        }
        return nameLst;
    }

    public int edit(Activity a, Variable v, List variablesFilter) {
        this.m_activity = a;
        this.m_variablesFilter = variablesFilter;
        this.m_bCreating = false;
        this.setTitle(BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_EDIT") + v.getName());
        this.m_variable = v;
        this.m_nameField.setText(v.getName());
        QName qname = v.getMessageType();
        if (qname != null) {
            this.m_typePanel.setMessageType(qname);
        } else {
            qname = v.getElement();
            if (qname != null) {
                this.m_typePanel.setElementType(qname);
            } else {
                qname = v.getType();
                if (qname != null) {
                    this.m_typePanel.setType(qname);
                }
            }
        }
        String name = v.getPartnerlink();
        if (name != null && name.length() > 0) {
            this.m_partnerLinkField.setText(name);
            this.m_entityVarBox.setSelected(true);
            this.m_partnerLinkBrowseBtn.setEnabled(true);
        }
        this.m_sdoCapable.setSelected(this.m_variable.getSdoCapable());
        this.installListeners();
        String oldName = v.getName();
        int retVal = this.display();
        if (retVal == 0) {
            String newName = v.getName();
            List alst = BPELModelUtil.getChildActivitiesUsingVariable((Activity)a, (String)oldName);
            for (Activity activity : alst) {
                BPELModelUtil.renameActivityVariable((Activity)activity, (String)oldName, (String)newName);
            }
        }
        return retVal;
    }

    protected void installListeners() {
        this.m_typePanel.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VariableCreationDialog.this.m_bModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VariableCreationDialog.this.m_bModified = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VariableCreationDialog.this.m_bModified = true;
            }
        });
    }

    private int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        if (this.m_variable != null) {
            this.m_nameField.setText(this.m_variable.getName());
        }
        this.updateButtons();
        this.m_bModified = false;
    }

    protected void createControls() {
        this.m_tab = new JTabbedPane(ApplyCancelPanel.TAB_PLACEMENT);
        this.m_entityVarBox = new JCheckBox();
        this.m_partnerLinkBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_PLS"));
        this.m_partnerLinkBrowseBtn.addActionListener(this);
        this.m_partnerLinkBrowseBtn.setEnabled(false);
        this.m_partnerLinkField = new JTextField();
        this.m_partnerLinkField.setEditable(false);
        this.m_sdoCapable = new JCheckBox();
        BPELStringTranslator.setButton(this.m_sdoCapable, BPELStringTranslator.getString("SDO_CAPABLE", "&SDO Capable"));
        this.m_genPanel = this.createGeneralPage();
        this.m_tab.add(BPELStringTranslator.getString("GENERAL_EDITOR_TITLE"), this.m_genPanel);
        this.m_applyBtn = new JButton(BPELStringTranslator.getString("APPLY_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_applyBtn, BPELStringTranslator.getString("APPLY_BUTTON_TEXT_RES_A"));
        this.m_applyBtn.addActionListener(this);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void handleSensorPageSelected() {
        if (this.m_bCreating) {
            String msg = BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_APP_CHG");
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)msg);
            this.m_tab.setSelectedIndex(0);
            return;
        }
        if (this.m_bModified) {
            String msg = BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_APP_CHG");
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)msg);
            this.m_tab.setSelectedIndex(0);
        }
    }

    protected JPanel createGeneralPage() {
        ProjectSchemaDataSource ds1 = new ProjectSchemaDataSource((IDEProject)this.m_graph.getBPELProject(), false, true);
        ProjectWSDLDataSource ds2 = new ProjectWSDLDataSource(this.m_graph.getBPELProject(), false, true, false);
        PartnerLinkTypesDataSource ds3 = new PartnerLinkTypesDataSource(this.m_process, false, true, false, true);
        CompoundDataSource cs = new CompoundDataSource();
        cs.addDataSource((TreeExplorerDataSource)ds1);
        cs.addDataSource((TreeExplorerDataSource)ds2);
        cs.addDataSource((TreeExplorerDataSource)ds3);
        ProjectSchemaImportHandler schemaImportHandler = new ProjectSchemaImportHandler(this.m_graph, true);
        ProjectWSDLImportHandler messageTypeWSDLImportHandler = new ProjectWSDLImportHandler(this.m_graph, true, true, false);
        ProjectWSDLImportHandler elementTypeWSDLImportHandler = new ProjectWSDLImportHandler(this.m_graph, true, false, true);
        this.m_typePanel = new TypeObjectPanel(this.m_graph.getBPELProject(), BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_EDIT_TYPE"), (TreeExplorerDataSource)new SchemaTypesDataSource(), (TreeExplorerDataSource)new MessageTypeDataSource(this.m_process, this.m_graph.getBPELProject()), (TreeExplorerDataSource)cs, (WSDLImportHandler)messageTypeWSDLImportHandler, (WSDLImportHandler)elementTypeWSDLImportHandler, (SchemaImportHandler)schemaImportHandler, this.m_creationMask);
        this.m_nameField = new JTextField();
        this.m_nameField.addKeyListener(this);
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JPanel entityPnl = this.createEntityVariablePanel(this.m_partnerLinkBrowseBtn, this.m_partnerLinkField, this.m_entityVarBox);
        JPanel p = new JPanel(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_typePanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)entityPnl, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(5, 7, 5, 7), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_sdoCapable, (int)0, (int)row++, (int)3, (int)1, (int)18, (int)2, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_applyBtn);
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_tab, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(AbstractActivityNodeEditor.PREF_DIM);
        this.setLocationRelativeTo(this.getParent());
    }

    protected boolean validateData() {
        String name = this.m_nameField.getText().trim();
        if (name == null || name.length() == 0) {
            GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_NO_NAME"), (int)0);
            return false;
        }
        if (this.m_typePanel.getSelectedTypeObject() == null) {
            GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_NO_TYPE"), (int)0);
            return false;
        }
        return true;
    }

    public Variable getVariable() {
        return this.m_variable;
    }

    protected void save() {
        if (this.m_variable == null) {
            this.m_variable = (Variable)BPELParser.createImplementation(Variable.class);
        }
        this.m_variable.setName(this.m_nameField.getText());
        TypeObject to = this.m_typePanel.getSelectedTypeObject();
        QName q1 = to.getQName();
        String prefix = this.m_process.addNamespace(q1.getNamespaceURI());
        QName qname2 = new QName(q1.getNamespaceURI(), q1.getLocalPart(), prefix);
        if (this.m_typePanel.isSimpleTypeSelected()) {
            this.m_variable.setType(qname2);
            this.m_variable.setMessageType(null);
            this.m_variable.setElement(null);
        } else if (this.m_typePanel.isMessageTypeSelected()) {
            this.m_variable.setMessageType(qname2);
            this.m_variable.setType(null);
            this.m_variable.setElement(null);
            if (this.m_bNeedAddImport) {
                this.addImport();
            }
        } else if (this.m_typePanel.isElementSelected()) {
            this.m_variable.setElement(qname2);
            this.m_variable.setType(null);
            this.m_variable.setMessageType(null);
            if (this.m_bNeedAddImport) {
                this.addImport();
            }
        }
        if (this.m_entityVarBox.isSelected()) {
            String pl = this.m_partnerLinkField.getText();
            if (Helper.hasValue((String)pl)) {
                this.m_variable.setPartnerlink(pl);
            } else {
                this.m_variable.setPartnerlink(" ");
            }
        } else {
            this.m_variable.setPartnerlink(null);
        }
        this.m_variable.setSdoCapable(this.m_sdoCapable.isSelected());
    }

    protected void handleEntityVariableSelection() {
        if (this.m_entityPartnerLinkLbl != null) {
            this.m_entityPartnerLinkLbl.setEnabled(this.m_entityVarBox.isSelected());
        }
        this.m_partnerLinkBrowseBtn.setEnabled(this.m_entityVarBox.isSelected());
    }

    protected void handleOK() {
        if (!this.isValidData()) {
            return;
        }
        this.save();
        this.m_retVal = 0;
        this.dispose();
    }

    protected void handleApply() {
        if (this.isValidData()) {
            this.m_bCreating = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_applyBtn) {
            this.handleApply();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        } else if (src == this.m_entityVarBox) {
            this.handleEntityVariableSelection();
        } else if (src == this.m_partnerLinkBrowseBtn) {
            this.handlePartnerLinkBrowse();
        }
    }

    protected void helpInvoked() {
        HelpSystem.showHelp((Window)((Object)this), this.m_genPanel, "bpmjdev_var_create");
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected boolean isValidData() {
        this.m_bModified = false;
        if (this.m_bCreating) {
            if (!BPELModelUtil.isUniqueName((List)this.m_variablesFilter, (String)this.m_nameField.getText())) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_VAR_EXIST"));
                return false;
            }
            this.m_bNeedAddImport = this.needAddImport();
            if (this.m_bNeedAddImport) {
                this.m_selectedPartnerLinkURL = this.findPartnerLinkForSaving();
                if (this.m_selectedPartnerLinkURL == null) {
                    return false;
                }
            }
        } else {
            String origName = this.m_variable.getName();
            String newName = this.m_nameField.getText();
            if (newName == null || newName.length() == 0) {
                return false;
            }
            if (newName.equalsIgnoreCase(origName)) {
                return true;
            }
            if (!BPELModelUtil.isUniqueName((List)this.m_variablesFilter, (String)newName)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_VAR_EXIST"));
                return false;
            }
        }
        return true;
    }

    protected void updateButtons() {
        String pl;
        String name = this.m_nameField.getText();
        if (name == null || name.length() == 0) {
            this.m_okBtn.setEnabled(false);
            this.m_applyBtn.setEnabled(false);
            return;
        }
        boolean validEV = true;
        if (this.m_entityVarBox.isSelected() && ((pl = this.m_partnerLinkField.getText()) == null || pl.trim().length() == 0)) {
            validEV = false;
        }
        this.m_okBtn.setEnabled(this.m_typePanel.getSelectedTypeObject() != null && validEV);
        this.m_applyBtn.setEnabled(this.m_okBtn.isEnabled());
    }

    protected boolean needAddImport() {
        TypeObject to = this.m_typePanel.getSelectedTypeObject();
        int filetype = to.getFileType();
        if (filetype != 1 && filetype != 0 && filetype != 6 && filetype != 5) {
            return false;
        }
        URL url = this.m_typePanel.getURLForSelectedNode();
        if (url == null) {
            return false;
        }
        boolean bAdd = false;
        if (filetype == 1 || filetype == 6 || filetype == 5) {
            bAdd = true;
        } else {
            List list;
            PartnerLinks pls = this.m_process.getPartnerLinks();
            if (pls != null && (list = pls.getPartnerLinks()) != null) {
                boolean bIsPartnerLink = false;
                for (int i = 0; i < list.size() && !bIsPartnerLink; ++i) {
                    PartnerLink pl = (PartnerLink)list.get(i);
                    if (!url.toExternalForm().equals(pl.getWSDLLocation())) continue;
                    bIsPartnerLink = true;
                }
                if (!bIsPartnerLink) {
                    bAdd = true;
                }
            }
        }
        return bAdd;
    }

    protected void addImport() {
        TypeObject to = this.m_typePanel.getSelectedTypeObject();
        URL url = this.m_typePanel.getURLForSelectedNode();
        QName q1 = to.getQName();
        try {
            BPELProject project = this.m_graph.getBPELProject();
            if (!BPELProjectUtil.isEmptyBPELProcess((BPELProject)project)) {
                URL wsdlURL = project.getWSDLFileURL(project.getProcessName());
                if (wsdlURL != null && !wsdlURL.equals(url)) {
                    WSDLUtil.addImportToWSDL((BPELProject)project, (URL)url, (String)q1.getNamespaceURI());
                }
            } else if (this.m_selectedPartnerLinkURL != null && !this.m_selectedPartnerLinkURL.equals(url)) {
                WSDLUtil.addImportToWSDL((BPELProject)this.m_graph.getBPELProject(), (URL)this.m_selectedPartnerLinkURL, (URL)url, (String)q1.getNamespaceURI());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected URL findPartnerLinkForSaving() {
        BPELGraphModel graphModel;
        Process process;
        Map map;
        BPELProject prj = this.m_graph.getBPELProject();
        URL url = prj.getWSDLFileURL(prj.getProcessName());
        if (Helper.exists((URL)url)) {
            return url;
        }
        String s = (String)prj.getProjectData("PropertyPL");
        if (s != null) {
            try {
                url = new URL(s);
                if (Helper.exists((URL)url)) {
                    return url;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((map = BPELModelerUtil.getWSDLURIsForPartnerLinks((Process)(process = (graphModel = (BPELGraphModel)this.m_graph.getModel()).getProcess()), (DeploymentFile)prj.getDeploymentFile())) == null) {
            if (GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"You must have a WSDL file to save the change.\nDo you want to create a new WSDL file?", (String)"No WSDL File Found For This Process") == 0) {
                url = WSDLUtil.getWSDLFileForEmptyProcess((BPELProject)this.m_graph.getBPELProject());
                prj.storeProjectData("PropertyPL", (Object)url.toString());
                return url;
            }
            return null;
        }
        URL projURL = prj.getProjectURL();
        Object[] objs = map.keySet().toArray();
        for (int i = 0; i < objs.length; ++i) {
            try {
                Object name = objs[i];
                URI u = (URI)map.get(name);
                if (Helper.isBaseURLFor((URL)projURL, (URL)u.toURL())) continue;
                map.remove(name);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (map.size() == 0) {
            if (GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"You must have a WSDL file to save the change.\nDo you want to create a new WSDL file?", (String)"No WSDL File Found For This Process") == 0) {
                url = WSDLUtil.getWSDLFileForEmptyProcess((BPELProject)this.m_graph.getBPELProject());
                prj.storeProjectData("PropertyPL", (Object)url.toString());
                return url;
            }
            return null;
        }
        if (map.size() == 1) {
            URI uri = (URI)map.values().iterator().next();
            try {
                url = uri.toURL();
            }
            catch (Exception ex) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"Invalid URL for the selected partner link.", (int)0);
            }
        } else {
            PartnerLinkSelectionDialog dlg = new PartnerLinkSelectionDialog(GraphUtils.getFrame((Component)((Object)this)), map, 2);
            if (dlg.select() == 0) {
                url = dlg.getSelectedPartnerLinkURL();
            }
        }
        if (url != null) {
            prj.storeProjectData("PropertyPL", (Object)url.toString());
            try {
                prj.save();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return url;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName;
        Object src = evt.getSource();
        if (src == this.m_typePanel && (propName = evt.getPropertyName()) != null && propName.equals("TYPE_SELECTED")) {
            this.m_bModified = true;
            this.updateButtons();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateButtons();
    }

    protected JPanel createEntityVariablePanel(JButton browserBtn, JTextField textField, JCheckBox cb) {
        String title = BPELStringTranslator.getString("ENTITY_VARIABLE", "Entity Variable");
        String textLabel = BPELStringTranslator.getString("EDITOR_RCV_PL", "Partner &Link");
        ToolBar tb = new ToolBar();
        tb.add((Component)browserBtn);
        BPELStringTranslator.setButton(cb, title);
        cb.addActionListener(this);
        cb.setFont(UIManager.getFont("TitledBorder.font"));
        cb.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        JPanel p = new JPanel(new GridBagLayout());
        this.m_entityPartnerLinkLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_entityPartnerLinkLbl, textField, textLabel);
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)this.m_entityPartnerLinkLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)textField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        return new ComponentBorderPane((JComponent)cb, (JComponent)p);
    }

    protected void handlePartnerLinkBrowse() {
        PartnerLinkChooser dlg = new PartnerLinkChooser(GraphUtils.getFrame((Component)((Object)this)), this.m_graph, this.m_activity);
        if (dlg.display() == 0) {
            PartnerLink pl = dlg.getSelectedPartnerLink();
            if (pl != null) {
                this.m_partnerLinkField.setText(pl.getName());
            } else {
                this.m_partnerLinkField.setText("");
            }
        }
    }
}

