/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class VariableAutoCreationDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JRadioButton m_globalRB;
    protected JRadioButton m_localRB;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected int m_retVal = 1;
    protected JTextField m_nameField;
    protected JTextField m_typeField;
    protected Activity m_activity;
    protected BPELGraphPane m_graph;
    protected Process m_process;
    protected String m_variableName;
    protected String m_variableType;
    protected boolean m_hasScope = false;

    public VariableAutoCreationDialog(JFrame f, BPELGraphPane graph, Activity activity, String name, String type, boolean hasScope) {
        super(f, BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG"), true);
        this.m_graph = graph;
        if (graph != null) {
            BPELGraphModel model = (BPELGraphModel)graph.getModel();
            this.m_process = model.getProcess();
        }
        this.m_activity = activity;
        this.m_variableName = name;
        this.m_variableType = type;
        this.m_hasScope = hasScope;
        this.createAndLayoutControls();
        this.loadControls();
    }

    protected void loadControls() {
        this.m_nameField.setText(this.m_variableName);
        this.m_typeField.setText(this.m_variableType);
        this.m_typeField.setCaretPosition(0);
    }

    public int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_nameField = new JTextField();
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME", "&Name"));
        this.m_typeField = new JTextField();
        this.m_typeField.setEditable(false);
        JLabel typeLbl = new JLabel(BPELStringTranslator.getString("EDITOR_COR_SET_PNL_TYPE"));
        BPELStringTranslator.setLabel(typeLbl, this.m_typeField, BPELStringTranslator.getString("EDITOR_COR_SET_PNL_TYPE"));
        this.m_globalRB = new JRadioButton(BPELStringTranslator.getString("GLOBAL_VARIABLE"), true);
        BPELStringTranslator.setButton(this.m_globalRB, BPELStringTranslator.getString("GLOBAL_VARIABLE"));
        this.m_globalRB.addActionListener(this);
        this.m_localRB = new JRadioButton(BPELStringTranslator.getString("LOCAL_VARIABLE"), false);
        BPELStringTranslator.setButton(this.m_localRB, BPELStringTranslator.getString("LOCAL_VARIABLE"));
        this.m_localRB.addActionListener(this);
        this.m_localRB.setEnabled(this.m_hasScope);
        ButtonGroup g = new ButtonGroup();
        g.add(this.m_globalRB);
        g.add(this.m_localRB);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_nameField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)typeLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_typeField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)this.m_globalRB, (int)1, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 0, 10, 20), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_localRB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 20, 10, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)2, (int)1, (int)13, (int)0, (Insets)new Insets(0, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(370, 165);
        this.setLocationRelativeTo(this.getParent());
    }

    public String getVariableName() {
        return this.m_variableName;
    }

    public boolean isGlobal() {
        return this.m_globalRB.isSelected();
    }

    protected void save() {
        String s = this.m_nameField.getText();
        if (s != null) {
            s = s.trim();
        }
        this.m_variableName = s;
    }

    protected boolean isDataValid() {
        String varName = this.m_nameField.getText();
        if (varName == null || varName.length() == 0) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_NO_NAME"));
            return false;
        }
        Variables variables = this.m_process.getVariables();
        if (variables == null) {
            return true;
        }
        if (this.isGlobal()) {
            if (!BPELModelUtil.isUniqueName((List)variables.getVariables(), (String)varName)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_VAR_EXIST"));
                return false;
            }
        } else {
            List scopes = BPELModelUtil.getParentScopes((Activity)this.m_activity);
            if (scopes.size() == 0 && !BPELModelUtil.isUniqueName((List)variables.getVariables(), (String)varName)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_VAR_EXIST"));
                return false;
            }
            ArrayList vlist = new ArrayList();
            for (int i = 0; i < scopes.size(); ++i) {
                Variables vars;
                Scope scope = (Scope)scopes.get(i);
                if (scope == null || (vars = scope.getVariables()) == null) continue;
                vlist.addAll(vars.getVariables());
            }
            if (!BPELModelUtil.isUniqueName(vlist, (String)varName)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_VAR_CRE_DLG_VAR_EXIST"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (!this.isDataValid()) {
                return;
            }
            this.save();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }
}

