/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TransformationEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TransformationSourcePickerDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TransformationSourceTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableListItem;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.TablePanel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class TransformationSourceTablePanel
extends TablePanel {
    protected BPELGraphPane m_graphPane;
    protected JButton m_upBtn;
    protected JButton m_downBtn;
    protected TransformationEditPage m_page;
    protected Activity m_activity;

    public TransformationSourceTablePanel(BaseTableModel tabModel, BPELGraphPane pane, TransformationEditPage page) {
        super(tabModel, new Insets(0, 0, 0, 0));
        this.setTableLabelText(BPELStringTranslator.getString("EDITOR_TRFM_SRC"));
        this.m_graphPane = pane;
        this.m_page = page;
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = TransformationSourceTablePanel.this.m_table.rowAtPoint(origin);
                int column = TransformationSourceTablePanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    TransformationSourceTablePanel.this.doEdit(row);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.m_upBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("arrow_up_blue16"), (String)BPELStringTranslator.getString("MOVE_UP_TIP"), (String)BPELStringTranslator.getString("MOVE_UP_MNEMONIC"));
        this.m_upBtn.addActionListener(this);
        this.m_downBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("arrow_down_blue16"), (String)BPELStringTranslator.getString("MOVE_DOWN_TIP"), (String)BPELStringTranslator.getString("MOVE_DOWN_MNEMONIC"));
        this.m_downBtn.addActionListener(this);
        this.m_toolBar.removeAll();
        this.m_toolBar.add((Component)this.m_createBtn);
        this.m_toolBar.add((Component)this.m_editBtn);
        this.m_toolBar.add((Component)this.m_removeBtn);
        this.m_toolBar.add((Component)this.m_upBtn);
        this.m_toolBar.add((Component)this.m_downBtn);
    }

    public void setActivity(Activity activity) {
        this.m_activity = activity;
    }

    @Override
    public void performAdd() {
        TransformationSourcePickerDialog dlg = new TransformationSourcePickerDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_page);
        if (dlg.create() == 0) {
            TransformationSourceTableModel model = (TransformationSourceTableModel)((Object)this.m_table.getModel());
            Vector<String> data = new Vector<String>();
            data.add(0, this.m_page.getSelectedVariable(this.m_page.m_srcVarCombo));
            data.add(1, this.m_page.getSelectedPart(this.m_page.m_srcPart));
            model.insertRow(data);
            model.refresh();
            this.setModified(true);
        }
    }

    @Override
    protected void doEdit(int row) {
        if (row == -1) {
            return;
        }
        TransformationSourceTableModel model = (TransformationSourceTableModel)((Object)this.m_table.getModel());
        Vector data = (Vector)model.getRow(row);
        String fromVarName = (String)data.get(0);
        String fromPartName = (String)data.get(1);
        TransformationSourcePickerDialog dlg = new TransformationSourcePickerDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_page);
        this.m_page.selectVariable(fromVarName, this.m_page.m_srcVarCombo);
        this.m_page.asyncLoadPart((VariableListItem)this.m_page.getSelectedComboBoxValue(this.m_page.m_srcVarCombo), this.m_page.m_srcPart, fromPartName, dlg);
        if (dlg.edit(data) == 0) {
            data.add(0, this.m_page.getSelectedVariable(this.m_page.m_srcVarCombo));
            data.add(1, this.m_page.getSelectedPart(this.m_page.m_srcPart));
            this.setModified(true);
        }
    }

    @Override
    public void performRemove() {
        TransformationSourceTableModel model = (TransformationSourceTableModel)((Object)this.m_table.getModel());
        int[] rows = this.m_table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        model.deleteRows(rows);
        model.refresh();
        this.setModified(true);
    }

    protected void setModified(boolean b) {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof BaseEditingPage); p = p.getParent()) {
        }
        if (p instanceof BaseEditingPage) {
            BaseEditingPage page = (BaseEditingPage)p;
            page.setModified(b);
        }
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        ListSelectionModel model = this.m_table.getSelectionModel();
        int sel = model.getMinSelectionIndex();
        if (sel == -1) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(false);
        } else if (sel == 0) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(this.m_table.getModel().getRowCount() > 1);
        } else {
            this.m_upBtn.setEnabled(true);
            if (sel + 1 == this.m_table.getModel().getRowCount()) {
                this.m_downBtn.setEnabled(false);
            } else {
                this.m_downBtn.setEnabled(true);
            }
        }
    }

    public void performMoveUp() {
        TransformationSourceTableModel model = (TransformationSourceTableModel)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveUp(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel - 1, sel - 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel - 1, 0, true));
        }
    }

    public void performMoveDown() {
        TransformationSourceTableModel model = (TransformationSourceTableModel)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveDown(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel + 1, sel + 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel + 1, 0, true));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_upBtn) {
            this.performMoveUp();
        } else if (src == this.m_downBtn) {
            this.performMoveDown();
        } else {
            super.actionPerformed(e);
        }
    }
}

