/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.util.Vector;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class TransformationSourceTableModel
extends BaseTableModel {
    private String[] m_columnHeader = null;

    public TransformationSourceTableModel(String[] columnNames) {
        this.m_columnHeader = columnNames;
    }

    public Object getValueAt(int row, int col) {
        Vector data = (Vector)this.m_data.elementAt(row);
        if (col < data.size()) {
            return data.get(col);
        }
        return "";
    }

    public Object getRow(int row) {
        return this.m_data.elementAt(row);
    }

    public void setRow(Object obj, int row) {
        this.m_data.setElementAt(obj, row);
    }

    public void insertRow(Object obj) {
        this.m_data.insertElementAt(obj, this.m_data.size());
    }

    public void deleteRows(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            this.m_data.removeElementAt(rows[i]);
        }
    }

    public void deleteRow(int row) {
        this.m_data.removeElementAt(row);
    }

    public int getColumnCount() {
        return this.m_columnHeader.length;
    }

    public void moveDown(int row) {
        if (row < 0 || row + 1 >= this.m_data.size()) {
            return;
        }
        Object curObj = this.m_data.get(row);
        this.m_data.set(row, this.m_data.get(row + 1));
        this.m_data.set(row + 1, curObj);
        this.fireTableRowsUpdated(row, row + 1);
    }

    public String getColumnName(int col) {
        return BPELStringTranslator.getString(this.m_columnHeader[col]);
    }

    public void removeAllData() {
        this.m_data.removeAllElements();
        this.fireTableDataChanged();
    }

    public void moveUp(int row) {
        if (row <= 0 || row >= this.m_data.size()) {
            return;
        }
        Object curObj = this.m_data.get(row);
        this.m_data.set(row, this.m_data.get(row - 1));
        this.m_data.set(row - 1, curObj);
        this.fireTableRowsUpdated(row - 1, row);
    }
}

