/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TransformationEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class TransformationSourcePickerDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected TransformationEditPage m_page;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected boolean m_bEditing = false;

    public TransformationSourcePickerDialog(JFrame f, BPELGraphPane graph, TransformationEditPage page) {
        super(f, BPELStringTranslator.getString("EDITOR_TRFM_SELECT_SRC", "Source Variable"), true);
        this.m_graph = graph;
        this.m_page = page;
        this.createAndLayoutControls();
        this.updateButtons();
    }

    public void saveToModel() {
    }

    public int create() {
        this.m_bEditing = false;
        this.setTitle(BPELStringTranslator.getString("EDITOR_TRFM_SELECT_SRC", "Source Variable"));
        return this.display();
    }

    public int create(String expre, QName key) {
        this.m_bEditing = false;
        return this.display();
    }

    public int edit(Object p) {
        this.m_bEditing = true;
        return this.display();
    }

    private int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        JPanel source = this.m_page.getSourcePanel(this);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)source, (int)0, (int)row++, (int)2, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(350, 225);
        GraphUtils.centerInScreen((Component)((Object)this));
    }

    protected void updateButtons() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected boolean doesKeyExist(String name) {
        return false;
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected void helpInvoked() {
        String topID = oracle.tip.tools.ide.pm.modules.help.HelpSystem.getHelpTopicId(this.getClass().getName());
        if (HelpSystem.getHelpSystem().doesTopicExist(topID)) {
            this.handleHelp((Component)((Object)this));
        } else {
            this.handleHelp(this.m_page);
        }
    }
}

