/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.models.wsdl.PartItem;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Transformation;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.ContentUtil;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLImport;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TransformationSourceTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TransformationSourceTablePanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableListItem;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.tx.addin.AddinUtil;
import oracle.tip.tools.ide.tx.addin.MapperCreator;
import oracle.tip.tools.ide.tx.addin.MapperSource;
import oracle.tip.tools.ide.tx.addin.MapperTarget;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDNode;
import org.w3c.dom.Element;

public class TransformationEditPage
extends BaseEditingPage
implements ActionListener {
    public static String BPEL20_NS = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";
    public static String BPEL20_PREFIX = "bpel20";
    public static final String OLD_EXPRESSION_FORMAT = "ora:processXSLT(''{0}'',bpws:getVariableData(''{1}'',''{2}'',))";
    public static final String OLD_EXPRESSION_FORMAT_1 = "ora:processXSLT(''{0}'',bpws:getVariableData(''{1}'',''{2}''))";
    public static final String OLD_EXPRESSION_FORMAT_2 = "ora:processXSLT(''{0}'',bpws:getVariableData(''{1}''))";
    public static final String EXPRESSION_FORMAT_1 = "ora:doXSLTransformForDoc(''{0}'',bpws:getVariableData(''{1}'',''{2}''))";
    public static final String EXPRESSION_FORMAT_2 = "ora:doXSLTransformForDoc(''{0}'',bpws:getVariableData(''{1}''))";
    public static final String EXPRESSION_FORMAT_3 = "ora:doXSLTransformForDoc(''{0}'',bpws:getVariableData(''{1}'',''{2}''){3})";
    public static final String EXPRESSION_FORMAT_4 = "ora:doXSLTransformForDoc(''{0}'',bpws:getVariableData(''{1}''){2})";
    public static final String PARAMS_FORMAT_1 = ",''{0}'',bpws:getVariableData(''{1}'',''{2}''){3}";
    public static final String PARAMS_FORMAT_2 = ",''{0}'',bpws:getVariableData(''{1}''){2}";
    public static final String PARSING_FORMAT_MAIN = "ora:doXSLTransformForDoc({0},{1}";
    public static final String PARSING_FORMAT_VAR = "bpws:getVariableData({0}){1}";
    public static final String PARSING_FORMAT_PARAM_NAME = "{0},{1}";
    public static final String MAPPER_EXTENSION = "xsl";
    public static final String DOT_MAPPER_EXTENSION = ".xsl";
    public static final String ORA_NS = "http://schemas.oracle.com/xpath/extension";
    public static final String ORA = "ora";
    protected JComboBox m_srcVarCombo;
    protected JComboBox m_targetVarCombo;
    protected JList m_srcPart;
    protected JList m_targetPartList;
    protected JTextField m_mapperFile;
    protected JButton m_browseBtn;
    protected JButton m_createBtn;
    protected JButton m_editBtn;
    protected Transformation m_activity;
    protected Copy m_copy;
    protected String m_extistMapperFileName;
    protected String m_toVarName;
    protected String m_toPartName;
    protected int m_counter = 0;
    protected boolean m_bCreatingMapper;
    protected TransformationSourceTablePanel m_sourceTablePanel;
    protected TransformationSourceTableModel m_tableModel = null;
    private String[] m_columnHeader = new String[]{"EDITOR_TRFM_VAR", "EDITOR_TRFM_PART"};
    protected Vector m_srcSelections = null;

    public TransformationEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
        this.m_sourceTablePanel.updateButtons();
    }

    protected void createControls() {
        this.m_srcVarCombo = new JComboBox();
        this.m_srcPart = new JList(new DefaultListModel());
        this.m_srcPart.setSelectionMode(0);
        this.m_targetVarCombo = new JComboBox();
        this.m_targetPartList = new JList(new DefaultListModel());
        this.m_targetPartList.setSelectionMode(0);
        this.m_mapperFile = new JTextField();
        this.m_browseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("EDITOR_TRFM_BWS_MAPPING"));
        this.m_createBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_createBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_TRFM_CRT_MAPPING"));
        this.m_editBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("edit16"));
        this.m_editBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_TRFM_EDT_MAPPING"));
        this.m_browseBtn.addActionListener(this);
        this.m_createBtn.addActionListener(this);
        this.m_editBtn.addActionListener(this);
        this.m_tableModel = new TransformationSourceTableModel(this.m_columnHeader);
        this.m_srcSelections = this.m_tableModel.getData();
        this.m_sourceTablePanel = new TransformationSourceTablePanel(this.m_tableModel, this.m_graphPane, this);
        this.m_sourceTablePanel.setPreferredSize(new Dimension(300, 3000));
        TableColumnModel colModel = this.m_sourceTablePanel.getTable().getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setWidth(190);
            col.setPreferredWidth(190);
        }
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)this.m_sourceTablePanel, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.createTargetPanel(), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.createMapperPanel(), (int)0, (int)row, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected JPanel createTargetPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel targetVarLbl = new JLabel();
        BPELStringTranslator.setLabel(targetVarLbl, this.m_targetVarCombo, BPELStringTranslator.getString("EDITOR_TRFM_TAR_VAR"));
        JLabel targetPartLbl = new JLabel();
        BPELStringTranslator.setLabel(targetPartLbl, this.m_targetPartList, BPELStringTranslator.getString("EDITOR_TRFM_TAR_PART"));
        int row = 0;
        GraphUtils.addComponent((Container)panel, (Component)targetVarLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)targetPartLbl, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_targetVarCombo, (int)0, (int)row, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(2, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)panel, (Component)new JScrollPane(this.m_targetPartList), (int)1, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(2, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return panel;
    }

    protected JPanel getSourcePanel(BPELBaseDialog dlg) {
        SourceVariableItemListener varListner = new SourceVariableItemListener(dlg);
        this.m_srcVarCombo.addItemListener(varListner);
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel lblSrcVar = new JLabel();
        BPELStringTranslator.setLabel(lblSrcVar, this.m_srcVarCombo, BPELStringTranslator.getString("EDITOR_TRFM_SRC_VAR"));
        JLabel lblSrcPart = new JLabel();
        BPELStringTranslator.setLabel(lblSrcPart, this.m_srcPart, BPELStringTranslator.getString("EDITOR_TRFM_SRC_PART"));
        JScrollPane srcScrollPane = new JScrollPane(this.m_srcPart);
        int row = 0;
        GraphUtils.addComponent((Container)panel, (Component)lblSrcVar, (int)0, (int)row++, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_srcVarCombo, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(2, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)lblSrcPart, (int)0, (int)row++, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)srcScrollPane, (int)0, (int)row, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(2, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return panel;
    }

    protected JPanel createMapperPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel mapperLbl = new JLabel();
        BPELStringTranslator.setLabel(mapperLbl, this.m_mapperFile, BPELStringTranslator.getString("EDITOR_TRFM_MAP_FILE"));
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_browseBtn);
        tb.add((Component)this.m_createBtn);
        tb.add((Component)this.m_editBtn);
        GraphUtils.addComponent((Container)panel, (Component)mapperLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_mapperFile, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)tb, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 2, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        return panel;
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Transformation)model;
    }

    @Override
    public void loadData() {
        this.loadControls();
    }

    protected void loadControls() {
        List list;
        this.loadVariables(this.m_srcVarCombo, (Activity)this.m_activity, false);
        this.loadVariables(this.m_targetVarCombo, (Activity)this.m_activity, false);
        if (this.m_activity != null && (list = this.m_activity.getCopyRules()) != null && list.size() > 0) {
            this.m_copy = (Copy)list.get(0);
        }
        this.loadSource();
        this.loadTarget();
        this.checkSourceAndTargetMatched();
    }

    private boolean getFromInfo(String strExpression) {
        boolean bCreateName = true;
        if (strExpression.startsWith("ora:processXSLT")) {
            URL url;
            URL bpelDirURL;
            Vector<Object> v;
            Object[] obj;
            boolean bSuccess = true;
            MessageFormat fmt = strExpression.endsWith(",))") ? new MessageFormat(OLD_EXPRESSION_FORMAT) : new MessageFormat(OLD_EXPRESSION_FORMAT_1);
            try {
                obj = fmt.parse(strExpression);
                if (obj != null && obj.length == 3) {
                    v = new Vector<Object>();
                    v.add(obj[1]);
                    if (obj[2] != null) {
                        v.add(obj[2]);
                    }
                    this.m_tableModel.insertRow(v);
                    bpelDirURL = this.m_graphPane.getBPELProject().getBPELDirectoryURL();
                    url = URLFactory.newURL((URL)bpelDirURL, (String)obj[0].toString());
                    this.m_mapperFile.setText(obj[0].toString());
                    this.m_extistMapperFileName = url.toExternalForm();
                    bCreateName = false;
                }
            }
            catch (ParseException ex) {
                bSuccess = false;
            }
            if (!bSuccess) {
                fmt = new MessageFormat(OLD_EXPRESSION_FORMAT_2);
                try {
                    obj = fmt.parse(strExpression);
                    if (obj != null && obj.length == 2) {
                        v = new Vector();
                        v.add(obj[1]);
                        this.m_tableModel.insertRow(v);
                        bpelDirURL = this.m_graphPane.getBPELProject().getBPELDirectoryURL();
                        url = URLFactory.newURL((URL)bpelDirURL, (String)obj[0].toString());
                        this.m_mapperFile.setText(obj[0].toString());
                        this.m_extistMapperFileName = url.toExternalForm();
                        bCreateName = false;
                    }
                }
                catch (ParseException ex) {}
            }
        } else {
            MessageFormat fmt = new MessageFormat(PARSING_FORMAT_MAIN);
            try {
                Object[] obj = fmt.parse(strExpression);
                if (obj != null && obj.length == 2) {
                    String xsl = (String)obj[0];
                    xsl = xsl.trim();
                    xsl = xsl.substring(1, xsl.length() - 1);
                    URL bpelDirURL = this.m_graphPane.getBPELProject().getBPELDirectoryURL();
                    URL url = URLFactory.newURL((URL)bpelDirURL, (String)xsl);
                    this.m_mapperFile.setText(xsl);
                    this.m_extistMapperFileName = url.toExternalForm();
                    String var = (String)obj[1];
                    String params = null;
                    String[] ret = TransformationEditPage.parseSource(var);
                    Vector<String> v = new Vector<String>();
                    v.add(ret[0]);
                    v.add(ret[1]);
                    this.m_tableModel.insertRow(v);
                    params = ret[2];
                    while (Helper.hasValue((String)params)) {
                        fmt = new MessageFormat(PARSING_FORMAT_PARAM_NAME);
                        Object[] paramsObj = fmt.parse(params);
                        String paramName = (String)paramsObj[0];
                        paramName = paramName.trim();
                        paramName = paramName.substring(1, paramName.length() - 1);
                        ret = TransformationEditPage.parseSource((String)paramsObj[1]);
                        v = new Vector();
                        v.add(ret[0]);
                        v.add(ret[1]);
                        v.add(paramName);
                        this.m_tableModel.insertRow(v);
                        params = ret[2];
                    }
                    bCreateName = false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return bCreateName;
    }

    protected void loadSource() {
        String strExpression;
        boolean bCreateName = true;
        if (this.m_copy != null && (strExpression = this.m_copy.getFrom().getExpression()) != null) {
            bCreateName = this.getFromInfo(strExpression);
        }
        if (this.m_srcVarCombo.getItemCount() > 0) {
            this.m_srcVarCombo.setSelectedIndex(0);
        }
        this.asyncLoadPart((VariableListItem)this.getSelectedComboBoxValue(this.m_srcVarCombo), this.m_srcPart, null, null);
        if (bCreateName) {
            this.m_mapperFile.setText(this.getNewMapperFileName());
        }
    }

    protected void loadTarget() {
        if (this.m_copy != null) {
            To to = this.m_copy.getTo();
            this.m_toVarName = to.getVariable();
            this.m_toPartName = to.getPart();
        }
        if (this.m_toVarName != null) {
            this.selectVariable(this.m_toVarName, this.m_targetVarCombo);
        } else if (this.m_targetVarCombo.getItemCount() > 0) {
            this.m_targetVarCombo.setSelectedIndex(0);
        }
        TargetVariableItemListener varListner = new TargetVariableItemListener();
        this.m_targetVarCombo.addItemListener(varListner);
        this.asyncLoadPart((VariableListItem)this.getSelectedComboBoxValue(this.m_targetVarCombo), this.m_targetPartList, this.m_toPartName, null);
    }

    protected void loadPart(VariableListItem varItem, JList partList, String part) {
        DefaultListModel model = (DefaultListModel)partList.getModel();
        model.removeAllElements();
        if (varItem == null) {
            return;
        }
        QName msgQName = varItem.getVariable().getMessageType();
        if (msgQName == null) {
            return;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        BPELProject prj = this.getBPELProject();
        List list = BPELModelerUtil.getWSDLFromNamespaceURI((Process)graphModel.getProcess(), (DeploymentFile)prj.getDeploymentFile(), (String)msgQName.getNamespaceURI());
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String realNamespace = msgQName.getNamespaceURI();
            WSDLPartData[] parts = null;
            try {
                parts = WSDLUtil.getParts((URI)((URI)it.next()), (String)msgQName.getLocalPart(), (String)realNamespace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (parts == null) continue;
            for (int i = 0; i < parts.length; ++i) {
                model.addElement(new PartItem(parts[i].getPartName(), parts[i].getTargetNamespace(), parts[i].getPartType(), parts[i].getPartXSDType()));
            }
        }
        if (part != null) {
            int sz = model.getSize();
            for (int i = 0; i < sz; ++i) {
                PartItem item;
                Object obj = model.getElementAt(i);
                if (!(obj instanceof PartItem) || !(item = (PartItem)obj).getName().equals(part)) continue;
                partList.setSelectedIndex(i);
                return;
            }
        } else {
            partList.setSelectedIndex(0);
        }
    }

    protected void asyncLoadPart(VariableListItem varItem, JList partList, String part, final BPELBaseDialog dlg) {
        DefaultListModel model = (DefaultListModel)partList.getModel();
        model.removeAllElements();
        if (varItem == null) {
            return;
        }
        final QName msgQName = varItem.getVariable().getMessageType();
        if (msgQName == null) {
            return;
        }
        if (dlg != null) {
            dlg.enableUserInput(false);
        } else {
            this.enableUserInput(false);
        }
        final JList jlist = partList;
        final String strText = part;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final ListModel model = TransformationEditPage.this.getModelForMessagePart(msgQName);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            jlist.setModel(model);
                            if (model.getSize() == 0) {
                                jlist.setEnabled(false);
                            } else {
                                jlist.setEnabled(true);
                                if (strText != null) {
                                    TransformationEditPage.this.selectPartValue(jlist, strText);
                                } else if (model.getSize() == 1) {
                                    jlist.setSelectedIndex(0);
                                }
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (dlg != null) {
                        dlg.enableUserInput(true);
                    } else {
                        TransformationEditPage.this.enableUserInput(true);
                    }
                }
            }
        };
        new Thread(r).start();
    }

    protected ListModel getModelForMessagePart(QName msgQName) {
        DefaultListModel<PartItem> model = new DefaultListModel<PartItem>();
        List list = this.getURIForNamespaceURI(msgQName.getNamespaceURI());
        if (list == null) {
            return model;
        }
        Iterator it = list.iterator();
        boolean bShown = false;
        while (it.hasNext() && !bShown) {
            String realNamespace = msgQName.getNamespaceURI();
            WSDLPartData[] parts = null;
            try {
                parts = WSDLUtil.getParts((URI)((URI)it.next()), (String)msgQName.getLocalPart(), (String)realNamespace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (parts == null) continue;
            bShown = true;
            for (int i = 0; i < parts.length; ++i) {
                model.addElement(new PartItem(parts[i].getPartName(), parts[i].getTargetNamespace(), parts[i].getPartType(), parts[i].getPartXSDType()));
            }
        }
        return model;
    }

    protected List getURIForNamespaceURI(String namespaceURI) {
        List<URI> l;
        List plList;
        BPELProject prj;
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        WSDLModel wsdlModel = mainModel.getWSDLModel();
        Process process = mainModel.getProcess();
        ArrayList<URI> list = BPELModelerUtil.getWSDLFromNamespaceURI((Process)process, (DeploymentFile)(prj = mainModel.getBPELProject()).getDeploymentFile(), (String)namespaceURI);
        if (list == null) {
            list = new ArrayList<URI>();
        }
        List implist = null;
        try {
            wsdlModel.getImports();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (implist != null) {
            for (int i = 0; i < implist.size(); ++i) {
                WSDLImport imp = (WSDLImport)implist.get(i);
                if (!imp.getNamespaceURI().equals(namespaceURI)) continue;
                try {
                    list.add(new URI(URIUtil.escapeURIString((String)imp.getLocationURI())));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((plList = BPELModelerUtil.getWSDLURIsOfPartnerLinks((Process)process, (DeploymentFile)prj.getDeploymentFile())) != null) {
            for (int i = 0; i < plList.size(); ++i) {
                try {
                    URI uri = (URI)plList.get(i);
                    URI retURI = WSDLUtil.getSchemaURI((URI)uri, (String)namespaceURI);
                    if (retURI == null) continue;
                    list.add(retURI);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((l = wsdlModel.getURIForNamespaceURI(namespaceURI)) != null) {
            list.addAll(l);
        }
        return list;
    }

    protected void getModelForMessagePart(QName msgQName, JList partList) {
        DefaultListModel<PartItem> model = new DefaultListModel<PartItem>();
        partList.setModel(model);
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        BPELProject prj = this.m_graphPane.getBPELProject();
        List list = BPELModelerUtil.getWSDLFromNamespaceURI((Process)graphModel.getProcess(), (DeploymentFile)prj.getDeploymentFile(), (String)msgQName.getNamespaceURI());
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String realNamespace = msgQName.getNamespaceURI();
            WSDLPartData[] parts = null;
            try {
                parts = WSDLUtil.getParts((URI)((URI)it.next()), (String)msgQName.getLocalPart(), (String)realNamespace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (parts == null) continue;
            for (int i = 0; i < parts.length; ++i) {
                model.addElement(new PartItem(parts[i].getPartName(), parts[i].getTargetNamespace(), parts[i].getPartType(), parts[i].getPartXSDType()));
            }
        }
    }

    protected void selectPartValue(JList partList, String part) {
        ListModel model = partList.getModel();
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            PartItem item;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof PartItem) || !(item = (PartItem)obj).getName().equals(part)) continue;
            partList.setSelectedIndex(i);
            return;
        }
        partList.setSelectedIndex(0);
    }

    protected String getSelectedPart(JList list) {
        if (list.getSelectedIndex() == -1) {
            return null;
        }
        Object obj = list.getModel().getElementAt(list.getSelectedIndex());
        if (obj instanceof PartItem) {
            return ((PartItem)obj).getPart();
        }
        return null;
    }

    protected PartItem getSelectedPartItem(JList list) {
        if (list.getSelectedIndex() == -1) {
            return null;
        }
        Object obj = list.getModel().getElementAt(list.getSelectedIndex());
        if (obj instanceof PartItem) {
            return (PartItem)obj;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("EDITOR_TRFM_TITLE");
    }

    protected void getExistingMapperFile() {
        URL u = UIHelper.showResourcePicker((Component)this, (int)2);
        if (u != null) {
            Project proj = (Project)this.m_graphModel.getBPELProject().getProjectContext();
            SCAProject m_scaproj = SCAProject.getSCAProject((Project)proj);
            URL fileURL = CommonScaUtils.putFileinProjectDir((Component)GraphUtils.getFrame((Component)this), (Project)((Project)this.m_graphModel.getBPELProject().getProjectContext()), (URL)m_scaproj.getProjectRoot(), (URL)m_scaproj.getXSLRoot(), (URL)u, null);
            URL bpelDirURL = this.m_graphPane.getBPELProject().getBPELDirectoryURL();
            String relativeLoc = URLFileSystem.toRelativeSpec((URL)fileURL, (URL)bpelDirURL);
            this.m_mapperFile.setText(relativeLoc);
        }
    }

    protected void createNewMapperFile(boolean bStopEditing) {
        this.m_bCreatingMapper = false;
        MapperInfo info = this.validateMapperInfo();
        if (info == null) {
            return;
        }
        if (this.mapperFileExist(this.getMapperNameInURL())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_MAPPER_EXIST"));
            return;
        }
        final Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
        List sels = info.m_mapperInfos;
        if (sels.size() == 0) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_NO_SRC_SEL"));
            return;
        }
        final ArrayList<MapperSource> mapperSources = new ArrayList<MapperSource>(sels.size());
        for (int i = 0; i < sels.size(); ++i) {
            MapperSelectionInfo sel = (MapperSelectionInfo)sels.get(i);
            if (i == 0) {
                if (sel.m_srcPartQName != null) {
                    mapperSources.add(new MapperSource(sel.m_bSourceXSD ? 1 : 2, sel.m_sourceURL, sel.m_srcPartQName, sel.m_srcQName));
                    continue;
                }
                mapperSources.add(new MapperSource(sel.m_bSourceXSD ? 1 : 2, sel.m_sourceURL, sel.m_srcQName));
                continue;
            }
            QName paraName = new QName(sel.m_paramName);
            if (sel.m_srcPartQName != null) {
                mapperSources.add(new MapperSource(sel.m_bSourceXSD ? 1 : 2, sel.m_sourceURL, sel.m_srcPartQName, sel.m_srcQName, paraName));
                continue;
            }
            mapperSources.add(new MapperSource(sel.m_bSourceXSD ? 1 : 2, sel.m_sourceURL, sel.m_srcQName, null, paraName));
        }
        final ArrayList<MapperTarget> mapperTargets = new ArrayList<MapperTarget>(1);
        if (info.m_tarPartName != null) {
            mapperTargets.add(new MapperTarget(info.m_bTargetXSD ? 1 : 2, info.m_targetURL, info.m_tarPartName, info.m_tarQName));
        } else {
            mapperTargets.add(new MapperTarget(info.m_bTargetXSD ? 1 : 2, info.m_targetURL, info.m_tarQName));
        }
        final URL mapperURL = info.m_mapperURL;
        Runnable createMapperRunnable = new Runnable(){

            @Override
            public void run() {
                new MapperCreator(context).createMapper(mapperURL, mapperSources, mapperTargets, true);
            }
        };
        SwingUtilities.invokeLater(createMapperRunnable);
        this.m_bCreatingMapper = true;
        if (bStopEditing) {
            this.stopEditing();
        }
    }

    protected final URI getURIFromNamespace(List list, String namespace, String elementName, boolean bIsElement) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<URI> ulist = new ArrayList<URI>();
        for (int i = 0; i < list.size(); ++i) {
            WSDLImport imp = (WSDLImport)list.get(i);
            if (!imp.getNamespaceURI().equals(namespace)) continue;
            try {
                ulist.add(new URI(URIUtil.escapeURIString((String)imp.getLocationURI())));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        int size = ulist.size();
        if (size == 0) {
            return null;
        }
        return this.resolveElement(list, elementName, namespace, bIsElement);
    }

    protected URI resolveElement(List list, String elementName, String namespaceURI, boolean bIsElement) {
        for (int i = 0; i < list.size(); ++i) {
            try {
                URI uri = (URI)list.get(i);
                if (ContentUtil.isXSDDocument((URL)uri.toURL())) {
                    XSDBuilder xsdBuilder = new XSDBuilder();
                    XMLSchema schema = xsdBuilder.build(uri.toURL());
                    if (bIsElement) {
                        if (schema.getElement(namespaceURI, elementName) == null) continue;
                        return uri;
                    }
                    XMLSchemaNode schemaNode = schema.getSchemaByTargetNS(namespaceURI);
                    XSDNode[] xsdNodes = schemaNode.getComplexTypeSet();
                    if (xsdNodes == null) continue;
                    for (int j = 0; j < xsdNodes.length; ++j) {
                        if (xsdNodes[j].getName() == null || !elementName.equals(xsdNodes[j].getName())) continue;
                        return uri;
                    }
                    continue;
                }
                Object obj = WSDLUtil.resolvedSchema((URI)uri, (String)namespaceURI, (String)elementName, (boolean)bIsElement);
                if (obj == null) continue;
                if (obj instanceof WSDLUtil.WSDLSchemaWrapper) {
                    return ((WSDLUtil.WSDLSchemaWrapper)obj).getURI();
                }
                return uri;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    protected final URI getURIFromNamespaceInPLWSDL(String namespace, String elementName, boolean bIsElement) {
        int size;
        BPELProject prj = this.m_graphPane.getBPELProject();
        List plList = BPELModelerUtil.getWSDLURIsOfPartnerLinks((Process)this.m_graphModel.getProcess(), (DeploymentFile)prj.getDeploymentFile());
        ArrayList<URI> list = new ArrayList<URI>();
        if (plList != null) {
            for (int i = 0; i < plList.size(); ++i) {
                try {
                    URI uri = (URI)plList.get(i);
                    URI retURI = WSDLUtil.getSchemaURI((URI)uri, (String)namespace);
                    if (retURI == null) continue;
                    list.add(retURI);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((size = list.size()) == 0) {
            return null;
        }
        return this.resolveElement(list, elementName, namespace, bIsElement);
    }

    protected void editMapperFile() {
        if (!Helper.hasValue((String)this.m_mapperFile.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_NO_MAPPER_FILE"));
            return;
        }
        URL url = this.getMapperNameInURL();
        if (url == null) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_INVALID_FNAME_FMT"));
            return;
        }
        if (!this.mapperFileExist(this.getMapperNameInURL())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_MAPPER_FILE_NOT_EXIST"));
            return;
        }
        final URL mapperURL = url;
        Runnable openFileRunnable = new Runnable(){

            @Override
            public void run() {
                EditorManager.getEditorManager().openDefaultEditorInFrame(mapperURL);
            }
        };
        SwingUtilities.invokeLater(openFileRunnable);
        this.stopEditing();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_browseBtn) {
            this.getExistingMapperFile();
        } else if (src == this.m_createBtn) {
            this.createNewMapperFile(true);
        } else if (src == this.m_editBtn) {
            this.editMapperFile();
        }
    }

    @Override
    public boolean validateEditorChanges() {
        if (!Helper.hasValue((String)this.m_mapperFile.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_NO_MAPPER_FILE"));
            return false;
        }
        return this.validateMapperInfo() != null;
    }

    @Override
    public void saveChanges() {
        To to;
        From from;
        Vector data = this.m_tableModel.getData();
        if (data.size() == 0) {
            return;
        }
        if (!Helper.hasValue((String)this.m_graphModel.getProcess().getPrefixForNamespace(ORA_NS))) {
            this.m_graphModel.getProcess().addNamespace(ORA_NS, ORA);
        }
        if (!Helper.hasValue((String)this.m_graphModel.getProcess().getPrefixForNamespace("http://schemas.xmlsoap.org/ws/2003/03/business-process/"))) {
            this.m_graphModel.getProcess().addNamespace("http://schemas.xmlsoap.org/ws/2003/03/business-process/", "bpws");
        }
        if (this.m_copy == null) {
            this.m_copy = (Copy)BPELParser.createImplementation(Copy.class);
            Element domElem = this.m_activity.getDOMElement();
            if (domElem != null) {
                this.m_copy.createDOMElement(domElem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            }
            from = (From)BPELParser.createImplementation(From.class);
            to = (To)BPELParser.createImplementation(To.class);
            this.m_activity.addCopyRule(this.m_copy);
            this.m_copy.setFrom(from);
            this.m_copy.setTo(to);
        } else {
            from = this.m_copy.getFrom();
            to = this.m_copy.getTo();
        }
        URL mapper = this.getMapperNameInURL();
        URL bpelDirURL = this.m_graphPane.getBPELProject().getBPELDirectoryURL();
        String mapperFile = URLFileSystem.toRelativeSpec((URL)mapper, (URL)bpelDirURL);
        Vector source = null;
        String srcVar = null;
        String srcPart = null;
        if (data.size() > 0) {
            source = (Vector)data.get(0);
            srcVar = (String)source.get(0);
            if (source.size() > 1) {
                srcPart = (String)source.get(1);
            }
        }
        String str = null;
        if (data.size() == 1) {
            String fmtStr;
            Object[] obj;
            if (srcPart != null) {
                obj = new Object[]{mapperFile, srcVar, srcPart};
                fmtStr = OLD_EXPRESSION_FORMAT_1;
            } else {
                obj = new Object[]{mapperFile, srcVar};
                fmtStr = OLD_EXPRESSION_FORMAT_2;
            }
            str = MessageFormat.format(fmtStr, obj);
        } else if (data.size() > 1) {
            String fmtStr;
            Object[] obj;
            String params = "";
            for (int i = data.size() - 1; i > 0; --i) {
                Vector v = (Vector)data.get(i);
                srcVar = (String)v.get(0);
                if (source.size() > 1) {
                    srcPart = (String)v.get(1);
                }
                if (srcPart != null) {
                    obj = new Object[]{srcVar + "." + srcPart, srcVar, srcPart, params};
                    fmtStr = PARAMS_FORMAT_1;
                } else {
                    obj = new Object[]{srcVar, srcVar, params};
                    fmtStr = PARAMS_FORMAT_2;
                }
                params = MessageFormat.format(fmtStr, obj);
            }
            srcVar = (String)source.get(0);
            if (source.size() > 1) {
                srcPart = (String)source.get(1);
            }
            if (srcPart != null) {
                obj = new Object[]{mapperFile, srcVar, srcPart, params};
                fmtStr = EXPRESSION_FORMAT_3;
            } else {
                obj = new Object[]{mapper.toExternalForm(), srcVar, params};
                fmtStr = EXPRESSION_FORMAT_4;
            }
            str = MessageFormat.format(fmtStr, obj);
            from.setExpression(str);
        }
        from.setExpression(str);
        to.setVariable(this.getSelectedVariable(this.m_targetVarCombo));
        to.setPart(this.getSelectedPart(this.m_targetPartList));
        if (!this.m_bCreatingMapper) {
            if (!this.mapperFileExist(this.getMapperNameInURL())) {
                this.createNewMapperFile(false);
            }
        } else {
            this.m_bCreatingMapper = false;
        }
        this.fireProcessChangedEvent(28);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void enableUserInput(boolean bEnable) {
        TransformationEditPage transformationEditPage = this;
        synchronized (transformationEditPage) {
            if (bEnable) {
                if (--this.m_counter == 0) {
                    super.enableUserInput(bEnable);
                }
            } else if (++this.m_counter == 1) {
                super.enableUserInput(bEnable);
            }
        }
    }

    protected boolean mapperFileExist(URL url) {
        if (url == null) {
            return false;
        }
        try {
            InputStream is = url.openStream();
            is.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected String getNewMapperFileName() {
        String fileName;
        URL bpelDirURL = this.m_graphPane.getBPELProject().getBPELDirectoryURL();
        String bpelPath = bpelDirURL.getFile();
        String initName = "xsl/Transformation_";
        int counter = 1;
        do {
            if (!new File(bpelPath, (fileName = initName + counter) + DOT_MAPPER_EXTENSION).exists()) continue;
            fileName = null;
            ++counter;
        } while (fileName == null);
        return fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MapperInfo validateMapperInfo() {
        String targetNS;
        String targetElement;
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        BPELProject project = mainModel.getBPELProject();
        WSDLModel wsdlModel = mainModel.getWSDLModel();
        if (!Helper.hasValue((String)this.m_mapperFile.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_NO_MAPPER_FILE"));
            return null;
        }
        URL bpelDirURL = project.getBPELDirectoryURL();
        if (bpelDirURL == null) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_NO_ACT_PRJ"));
            return null;
        }
        URL url = this.getMapperNameInURL();
        MapperInfo info = new MapperInfo();
        info.m_mapperURL = url;
        List<Object> list = null;
        try {
            list = wsdlModel.getImports();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PartItem fromItem = null;
        QName qSrcPartName = null;
        boolean bSourceIsElement = true;
        this.m_srcSelections = this.m_tableModel.getData();
        for (int i = 0; i < this.m_srcSelections.size(); ++i) {
            List<URI> uriList;
            String sourceNS;
            String sourceElement;
            MapperSelectionInfo srcSel = new MapperSelectionInfo();
            Vector v = (Vector)this.m_srcSelections.get(i);
            String var = (String)v.get(0);
            String part = null;
            if (v.size() > 1) {
                part = (String)v.get(1);
            }
            srcSel.m_srcVarName = var;
            srcSel.m_srcPartName = part;
            srcSel.m_paramName = TransformationEditPage.buildParamName(var, part);
            VariableListItem varItem = this.getVariableItem(var, this.m_srcVarCombo);
            if (varItem == null || varItem.getVariable() == null) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_SRC_VAR_INVALID"));
                return null;
            }
            JList jlist = new JList(new DefaultListModel());
            this.loadPart(varItem, jlist, part);
            fromItem = this.getSelectedPartItem(jlist);
            if (fromItem == null) {
                ListModel model = jlist.getModel();
                if (model != null && model.getSize() != 0) {
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_NO_SRC_PART_SEL"));
                    return null;
                }
                QName qName = varItem.getVariable().getElement();
                if (qName == null) {
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_SRV_VAR_SIMPLE_TYPE"));
                    return null;
                }
                sourceElement = qName.getLocalPart();
                sourceNS = qName.getNamespaceURI();
            } else {
                sourceElement = fromItem.getPartType();
                sourceNS = fromItem.getNamespaceURI();
                if (fromItem.getPartXSDType() == 2) {
                    qSrcPartName = new QName(fromItem.getPart());
                    bSourceIsElement = false;
                }
            }
            if (sourceNS != null && "http://www.w3.org/2001/XMLSchema".equals(sourceNS)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_SRV_VAR_SIMPLE_TYPE"));
                return null;
            }
            srcSel.m_srcQName = new QName(sourceNS, sourceElement);
            srcSel.m_srcPartQName = qSrcPartName;
            URI sourceURI = this.getURIFromNamespace(list, sourceNS, sourceElement, bSourceIsElement);
            if (sourceURI == null && (sourceURI = this.getURIFromNamespaceInPLWSDL(sourceNS, sourceElement, bSourceIsElement)) == null && (uriList = wsdlModel.getURIForNamespaceURI(sourceNS)) != null && uriList.size() > 0) {
                sourceURI = this.resolveElement(uriList, sourceElement, sourceNS, bSourceIsElement);
            }
            try {
                srcSel.m_sourceURL = sourceURI.toURL();
                srcSel.m_bSourceXSD = ContentUtil.isXSDDocument((URL)srcSel.m_sourceURL);
            }
            catch (Exception ex) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_UNVL_SRC_SCHEMA"));
                ex.printStackTrace();
                return null;
            }
            info.m_mapperInfos.add(srcSel);
        }
        PartItem toItem = this.getSelectedPartItem(this.m_targetPartList);
        QName qTarPartName = null;
        boolean bTargetIsElement = true;
        if (toItem == null) {
            ListModel model = this.m_targetPartList.getModel();
            if (model != null && model.getSize() != 0) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_NO_TAR_PART_SEL"));
                return null;
            }
            VariableListItem varItem = (VariableListItem)this.m_targetVarCombo.getSelectedItem();
            QName qName = varItem.getVariable().getElement();
            if (qName == null) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_TAR_VAR_INVALID"));
                return null;
            }
            targetElement = qName.getLocalPart();
            targetNS = qName.getNamespaceURI();
        } else {
            targetElement = toItem.getPartType();
            targetNS = toItem.getNamespaceURI();
            if (toItem.getPartXSDType() == 2) {
                qTarPartName = new QName(toItem.getPart());
                bTargetIsElement = false;
            }
        }
        if (targetNS != null && "http://www.w3.org/2001/XMLSchema".equals(targetNS)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_TAR_VAR_SIMPLE_TYPE"));
            return null;
        }
        URI targetURI = this.getURIFromNamespace(list, targetNS, targetElement, bTargetIsElement);
        if (targetURI == null && (targetURI = this.getURIFromNamespaceInPLWSDL(targetNS, targetElement, bTargetIsElement)) == null && (list = wsdlModel.getURIForNamespaceURI(targetNS)) != null && list.size() > 0) {
            targetURI = this.resolveElement(list, targetElement, targetNS, bTargetIsElement);
        }
        try {
            info.m_targetURL = targetURI.toURL();
            info.m_bTargetXSD = ContentUtil.isXSDDocument((URL)info.m_targetURL);
        }
        catch (Exception ex) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_TRFM_UNVL_TAR_SCHEMA"));
            ex.printStackTrace();
            return null;
        }
        info.m_tarQName = new QName(targetNS, targetElement);
        info.m_tarPartName = qTarPartName;
        return info;
    }

    protected void checkSourceAndTargetMatched() {
        this.m_srcSelections = this.m_tableModel.getData();
        if (this.m_extistMapperFileName == null || this.m_srcSelections.size() == 0 || this.m_toVarName == null) {
            return;
        }
        final Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
        if (context == null || context.getProject() == null) {
            return;
        }
        QName toVarQName = null;
        VariableListItem varItem = (VariableListItem)this.m_targetVarCombo.getSelectedItem();
        if (varItem != null) {
            toVarQName = this.m_toPartName != null ? varItem.getVariable().getMessageType() : varItem.getVariable().getElement();
        }
        if (this.m_srcSelections.size() == 0 || toVarQName == null) {
            return;
        }
        final QName tQName = toVarQName;
        final URL graphURL = this.m_graphPane.getBPELProject().getBPELFileURL();
        final TransformationEditPage comp = this;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    int ret;
                    MapperInfo mapInfo = TransformationEditPage.this.getMapperInfoFromExistMapper(context, TransformationEditPage.this.m_srcSelections, tQName, TransformationEditPage.this.m_toPartName, graphURL);
                    if (!TransformationEditPage.this.mapperFileExist(mapInfo.m_mapperURL)) {
                        GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)comp), (String)BPELStringTranslator.getString("EDITOR_TRFM_MAPPER_FILE_NOT_EXIST"));
                        return;
                    }
                    if (mapInfo != null && (ret = TransformationEditPage.this.doCheckExistMapper(mapInfo)) != 1) {
                        Runnable rd = new Runnable(){

                            @Override
                            public void run() {
                                String msg = null;
                                if (ret == 2) {
                                    msg = BPELStringTranslator.getString("EDITOR_TRFM_SRC_MISMATCH");
                                } else if (ret == 3) {
                                    msg = BPELStringTranslator.getString("EDITOR_TRFM_TAR_MISMATCH");
                                } else if (ret == 4) {
                                    msg = BPELStringTranslator.getString("EDITOR_TRFM_SRC_TAR_MISMATCH");
                                }
                                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)comp), (String)msg);
                            }
                        };
                        SwingUtilities.invokeLater(rd);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        new Thread(r).start();
    }

    protected WSDLPartData getMessagePart(QName msgQName, String partName, URL graphURL) {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        BPELProject prj = this.m_graphPane.getBPELProject();
        List list = BPELModelerUtil.getWSDLFromNamespaceURI((Process)graphModel.getProcess(), (DeploymentFile)prj.getDeploymentFile(), (String)msgQName.getNamespaceURI());
        if (list == null) {
            return null;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String realNamespace = msgQName.getNamespaceURI();
            WSDLPartData[] parts = null;
            try {
                parts = WSDLUtil.getParts((URI)((URI)it.next()), (String)msgQName.getLocalPart(), (String)realNamespace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (parts == null) continue;
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].getPartName().equals(partName)) continue;
                return parts[i];
            }
        }
        return null;
    }

    protected MapperInfo getMapperInfoFromExistMapper(Context context, Vector srcSels, QName toVarQName, String toPartName, URL graphURL) {
        WSDLModel wsdlModel = this.m_graphPane.getBPELXmlModel().getWSDLModel();
        MapperInfo info = new MapperInfo();
        try {
            info.m_mapperURL = new URL(this.m_extistMapperFileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        List<URI> list = WSDLUtil.getImports((Definition)this.m_graphModel.getBPELProject().getWSDLFileDefinition());
        String sourceElement = null;
        String sourceNS = null;
        QName qSrcPartName = null;
        boolean bSourceIsElement = true;
        this.m_srcSelections = this.m_tableModel.getData();
        for (int i = 0; i < this.m_srcSelections.size(); ++i) {
            MapperSelectionInfo srcSel = new MapperSelectionInfo();
            Vector v = (Vector)this.m_srcSelections.get(i);
            String var = (String)v.get(0);
            String fromPartName = null;
            if (v.size() > 1) {
                fromPartName = (String)v.get(1);
            }
            srcSel.m_srcVarName = var;
            srcSel.m_srcPartName = fromPartName;
            srcSel.m_paramName = TransformationEditPage.buildParamName(var, fromPartName);
            VariableListItem varItem = this.getVariableItem(var, this.m_srcVarCombo);
            JList jlist = new JList(new DefaultListModel());
            this.loadPart(varItem, jlist, fromPartName);
            QName fromVarQName = null;
            if (varItem != null) {
                fromVarQName = fromPartName != null ? varItem.getVariable().getMessageType() : varItem.getVariable().getElement();
            }
            if (fromPartName == null) {
                sourceElement = fromVarQName.getLocalPart();
                sourceNS = fromVarQName.getNamespaceURI();
            } else {
                WSDLPartData sourcePart = this.getMessagePart(fromVarQName, fromPartName, graphURL);
                if (sourcePart != null) {
                    sourceElement = sourcePart.getPartType();
                    sourceNS = sourcePart.getTargetNamespace();
                    if (sourcePart.getPartXSDType() == 2) {
                        bSourceIsElement = false;
                        qSrcPartName = new QName(sourcePart.getPartName());
                    }
                }
            }
            URI sourceURI = this.getURIFromNamespace(list, sourceNS, sourceElement, bSourceIsElement);
            if (sourceURI == null && (sourceURI = this.getURIFromNamespaceInPLWSDL(sourceNS, sourceElement, bSourceIsElement)) == null && (list = wsdlModel.getURIForNamespaceURI(sourceNS)) != null && list.size() > 0) {
                sourceURI = this.resolveElement(list, sourceElement, sourceNS, bSourceIsElement);
            }
            try {
                srcSel.m_sourceURL = sourceURI.toURL();
                srcSel.m_bSourceXSD = ContentUtil.isXSDDocument((URL)srcSel.m_sourceURL);
            }
            catch (Exception ex) {
                return null;
            }
            srcSel.m_srcQName = new QName(sourceNS, sourceElement);
            srcSel.m_srcPartQName = qSrcPartName;
            info.m_mapperInfos.add(srcSel);
        }
        String targetElement = null;
        String targetNS = null;
        QName qTarPartName = null;
        boolean bTargetIsElement = true;
        if (toPartName == null) {
            targetElement = toVarQName.getLocalPart();
            targetNS = toVarQName.getNamespaceURI();
        } else {
            WSDLPartData tarPart = this.getMessagePart(toVarQName, toPartName, graphURL);
            if (tarPart != null) {
                targetElement = tarPart.getPartType();
                targetNS = tarPart.getTargetNamespace();
                if (tarPart.getPartXSDType() == 2) {
                    bTargetIsElement = false;
                    qTarPartName = new QName(tarPart.getPartName());
                }
            }
        }
        URI targetURI = this.getURIFromNamespace(list, targetNS, targetElement, bTargetIsElement);
        if (targetURI == null && (targetURI = this.getURIFromNamespaceInPLWSDL(targetNS, targetElement, bTargetIsElement)) == null && (list = wsdlModel.getURIForNamespaceURI(targetNS)) != null && list.size() > 0) {
            targetURI = this.resolveElement(list, targetElement, targetNS, bTargetIsElement);
        }
        try {
            info.m_targetURL = targetURI.toURL();
            info.m_bTargetXSD = ContentUtil.isXSDDocument((URL)info.m_targetURL);
        }
        catch (Exception ex) {
            return null;
        }
        info.m_tarQName = new QName(targetNS, targetElement);
        info.m_tarPartName = qTarPartName;
        return info;
    }

    private int doCheckExistMapper(MapperInfo info) throws Exception {
        List sels = info.m_mapperInfos;
        ArrayList<MapperSource> mapperSources = new ArrayList<MapperSource>(sels.size());
        for (int i = 0; i < sels.size(); ++i) {
            MapperSelectionInfo sel = (MapperSelectionInfo)sels.get(i);
            if (i == 0) {
                if (sel.m_srcPartQName != null) {
                    mapperSources.add(new MapperSource(sel.m_bSourceXSD ? 1 : 2, sel.m_sourceURL, sel.m_srcPartQName, sel.m_srcQName));
                    continue;
                }
                mapperSources.add(new MapperSource(sel.m_bSourceXSD ? 1 : 2, sel.m_sourceURL, sel.m_srcQName));
                continue;
            }
            QName paraName = new QName(sel.m_paramName);
            if (sel.m_srcPartQName != null) {
                mapperSources.add(new MapperSource(sel.m_bSourceXSD ? 1 : 2, sel.m_sourceURL, sel.m_srcPartQName, sel.m_srcQName, paraName));
                continue;
            }
            mapperSources.add(new MapperSource(sel.m_bSourceXSD ? 1 : 2, sel.m_sourceURL, sel.m_srcQName, null, paraName));
        }
        ArrayList<MapperTarget> mapperTargets = new ArrayList<MapperTarget>(1);
        if (info.m_tarPartName != null) {
            mapperTargets.add(new MapperTarget(info.m_bTargetXSD ? 1 : 2, info.m_targetURL, info.m_tarPartName, info.m_tarQName));
        } else {
            mapperTargets.add(new MapperTarget(info.m_bTargetXSD ? 1 : 2, info.m_targetURL, info.m_tarQName));
        }
        return AddinUtil.matchSourceTarget((URL)info.m_mapperURL, mapperSources, mapperTargets);
    }

    public static String buildParamName(String varName, String partName) {
        if (partName == null) {
            return varName;
        }
        return varName + "." + partName;
    }

    public static String[] parseSource(String var) throws ParseException {
        var = var.trim();
        String[] ret = new String[3];
        String rest = "";
        if (var.startsWith("$")) {
            ret[0] = var.substring(1, var.indexOf(44)).trim();
            ret[2] = rest = var.substring(var.indexOf(44) + 1).trim();
        } else {
            MessageFormat fmt = new MessageFormat(PARSING_FORMAT_VAR);
            Object[] varObj = fmt.parse(var);
            rest = (String)varObj[1];
            ret[2] = rest = rest.trim().substring(1).trim();
            String vars = (String)varObj[0];
            if ((vars = vars.trim()).indexOf(44) > 0) {
                String s = vars.substring(0, vars.indexOf(44)).trim();
                ret[0] = s = s.substring(1, s.length() - 1);
                s = vars.substring(vars.indexOf(44) + 1).trim();
                ret[1] = s = s.substring(1, s.length() - 1);
            } else {
                ret[0] = vars.trim().substring(1, vars.length() - 1);
            }
        }
        return ret;
    }

    protected PartItem getPartItem(VariableListItem varItem, String part) {
        Vector<PartItem> model = new Vector<PartItem>();
        if (varItem == null) {
            return null;
        }
        QName msgQName = varItem.getVariable().getMessageType();
        if (msgQName == null) {
            return null;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        BPELProject prj = this.getBPELProject();
        List list = BPELModelerUtil.getWSDLFromNamespaceURI((Process)graphModel.getProcess(), (DeploymentFile)prj.getDeploymentFile(), (String)msgQName.getNamespaceURI());
        if (list == null) {
            return null;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String realNamespace = msgQName.getNamespaceURI();
            WSDLPartData[] parts = null;
            try {
                parts = WSDLUtil.getParts((URI)((URI)it.next()), (String)msgQName.getLocalPart(), (String)realNamespace);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (parts == null) continue;
            for (int i = 0; i < parts.length; ++i) {
                model.addElement(new PartItem(parts[i].getPartName(), parts[i].getTargetNamespace(), parts[i].getPartType(), parts[i].getPartXSDType()));
            }
        }
        if (part != null) {
            int sz = model.size();
            for (int i = 0; i < sz; ++i) {
                PartItem item;
                Object obj = model.get(i);
                if (!(obj instanceof PartItem) || !(item = (PartItem)obj).getName().equals(part)) continue;
                return item;
            }
        }
        return null;
    }

    protected VariableListItem getVariableItem(String varName, JComboBox cb) {
        if (varName == null) {
            return null;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            VariableListItem item;
            Variable v;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof VariableListItem) || !(v = (item = (VariableListItem)obj).getVariable()).getName().equalsIgnoreCase(varName)) continue;
            cb.setSelectedItem(item);
            return item;
        }
        return null;
    }

    public URL getMapperNameInURL() {
        String temp = this.m_mapperFile.getText().trim();
        if (!temp.endsWith(DOT_MAPPER_EXTENSION)) {
            temp = temp + DOT_MAPPER_EXTENSION;
        }
        URL url = null;
        try {
            url = new URL(temp);
        }
        catch (Exception ex) {
            URL bpelDirURL = this.m_graphPane.getBPELProject().getBPELDirectoryURL();
            url = URLFactory.newURL((URL)bpelDirURL, (String)temp);
        }
        return url;
    }

    private class MapperSelectionInfo {
        public QName m_srcQName;
        public boolean m_bSourceXSD;
        public QName m_srcPartQName;
        public URL m_sourceURL;
        public String m_srcVarName;
        public String m_srcPartName;
        public String m_paramName;

        private MapperSelectionInfo() {
        }
    }

    private class MapperInfo {
        public List m_mapperInfos = new ArrayList();
        public QName m_tarQName;
        public boolean m_bTargetXSD;
        public QName m_tarPartName;
        public URL m_targetURL;
        public URL m_mapperURL;

        private MapperInfo() {
        }
    }

    class SourceVariableItemListener
    implements ItemListener {
        private BPELBaseDialog m_dlg = null;

        public SourceVariableItemListener(BPELBaseDialog dlg) {
            this.m_dlg = dlg;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                TransformationEditPage.this.asyncLoadPart((VariableListItem)TransformationEditPage.this.getSelectedComboBoxValue(TransformationEditPage.this.m_srcVarCombo), TransformationEditPage.this.m_srcPart, null, this.m_dlg);
            }
        }
    }

    class TargetVariableItemListener
    implements ItemListener {
        TargetVariableItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                TransformationEditPage.this.asyncLoadPart((VariableListItem)TransformationEditPage.this.getSelectedComboBoxValue(TransformationEditPage.this.m_targetVarCombo), TransformationEditPage.this.m_targetPartList, null, null);
            }
        }
    }
}

