/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Fault;
import javax.xml.namespace.QName;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Throw;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VarNameCreationManager;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableAutoCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault.FaultChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ThrowGenEditPage
extends BaseEditingPage
implements ActionListener,
DocumentListener {
    protected JTextField m_nameField;
    protected JTextField m_faultVar;
    protected JButton m_faultNameBrowseBtn;
    protected JButton m_faultVarCreateBtn;
    protected JButton m_faultVarBrowseBtn;
    protected JTextField m_faultNamespaceURIField;
    protected JTextField m_faultLocalPartField;
    protected JButton m_wsdlFaultBrowseBtn;
    protected Variable m_addedFaultVar;
    protected QName m_faultQName;
    private Throw m_activity;

    public ThrowGenEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_faultNameBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("EDITOR_TRW_BRW_FAULT_NAMES"));
        this.m_faultNameBrowseBtn.setEnabled(false);
        this.m_faultNameBrowseBtn.addActionListener(this);
        this.m_faultVar = new JTextField();
        this.m_faultVarBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("EDITOR_TRW_BRW_FAULT_VARS"));
        this.m_faultVarBrowseBtn.addActionListener(this);
        this.m_faultNamespaceURIField = new JTextField();
        this.m_faultNamespaceURIField.getDocument().addDocumentListener(this);
        this.m_faultLocalPartField = new JTextField();
        this.m_faultLocalPartField.getDocument().addDocumentListener(this);
        this.m_wsdlFaultBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("BROWSE_FAULTS"));
        this.m_wsdlFaultBrowseBtn.addActionListener(this);
        this.m_faultVarCreateBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_faultVarCreateBtn.setToolTipText(BPELStringTranslator.getString("AUTO_CREATE_FAULT_VAR"));
        this.m_faultVarCreateBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel faultVarLbl = new JLabel();
        BPELStringTranslator.setLabel(faultVarLbl, this.m_faultVar, BPELStringTranslator.getString("EDITOR_TRW_FAULT_VAR"));
        ToolBar faultNameBrowseTB = new ToolBar();
        faultNameBrowseTB.add((Component)this.m_faultNameBrowseBtn);
        ToolBar faultVarBrowseTB = new ToolBar();
        faultVarBrowseTB.add((Component)this.m_faultVarCreateBtn);
        faultVarBrowseTB.add((Component)this.m_faultVarBrowseBtn);
        JPanel namePnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)namePnl, (Component)nameLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)namePnl, (Component)this.m_nameField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)namePnl, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.createFaultNamePanel(), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel lblVar = new JLabel();
        BPELStringTranslator.setLabel(lblVar, this.m_faultVar, BPELStringTranslator.getString("EDITOR_CGE_FAULT_VAR"));
        GraphUtils.addComponent((Container)this, (Component)lblVar, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_faultVar, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)faultVarBrowseTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(2, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected JPanel createFaultNamePanel() {
        ToolBar tb3 = new ToolBar();
        tb3.add((Component)this.m_wsdlFaultBrowseBtn);
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_CGE_FAULT_QNAME")));
        int row = 0;
        JLabel lblNS = new JLabel();
        BPELStringTranslator.setLabel(lblNS, this.m_faultNamespaceURIField, BPELStringTranslator.getString("EDITOR_CGE_FAULT_NS"));
        GraphUtils.addComponent((Container)p, (Component)tb3, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)lblNS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_faultNamespaceURIField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel lblLP = new JLabel();
        BPELStringTranslator.setLabel(lblLP, this.m_faultLocalPartField, BPELStringTranslator.getString("EDITOR_CGE_FAULT_LP"));
        GraphUtils.addComponent((Container)p, (Component)lblLP, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_faultLocalPartField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Throw)model;
        this.loadControls();
    }

    protected void loadControls() {
        if (this.m_activity == null) {
            return;
        }
        this.m_faultVarCreateBtn.setEnabled(false);
        QName qName = this.m_activity.getFaultName();
        if (qName != null) {
            String ns = qName.getNamespaceURI();
            if (ns != null) {
                this.m_faultNamespaceURIField.setText(ns);
            } else {
                ns = this.m_processModel.getNamespaceForPrefix(qName.getPrefix());
                if (ns != null) {
                    this.m_faultNamespaceURIField.setText(ns);
                } else {
                    this.m_faultNamespaceURIField.setText(this.m_graphModel.getProcess().getTargetNamespace());
                }
            }
            this.m_faultLocalPartField.setText(qName.getLocalPart());
        }
        if (this.m_activity.getName() != null) {
            this.m_nameField.setText(this.m_activity.getName());
        }
        if (this.m_activity.getFaultVariable() != null) {
            this.m_faultVar.setText(this.m_activity.getFaultVariable());
        }
    }

    protected void handleInputVariableBrowse() {
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_activity);
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_faultVar.setText(v.getName());
            } else {
                this.m_faultVar.setText("");
            }
        }
    }

    protected void handleFaultName() {
    }

    @Override
    public boolean validateEditorChanges() {
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)0);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        String ns = this.m_faultNamespaceURIField.getText();
        String prefix = this.m_processModel.addNamespace(ns);
        QName qName = new QName(ns, this.m_faultLocalPartField.getText(), prefix);
        this.m_activity.setFaultName(qName);
        this.m_activity.setName(this.m_nameField.getText());
        String strFaultVar = this.m_faultVar.getText();
        if (strFaultVar != null) {
            this.m_activity.setFaultVariable(strFaultVar.trim());
            if (this.m_addedFaultVar != null && "http://schemas.oracle.com/bpel/extension".equals(this.m_addedFaultVar.getMessageType().getNamespaceURI())) {
                this.checkRuntimeFaultWSDL();
            }
        }
        this.fireProcessChangedEvent(28);
    }

    protected void handleFaultBrowse() {
        Fault f;
        FaultChooser chooser = new FaultChooser(GraphUtils.getFrame((Component)this), this.m_graphPane);
        if (chooser.display() == 0 && (f = chooser.getFault()) != null) {
            String nsURI = chooser.getFaultNamespace();
            this.m_faultNamespaceURIField.setText(nsURI);
            this.m_faultLocalPartField.setText(f.getName());
            if (f.getMessage() != null) {
                this.m_faultQName = f.getMessage().getQName();
                this.m_faultVarCreateBtn.setEnabled(true);
            } else if ("http://schemas.oracle.com/bpel/extension".equals(nsURI)) {
                this.m_faultQName = new QName(nsURI, "RuntimeFaultMessage");
                this.m_faultVarCreateBtn.setEnabled(true);
            }
        }
    }

    protected void handleCreateFaultVar() {
        VariableAutoCreationDialog dlg;
        if (this.m_faultQName == null) {
            return;
        }
        BPELGraphModel model = (BPELGraphModel)this.m_graphPane.getModel();
        String varName = VarNameCreationManager.getInstance().getFautlVariableName(model.getProcess(), (Activity)this.m_activity, "FaultVar");
        String name = BPELModelUtil.getUniqueVariableName((Process)model.getProcess(), (String)varName);
        String prefix = model.getProcess().addNamespace(this.m_faultQName.getNamespaceURI());
        Variable var = (Variable)BPELParser.createImplementation(Variable.class);
        var.setMessageType(new QName(this.m_faultQName.getNamespaceURI(), this.m_faultQName.getLocalPart(), prefix));
        boolean hasScope = false;
        List scopes = BPELModelUtil.getParentScopes((Activity)this.m_activity);
        if (scopes != null && scopes.size() > 0) {
            hasScope = true;
        }
        if ((dlg = new VariableAutoCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_activity, name, var.getMessageType().toString(), hasScope)).display() == 0) {
            this.m_faultVar.setText(dlg.getVariableName());
            var.setName(dlg.getVariableName());
            if (dlg.isGlobal()) {
                this.m_processModel.addVariable(var);
            } else if (scopes != null && scopes.size() > 0) {
                Scope scope = (Scope)scopes.get(0);
                scope.addVariable(var);
            } else {
                this.m_processModel.addVariable(var);
            }
            this.m_addedFaultVar = var;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_faultVarBrowseBtn) {
            this.handleInputVariableBrowse();
        } else if (src == this.m_faultNameBrowseBtn) {
            this.handleFaultName();
        } else if (src == this.m_wsdlFaultBrowseBtn) {
            this.handleFaultBrowse();
        } else if (src == this.m_faultVarCreateBtn) {
            this.handleCreateFaultVar();
        }
    }

    protected void enableCreateVarButton() {
        this.m_faultVarCreateBtn.setEnabled(false);
    }

    protected void checkRuntimeFaultWSDL() {
        ClassLoader classLoader;
        URL resource;
        URL faultWSDL = URLFactory.newURL((URL)this.m_graphPane.getBPELProject().getBPELDirectoryURL(), (String)"RuntimeFault.wsdl");
        if (!URLFileSystem.exists((URL)faultWSDL) && (resource = (classLoader = Thread.currentThread().getContextClassLoader()).getResource("oracle/tip/tools/ide/pm/resources/documents/RuntimeFault.wsdl")) != null) {
            try {
                URLFileSystem.copy((InputStream)resource.openStream(), (URL)faultWSDL);
                WSDLUtil.addImportToWSDL((BPELProject)this.m_graphPane.getBPELProject(), (URL)faultWSDL, (String)"http://schemas.oracle.com/bpel/extension");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.enableCreateVarButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.enableCreateVarButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.enableCreateVarButton();
    }
}

