/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.BpelNSResolver;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.utils.MapUtils;
import oracle.tip.tools.ide.common.xsdgrammar.GrammarInfo;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.TaskTypeWizardContext;
import oracle.tip.tools.ide.pm.modules.notification.NotificationWizardContext;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskVariableDataCallBackImpl
extends VariableDataCallBackImpl {
    protected Variable m_variable;
    protected Document m_doc;
    protected TaskTypeWizardContext m_taskTypeWizardContext;
    protected NotificationWizardContext m_notificationWizardContext;
    protected Variable m_taskNotificationVariable;
    protected QName m_taskNotificationVariableQName;
    private String variableName = null;
    private String partName = null;
    private String query = null;
    private static final String TASK_NOTIFICATION_XSD = "oracle/tip/pc/services/wsdl/xsd/TaskNotification.xsd";

    public TaskVariableDataCallBackImpl(BPELXmlModel m, Activity curActivity, Variable var, Document doc) {
        super(m, curActivity);
        this.m_variable = var;
        this.m_doc = doc;
    }

    public TaskVariableDataCallBackImpl(BPELXmlModel m, TaskTypeWizardContext taskTypeWizardContext, Activity curActivity, Variable var, Document doc) {
        super(m, curActivity);
        this.m_variable = var;
        this.m_taskTypeWizardContext = taskTypeWizardContext;
        this.m_doc = doc;
    }

    public TaskVariableDataCallBackImpl(BPELXmlModel m, NotificationWizardContext notificationWizardContext, Activity curActivity, Variable var, Document doc) {
        super(m, curActivity);
        this.m_variable = var;
        this.m_notificationWizardContext = notificationWizardContext;
        this.m_taskTypeWizardContext = notificationWizardContext._ttWContext;
        this.m_doc = doc;
        this.m_taskNotificationVariable = (Variable)BPELParser.createImplementation(Variable.class);
        this.m_taskNotificationVariableQName = new QName("http://xmlns.oracle.com/pcbpel/taskservice/taskNotification", "taskNotification", "taskNotification");
        this.m_taskNotificationVariable.setName("TaskNotification");
        this.m_taskNotificationVariable.setElement(this.m_taskNotificationVariableQName);
    }

    @Override
    public List getVariableNames() {
        ArrayList<String> list = null;
        if (this.m_taskNotificationVariable != null) {
            super.getVariableNames();
            list = new ArrayList<String>();
            this.m_varList.add(this.m_variable);
            list.add(this.m_variable.getName());
            this.m_varList.add(this.m_taskNotificationVariable);
            list.add(this.m_taskNotificationVariable.getName());
        } else {
            list = super.getVariableNames();
            this.m_varList.add(this.m_variable);
            list.add(this.m_variable.getName());
        }
        return list;
    }

    @Override
    public List getParts(String varName) {
        if (varName != null && varName.equals(this.m_variable.getName())) {
            return null;
        }
        return super.getParts(varName);
    }

    @Override
    public List getProperties(String varName) {
        return null;
    }

    @Override
    public Document getDocument(String variableName) {
        Variable selVar = this.getSelectedVar(variableName);
        if (selVar == null) {
            return null;
        }
        QName qname = selVar.getElement();
        if (qname == null) {
            qname = selVar.getType();
        }
        if (qname == null) {
            return null;
        }
        QName varQName = this.m_variable.getElement();
        if (varQName != null && qname.equals(varQName)) {
            Document doc = null;
            try {
                InputStream ipXsdFile = TaskVariableDataCallBackImpl.getClassLoader().getResource("oracle/tip/pc/services/wsdl/WorkflowTask.xsd").openStream();
                DOMParser parser = new DOMParser();
                parser.parse(ipXsdFile);
                XMLDocument xsdDoc = parser.getDocument();
                GrammarInfo grammInfo = new GrammarInfo(null, xsdDoc.getDocumentElement());
                grammInfo.setNSResolver((MapperNSResolver)new BpelNSResolver(this.m_processModel));
                doc = grammInfo.buildDocument(varQName);
                if (variableName.equals(this.m_variable.getName())) {
                    Element payloadElem = this.getPayloadElement();
                    this.appendPayloadElement(doc, payloadElem);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return doc;
        }
        if (this.m_taskNotificationVariableQName != null && this.m_taskNotificationVariableQName.equals(qname)) {
            Document doc = null;
            try {
                InputStream ipXsdFile = TaskVariableDataCallBackImpl.getClassLoader().getResource(TASK_NOTIFICATION_XSD).openStream();
                DOMParser parser = new DOMParser();
                parser.parse(ipXsdFile);
                XMLDocument xsdDoc = parser.getDocument();
                GrammarInfo grammInfo = new GrammarInfo(null, xsdDoc.getDocumentElement());
                grammInfo.setNSResolver((MapperNSResolver)new BpelNSResolver(this.m_processModel));
                doc = grammInfo.buildDocument(this.m_taskNotificationVariableQName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return doc;
        }
        return this.createDocument(qname.getNamespaceURI(), qname.getLocalPart(), null);
    }

    public static ClassLoader getClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        return classLoader;
    }

    private void appendPayloadElement(Document doc, Element payloadElem) {
        if (payloadElem == null) {
            return;
        }
        NodeList payloads = doc.getElementsByTagName("payload");
        Element taskPayloadElem = null;
        for (int i = 0; i < payloads.getLength(); ++i) {
            Element elem;
            Attr namespaceAttr;
            Node node = payloads.item(i);
            if (!(node instanceof Element) || !"http://xmlns.oracle.com/pcbpel/taskservice/task".equals((namespaceAttr = (elem = (Element)node).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "namespace")).getValue())) continue;
            taskPayloadElem = elem;
            break;
        }
        if (taskPayloadElem == null) {
            return;
        }
        NodeList nl = payloadElem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Node newNode = doc.importNode(n, true);
            taskPayloadElem.appendChild(newNode);
        }
    }

    private boolean initPayload() {
        this.getVariableNames();
        if (this.m_taskTypeWizardContext == null) {
            return false;
        }
        String[] payloadPath = this.m_taskTypeWizardContext.getTaskPayloadPath();
        if (payloadPath == null || payloadPath.length == 0) {
            return false;
        }
        this.variableName = payloadPath[0];
        this.partName = null;
        this.query = null;
        Variable payloadVariable = null;
        for (int i = 0; i < this.m_varList.size() && payloadVariable == null; ++i) {
            Variable variable = (Variable)this.m_varList.get(i);
            if (!variable.getName().equals(this.variableName)) continue;
            payloadVariable = variable;
        }
        if (payloadVariable == null) {
            return false;
        }
        if (payloadVariable.getMessageType() != null) {
            if (payloadPath.length > 1) {
                this.partName = payloadPath[1];
            }
            if (payloadPath.length > 2) {
                this.query = this.removePredicatesFromXPath(payloadPath[2]);
            }
        } else if (payloadVariable.getElement() != null && payloadPath.length > 1) {
            this.query = this.removePredicatesFromXPath(payloadPath[1]);
        }
        return true;
    }

    private String removePredicatesFromXPath(String xpath) {
        if (xpath == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(xpath, "/", false);
        while (st.hasMoreElements()) {
            String xpathSub = (String)st.nextElement();
            int index = xpathSub.indexOf(91);
            if (index > 0) {
                xpathSub = xpathSub.substring(0, index);
            }
            result.append('/');
            result.append(xpathSub);
        }
        return new String(result);
    }

    public Element getPayloadElement() {
        if (!this.initPayload()) {
            return null;
        }
        try {
            Document document;
            Part payloadPart = null;
            if (this.partName != null) {
                List parts = this.getParts(this.variableName);
                for (int i = 0; i < parts.size() && payloadPart == null; ++i) {
                    Part part = (Part)parts.get(i);
                    String pName = part.getName();
                    if (!this.partName.equals(pName)) continue;
                    payloadPart = part;
                }
                if (payloadPart == null) {
                    return null;
                }
            }
            if ((document = payloadPart == null ? this.getDocument(this.variableName) : (payloadPart.getElementName() != null ? this.getDocument(payloadPart.getElementName()) : this.getDocument(payloadPart.getName(), payloadPart.getTypeName()))) == null) {
                return null;
            }
            if (this.query == null) {
                return (Element)document.getDocumentElement().getFirstChild();
            }
            this.query = "/schema" + this.query;
            return MapUtils.getElementByXPath((Document)document, (String)this.query);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String printElement(String context, Element element) {
        try {
            if (element instanceof XMLElement) {
                StringWriter sw = new StringWriter();
                ((XMLElement)element).print((Writer)sw);
                return sw.toString();
            }
            return element.toString();
        }
        catch (Exception e) {
            return element.toString();
        }
    }

    private String printDocument(String context, Document document) {
        try {
            if (document instanceof XMLDocument) {
                return this.printElement(context, document.getDocumentElement());
            }
            return document.toString();
        }
        catch (Exception e) {
            return document.toString();
        }
    }
}

