/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.To;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyDialogEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageInputs;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public abstract class TargetOpTypeEditPage
extends CopyDialogEditPage {
    public TargetOpTypeEditPage(BPELGraphPane pane, CopyPageInputs in, Object copyRule, boolean editMode) {
        super(pane, in, copyRule, editMode);
    }

    @Override
    protected void createControls() {
        this.createToControls();
    }

    @Override
    protected void populateToTypeCB() {
        this.m_toTypeCB.addItem(BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_TBL_VAR"));
    }

    @Override
    protected void layoutControls() {
        JPanel p = new JPanel(new GridLayout(1, 1, 5, 5));
        p.add(this.getToPanel());
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)p, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    protected CardPanel createToCardPanel() {
        CardPanel toCardPnl = new CardPanel();
        toCardPnl.add("TO_VARIABLE_PANEL", (Component)this.createToVariablePanel());
        return toCardPnl;
    }

    @Override
    public boolean checkValidInput() {
        return true;
    }

    @Override
    protected void doLoad() {
        try {
            this.m_toXPathBuilderPnl.load(this.m_assignActivity);
        }
        catch (Exception e) {
            e.printStackTrace();
            GraphUtils.displayMessage((Component)this, (String)e.getMessage(), (int)0);
        }
        if (this.m_copyRule != null) {
            this.loadCopyRule();
        } else {
            this.loadPartnerLinks(this.m_toPartnerCB);
        }
    }

    @Override
    public abstract void populateCopyInfo();

    @Override
    protected abstract String loadCopyRule();

    protected void loadBPELExtTo(final To to) {
        if (to.getVariable() == null) {
            return;
        }
        this.m_toTypeCB.setSelectedIndex(0);
        String varName = to.getVariable();
        String partName = to.getPart();
        String query = to.getQuery();
        boolean bSucceeded = false;
        if (varName != null && partName != null) {
            bSucceeded = this.m_toXPathBuilderPnl.selectVariablePart(varName, partName, this.m_assignActivity, to.getQuery());
        }
        if (!bSucceeded && varName != null && query != null) {
            List qnames = this.parseToQNames(query);
            bSucceeded = this.m_toXPathBuilderPnl.selectVariableXPathNode(varName, qnames, this.m_assignActivity);
        }
        if (!bSucceeded && varName != null) {
            this.m_toXPathBuilderPnl.selectVariable(varName, this.m_assignActivity);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TargetOpTypeEditPage.this.m_toXPathBuilderPnl.setXPath(to.getQuery());
            }
        };
        SwingUtilities.invokeLater(r);
    }
}

