/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ScopeGenEditPage
extends BaseEditingPage
implements EditorPage {
    protected JTextField m_nameField;
    protected JCheckBox m_varAccessCheckBox;
    protected Scope m_activity;

    public ScopeGenEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_varAccessCheckBox = new JCheckBox();
        BPELStringTranslator.setButton(this.m_varAccessCheckBox, BPELStringTranslator.getString("EDITOR_SCOPE_GEN_EDIT_VAR_ACCESS"));
    }

    protected void layoutControls() {
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_varAccessCheckBox, (int)1, (int)row++, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void loadControls() {
        if (this.m_activity != null) {
            this.m_nameField.setText(this.m_activity.getName());
            Boolean b = this.m_activity.getVariableAccessSerializable();
            if (b != null) {
                this.m_varAccessCheckBox.setSelected(b);
            }
        }
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Scope)model;
        this.loadControls();
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setName(this.m_nameField.getText());
        if (this.m_activity.getVariableAccessSerializable() != null) {
            this.m_activity.setVariableAccessSerializable(this.m_varAccessCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        } else if (this.m_varAccessCheckBox.isSelected()) {
            this.m_activity.setVariableAccessSerializable(Boolean.TRUE);
        }
        this.fireProcessChangedEvent(28);
    }

    @Override
    public boolean validateEditorChanges() {
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)0);
            return false;
        }
        return true;
    }
}

