/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ui.SectionHeader;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ReplyGenEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.RoleListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableAutoCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLOperationListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLPortTypeListItem;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink.PartnerLinkChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ReplyPartnerLinkPanel
extends JPanel
implements ActionListener {
    protected JTextField m_roleField;
    protected JTextField m_partnerLinkField;
    protected JTextField m_varField;
    protected JComboBox m_portTypeCB;
    protected JComboBox m_operationsCB;
    protected JComboBox m_roleCB;
    protected JButton m_varCreateBtn;
    protected JButton m_varBrowseBtn;
    protected JButton m_partnerLinkBrowseBtn;
    protected JButton m_wsdlFaultBrowseBtn;
    protected String m_partnerLinkName;
    protected PartnerLink m_link;
    protected QName m_portType;
    protected String m_operation;
    protected Reply m_reply;
    protected String m_origPartnerLink;
    protected ReplyGenEditPage m_page;
    protected BPELGraphPane m_graphPane;

    public ReplyPartnerLinkPanel(ReplyGenEditPage pg) {
        this.m_page = pg;
        this.m_graphPane = pg.m_graphPane;
        this.createControls();
        this.layoutControls();
    }

    public void setPartnerLinkConnectionMode(String link) {
        this.m_partnerLinkName = link;
        this.m_partnerLinkField.setText(link);
        this.m_partnerLinkField.setEnabled(false);
        this.m_partnerLinkBrowseBtn.setEnabled(false);
    }

    public void saveChanges() {
        boolean bLinkChanged;
        WSDLPortTypeListItem item;
        PortType ptype;
        if (this.m_reply == null) {
            return;
        }
        this.m_reply.setVariable(this.m_varField.getText());
        this.m_reply.setPartnerLink(this.m_partnerLinkField.getText());
        Object obj = this.m_portTypeCB.getSelectedItem();
        if (obj instanceof WSDLPortTypeListItem && (ptype = (item = (WSDLPortTypeListItem)obj).getPortType()) != null) {
            QName qname = ptype.getQName();
            String nsURI = qname.getNamespaceURI();
            String prefix = this.m_page.m_processModel.addNamespace(nsURI);
            String local = qname.getLocalPart();
            this.m_reply.setPortType(new QName(nsURI, local, prefix));
        }
        if ((obj = this.m_operationsCB.getSelectedItem()) instanceof WSDLOperationListItem) {
            WSDLOperationListItem opItem = (WSDLOperationListItem)obj;
            this.m_reply.setOperation(opItem.getOperation().getName());
        } else if (obj != null) {
            this.m_reply.setOperation((String)obj);
        } else {
            this.m_reply.setOperation(null);
        }
        String partnerLink = this.m_reply.getPartnerLink();
        boolean bl = bLinkChanged = this.m_origPartnerLink == null && partnerLink != null || this.m_origPartnerLink != null && partnerLink == null || this.m_origPartnerLink != null && partnerLink != null && !this.m_origPartnerLink.equalsIgnoreCase(partnerLink);
        if (bLinkChanged) {
            this.m_page.updateGraphPartnerLinkConnections((Node)this.m_page.m_replyNode);
        }
    }

    protected void loadControls() {
        QName qname;
        if (this.m_partnerLinkName != null) {
            this.m_partnerLinkField.setText(this.m_partnerLinkName);
        } else {
            this.m_partnerLinkField.setText(this.m_reply.getPartnerLink());
        }
        this.handlePartnerLinkSelection(this.m_page.getPartnerLink(this.m_partnerLinkField.getText()));
        this.m_varField.setText(this.m_reply.getVariable());
        this.m_origPartnerLink = this.m_reply.getPartnerLink();
        if (Helper.hasValue((String)this.m_origPartnerLink)) {
            PartnerLink l;
            this.m_link = l = this.m_page.getPartnerLink(this.m_origPartnerLink);
            if (l != null) {
                this.m_roleField.setText(l.getPartnerRole());
            }
        }
        this.m_portType = qname = this.m_reply.getPortType();
        if (qname != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_portTypeCB.getModel();
            boolean bSelected = false;
            for (int i = 0; i < model.getSize() && !bSelected; ++i) {
                WSDLPortTypeListItem item = (WSDLPortTypeListItem)model.getElementAt(i);
                if (!item.isEqual(qname)) continue;
                model.setSelectedItem(item);
                bSelected = true;
            }
            if (!bSelected) {
                model.setSelectedItem(BPELModelUtil.getPrefixQualifiedName((QName)qname));
            }
        }
        if (this.m_link == null || this.m_operation == null || this.m_operation.length() == 0) {
            this.m_varCreateBtn.setEnabled(false);
        } else {
            this.m_varCreateBtn.setEnabled(true);
        }
    }

    protected void createControls() {
        this.m_wsdlFaultBrowseBtn = UIHelper.createBrowseButton((String)"Browse Faults...");
        this.m_wsdlFaultBrowseBtn.addActionListener(this);
        this.m_partnerLinkBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_PLS"));
        this.m_partnerLinkBrowseBtn.addActionListener(this);
        this.m_portTypeCB = new JComboBox();
        this.m_portTypeCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("port_type_node")));
        this.m_portTypeCB.addActionListener(this);
        this.m_roleCB = new JComboBox();
        this.m_roleCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_role_node")));
        this.m_roleCB.addActionListener(this);
        this.m_roleField = new JTextField();
        this.m_roleField.setEditable(false);
        this.m_partnerLinkField = new JTextField();
        this.m_partnerLinkField.setEditable(false);
        this.m_operationsCB = new JComboBox();
        this.m_operationsCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("operation_node")));
        this.m_operationsCB.addActionListener(this);
        this.m_varField = new JTextField();
        this.m_varField.setEditable(false);
        this.m_varCreateBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_varCreateBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_RCV_AUTO_CRE_VAR"));
        this.m_varCreateBtn.addActionListener(this);
        this.m_varBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JLabel varLbl = new JLabel();
        BPELStringTranslator.setLabel(varLbl, this.m_varField, BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_VAR"));
        JLabel plinkLbl = new JLabel();
        BPELStringTranslator.setLabel(plinkLbl, this.m_partnerLinkField, BPELStringTranslator.getString("EDITOR_RCV_PL"));
        JLabel myRoleLbl = new JLabel();
        BPELStringTranslator.setLabel(myRoleLbl, this.m_roleField, BPELStringTranslator.getString("EDITOR_RCV_MY_ROLE"));
        JLabel portLbl = new JLabel();
        BPELStringTranslator.setLabel(portLbl, this.m_portTypeCB, BPELStringTranslator.getString("EDITOR_RCV_PORT_TYPE"));
        JLabel opLbl = new JLabel();
        BPELStringTranslator.setLabel(opLbl, this.m_operationsCB, BPELStringTranslator.getString("EDITOR_RCV_OP"));
        ToolBar varTB = new ToolBar();
        varTB.add((Component)this.m_varCreateBtn);
        varTB.add((Component)this.m_varBrowseBtn);
        ToolBar partnerLinkTB = new ToolBar();
        partnerLinkTB.add((Component)this.m_partnerLinkBrowseBtn);
        SectionHeader header = new SectionHeader(BPELStringTranslator.getString("EDITOR_RCV_MY_WI"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        JPanel interfacePnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)interfacePnl, (Component)plinkLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)interfacePnl, (Component)this.m_partnerLinkField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)interfacePnl, (Component)partnerLinkTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)interfacePnl, (Component)opLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 10, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)interfacePnl, (Component)this.m_operationsCB, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 10, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        row = 0;
        GraphUtils.addComponent((Container)this, (Component)header, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)interfacePnl, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)varLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_varField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)varTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void loadVariablesCombo(JComboBox cb) {
        this.m_page.loadVariables(cb, true);
        String modelVar = this.m_reply.getVariable();
        DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
        if (modelVar != null && !this.m_page.isVariableInModel(modelVar, model)) {
            Variable v = (Variable)BPELParser.createImplementation(Variable.class);
            v.setName(modelVar);
            model.addElement(new VariableListItem(v));
        }
    }

    protected void handlePartnerLinkSelection(PartnerLink pl) {
        PartnerLink link;
        this.m_roleCB.setModel(new DefaultComboBoxModel());
        this.m_portTypeCB.setModel(new DefaultComboBoxModel());
        this.m_operationsCB.setModel(new DefaultComboBoxModel());
        this.m_roleField.setText("");
        this.m_link = link = pl;
        if (link == null) {
            return;
        }
        final String partnerRole = link.getMyRole();
        this.m_page.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Role r = ReplyPartnerLinkPanel.this.m_page.getRoleForPartnerLinkRoleName(link, partnerRole);
                    if (r != null) {
                        ReplyPartnerLinkPanel.this.handleRoleSelection(r);
                        ReplyPartnerLinkPanel.this.m_page.selectOperation(ReplyPartnerLinkPanel.this.m_reply.getOperation(), ReplyPartnerLinkPanel.this.m_operationsCB);
                    }
                    ReplyPartnerLinkPanel.this.m_roleField.setText(partnerRole);
                    Object op = ReplyPartnerLinkPanel.this.m_operationsCB.getSelectedItem();
                    if (op instanceof WSDLOperationListItem) {
                        WSDLOperationListItem opItem = (WSDLOperationListItem)op;
                        ReplyPartnerLinkPanel.this.m_operation = opItem.getOperation().getName();
                    } else {
                        ReplyPartnerLinkPanel.this.m_operation = null;
                    }
                    if (ReplyPartnerLinkPanel.this.m_link == null || ReplyPartnerLinkPanel.this.m_operation == null || ReplyPartnerLinkPanel.this.m_operation.length() == 0) {
                        ReplyPartnerLinkPanel.this.m_varCreateBtn.setEnabled(false);
                    } else {
                        ReplyPartnerLinkPanel.this.m_varCreateBtn.setEnabled(true);
                    }
                }
                finally {
                    ReplyPartnerLinkPanel.this.m_page.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void handleRoleSelection(Role r) {
        this.m_page.setModified(true);
        PortType wsdlPortType = r.getPortType();
        this.m_page.populatePortTypes(wsdlPortType, this.m_portTypeCB);
    }

    protected void handleRoleSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_roleCB.getSelectedItem();
        if (obj instanceof RoleListItem) {
            RoleListItem selItem = (RoleListItem)obj;
            Role r = selItem.getRole();
            PortType wsdlPortType = r.getPortType();
            this.m_page.populatePortTypes(wsdlPortType, this.m_portTypeCB);
        }
    }

    protected void handlePortTypeSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_portTypeCB.getSelectedItem();
        if (obj instanceof WSDLPortTypeListItem) {
            WSDLPortTypeListItem item = (WSDLPortTypeListItem)obj;
            PortType portType = item.getPortType();
            if (portType == null) {
                return;
            }
            this.m_portType = portType.getQName();
            this.m_page.populateOperations(portType, this.m_operationsCB);
        }
    }

    protected void handleVariableBrowse() {
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_reply);
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_varField.setText(v.getName());
            } else {
                this.m_varField.setText("");
            }
        }
    }

    protected void handlePartnerLinkBrowse() {
        PartnerLinkChooser dlg = this.getPartnerLinkChooser();
        if (dlg.display() == 0) {
            PartnerLink pl;
            this.m_link = pl = dlg.getSelectedPartnerLink();
            if (pl != null) {
                this.m_partnerLinkField.setText(pl.getName());
            } else {
                this.m_partnerLinkField.setText("");
            }
            this.handlePartnerLinkSelection(pl);
        }
    }

    protected PartnerLinkChooser getPartnerLinkChooser() {
        return new PartnerLinkChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_reply);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_roleCB) {
            this.handleRoleSelection();
        } else if (src == this.m_portTypeCB) {
            this.handlePortTypeSelection();
        } else if (src == this.m_varBrowseBtn) {
            this.handleVariableBrowse();
        } else if (src == this.m_partnerLinkBrowseBtn) {
            this.handlePartnerLinkBrowse();
        } else if (src == this.m_operationsCB) {
            this.handleOperationSelection();
        } else if (src == this.m_varCreateBtn) {
            this.createOutputVariable();
        }
    }

    protected void handleOperationSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
    }

    protected void createOutputVariable() {
        Variable variable;
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
        if (this.m_link == null || this.m_portType == null || this.m_operation == null) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_RCV_ENTER_INFO"), (int)0);
            return;
        }
        String name = this.m_page.m_nameField.getText().trim();
        if (!Helper.isValidName((String)name, (boolean)false)) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (int)0);
            return;
        }
        if (Helper.hasValue((String)name) && Helper.hasValue((String)this.m_operation) && (variable = this.m_page.createVariable(this.m_page.m_processModel, (Activity)this.m_reply, this.m_link, this.m_portType, this.m_operation, name = name + "_" + this.m_operation, false)) != null) {
            VariableAutoCreationDialog dlg;
            boolean hasScope = false;
            List scopes = BPELModelUtil.getParentScopes((Activity)this.m_reply);
            if (scopes != null && scopes.size() > 0) {
                hasScope = true;
            }
            if ((dlg = new VariableAutoCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_reply, variable.getName(), variable.getMessageType().toString(), hasScope)).display() == 0) {
                this.m_varField.setText(dlg.getVariableName());
                variable.setName(dlg.getVariableName());
                if (dlg.isGlobal()) {
                    this.m_page.m_processModel.addVariable(variable);
                } else if (scopes != null && scopes.size() > 0) {
                    Scope scope = (Scope)scopes.get(0);
                    scope.addVariable(variable);
                } else {
                    this.m_page.m_processModel.addVariable(variable);
                }
            }
        }
    }
}

