/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.wsdl.Fault;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.ComponentBorderPane;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ReplyPartnerLinkPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReplyNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault.FaultChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityEditor;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;

public class ReplyGenEditPage
extends BaseEditingPage
implements EditorPage,
ActionListener {
    private static final int PARTNER_LINK_INDEX = 0;
    private final String PARTNER_LINK_PANEL = "PARTNER_LINK_PANEL";
    protected JTextField m_nameField;
    protected JTextField m_faultField;
    protected JTextField m_faultNamespaceURIField;
    protected JTextField m_faultLocalPartField;
    protected JButton m_wsdlFaultBrowseBtn;
    protected CardPanel m_cardPnl;
    protected ReplyPartnerLinkPanel m_partnerLinkPnl;
    protected JComboBox m_interactionTypeCombo;
    protected ComponentBorderPane m_borderPane;
    protected Reply m_reply;
    protected ReplyNode m_replyNode;

    public ReplyGenEditPage(BPELGraphPane graphPane, ReplyNode node) {
        super(graphPane);
        this.m_replyNode = node;
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
        this.loadControls();
    }

    public void setPartnerLinkConnectionMode(String link) {
        this.m_interactionTypeCombo.setSelectedIndex(0);
        this.m_partnerLinkPnl.setPartnerLinkConnectionMode(link);
    }

    protected void createControls() {
        this.m_wsdlFaultBrowseBtn = UIHelper.createBrowseButton((String)"Browse Faults...");
        this.m_wsdlFaultBrowseBtn.addActionListener(this);
        this.m_nameField = new JTextField();
        this.m_faultField = new JTextField();
        this.m_faultNamespaceURIField = new JTextField();
        this.m_faultLocalPartField = new JTextField();
        this.m_cardPnl = new CardPanel();
        this.m_interactionTypeCombo = new JComboBox();
        this.m_interactionTypeCombo.addActionListener(this);
        this.m_interactionTypeCombo.setRenderer(new InteractionActivityPluginListCellRenderer());
        JLabel l = new JLabel();
        BPELStringTranslator.setLabel(l, this.m_interactionTypeCombo, BPELStringTranslator.getString("INTERACTION_TYPE_LBL"));
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_interactionTypeCombo, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        this.m_borderPane = new ComponentBorderPane((JComponent)p, (JComponent)this.m_cardPnl);
        this.m_partnerLinkPnl = new ReplyPartnerLinkPanel(this);
        this.m_cardPnl.add("PARTNER_LINK_PANEL", (Component)this.m_partnerLinkPnl);
        this.m_cardPnl.show("PARTNER_LINK_PANEL");
    }

    protected void layoutControls() {
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JPanel namePnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)namePnl, (Component)nameLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)namePnl, (Component)this.m_nameField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)namePnl, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_borderPane, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.createFaultNamePanel(), (int)0, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected JPanel createFaultNamePanel() {
        ToolBar tb3 = new ToolBar();
        tb3.add((Component)this.m_wsdlFaultBrowseBtn);
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_CGE_FAULT_QNAME")));
        int row = 0;
        JLabel lblNS = new JLabel();
        BPELStringTranslator.setLabel(lblNS, this.m_faultNamespaceURIField, BPELStringTranslator.getString("EDITOR_CGE_FAULT_NS"));
        GraphUtils.addComponent((Container)p, (Component)tb3, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)lblNS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_faultNamespaceURIField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel lblLP = new JLabel();
        BPELStringTranslator.setLabel(lblLP, this.m_faultLocalPartField, BPELStringTranslator.getString("EDITOR_CGE_FAULT_LP"));
        GraphUtils.addComponent((Container)p, (Component)lblLP, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_faultLocalPartField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_partnerLinkPnl.m_reply = this.m_reply = (Reply)model;
        DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>();
        m.insertElementAt(BPELStringTranslator.getString("PARTNER_LINK"), 0);
        InteractionActivityPluginListItem editingPlugin = null;
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null) continue;
            InteractionActivityPluginListItem item = new InteractionActivityPluginListItem(ip);
            m.addElement(item);
            InteractionActivityEditor editor = ip.createActivityEditor((Activity)this.m_reply, this);
            item.setEditor(editor);
            JComponent comp = editor.getEditorComponent();
            this.m_cardPnl.add(ip.getName(), (Component)comp);
            if (!ip.isEditorForActivity((Activity)this.m_reply)) continue;
            editingPlugin = item;
        }
        this.m_interactionTypeCombo.setModel(m);
        if (editingPlugin != null) {
            m.setSelectedItem(editingPlugin);
        } else {
            this.m_interactionTypeCombo.setSelectedIndex(0);
        }
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        InteractionActivityPluginListItem item;
        String localPart;
        this.m_reply.setName(this.m_nameField.getText());
        String ns = this.m_faultNamespaceURIField.getText();
        if (ns != null) {
            ns = ns.trim();
        }
        if ((localPart = this.m_faultLocalPartField.getText()) != null) {
            localPart = localPart.trim();
        }
        if (ns != null && localPart != null) {
            String prefix = this.m_processModel.addNamespace(ns);
            QName qName = new QName(ns, localPart, prefix);
            this.m_reply.setFaultName(qName);
        }
        if ((item = this.getSelectedPlugin()) != null) {
            item.getEditor().save();
            this.updateGraphPartnerLinkConnections((Node)this.m_replyNode);
        } else {
            this.m_partnerLinkPnl.saveChanges();
        }
        this.fireProcessChangedEvent(28);
    }

    @Override
    public boolean validateEditorChanges() {
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)0);
            return false;
        }
        return true;
    }

    protected void loadControls() {
        this.m_nameField.setText(this.m_reply.getName());
        QName faultName = this.m_reply.getFaultName();
        if (faultName != null) {
            String ns = faultName.getNamespaceURI();
            if (ns != null) {
                this.m_faultNamespaceURIField.setText(ns);
            } else {
                ns = this.m_processModel.getNamespaceForPrefix(faultName.getPrefix());
                if (ns != null) {
                    this.m_faultNamespaceURIField.setText(ns);
                } else {
                    this.m_faultNamespaceURIField.setText(this.m_graphModel.getProcess().getTargetNamespace());
                }
            }
            this.m_faultLocalPartField.setText(faultName.getLocalPart());
        }
        this.m_partnerLinkPnl.loadControls();
    }

    protected void handleWSDLFaultBrowse() {
        Fault f;
        FaultChooser chooser = new FaultChooser(GraphUtils.getFrame((Component)this), this.m_graphPane);
        if (chooser.display() == 0 && (f = chooser.getFault()) != null) {
            this.m_faultNamespaceURIField.setText(chooser.getFaultNamespace());
            this.m_faultLocalPartField.setText(f.getName());
        }
    }

    protected InteractionActivityPluginListItem getSelectedPlugin() {
        Object item = this.m_interactionTypeCombo.getSelectedItem();
        if (item instanceof InteractionActivityPluginListItem) {
            return (InteractionActivityPluginListItem)item;
        }
        return null;
    }

    protected void handleInteractionTypeSelection() {
        InteractionActivityPluginListItem item = this.getSelectedPlugin();
        if (item != null) {
            this.m_cardPnl.show(item.getPlugin().getName());
        } else if (this.m_interactionTypeCombo.getSelectedIndex() == 0) {
            this.m_cardPnl.show("PARTNER_LINK_PANEL");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_wsdlFaultBrowseBtn) {
            this.handleWSDLFaultBrowse();
        } else if (src == this.m_interactionTypeCombo) {
            this.handleInteractionTypeSelection();
        }
    }
}

