/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Rename;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.TargetOpType;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.datasources.schema.SchemaTypesDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.ProjectWSDLDataSource;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.typeexplorer.WSDLImportHandler;
import oracle.tip.tools.ide.common.ui.ComponentBorderPane;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageInputs;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkTypesDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ProjectSchemaImportHandler;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ProjectWSDLImportHandler;
import oracle.tip.tools.ide.pm.bpelgraph.editors.TargetOpTypeEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class RenameEditPage
extends TargetOpTypeEditPage {
    protected JTextField m_elementToNSField;
    protected JTextField m_elementToLPField;
    protected JTextField m_typecastToNSField;
    protected JTextField m_typecastToLPField;
    protected JButton m_elementToBrowseBtn;
    protected JButton m_typecastToBrowseBtn;
    protected JCheckBox m_renameBox;
    protected JCheckBox m_castBox;

    public RenameEditPage(BPELGraphPane pane, CopyPageInputs in, Object copyRule, boolean editMode) {
        super(pane, in, copyRule, editMode);
    }

    @Override
    protected void createControls() {
        super.createControls();
        this.m_elementToNSField = new JTextField();
        this.m_elementToLPField = new JTextField();
        this.m_typecastToNSField = new JTextField();
        this.m_typecastToLPField = new JTextField();
        this.m_elementToBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("BROWSE_FOR_QNAME_TIP"));
        this.m_elementToBrowseBtn.addActionListener(this);
        this.m_typecastToBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("BROWSE_FOR_QNAME_TIP"));
        this.m_typecastToBrowseBtn.addActionListener(this);
        this.m_renameBox = new JCheckBox();
        this.m_castBox = new JCheckBox();
    }

    @Override
    protected void populateToTypeCB() {
        this.m_toTypeCB.addItem(BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_TBL_VAR"));
    }

    @Override
    public void populateCopyInfo() {
        int toSelection;
        String prefix;
        To to = ((Rename)this.m_copyRule).getTarget();
        String ns = this.m_elementToNSField.getText().trim();
        String lp = this.m_elementToLPField.getText().trim();
        if (this.m_renameBox.isSelected()) {
            if (ns.length() > 0 && lp != null) {
                prefix = this.m_processModel.getPrefixForNamespace(ns);
                if (prefix == null) {
                    prefix = this.m_processModel.addNamespace(ns);
                }
                ((Rename)this.m_copyRule).setElementTo(new QName(ns, lp, prefix));
                ((Rename)this.m_copyRule).setTypeCastTo(null);
            } else {
                ((Rename)this.m_copyRule).setElementTo(null);
                ((Rename)this.m_copyRule).setTypeCastTo(null);
            }
        }
        ns = this.m_typecastToNSField.getText().trim();
        lp = this.m_typecastToLPField.getText().trim();
        if (this.m_castBox.isSelected()) {
            if (ns.length() > 0 && lp != null) {
                prefix = this.m_processModel.getPrefixForNamespace(ns);
                if (prefix == null) {
                    prefix = this.m_processModel.addNamespace(ns);
                }
                ((Rename)this.m_copyRule).setTypeCastTo(new QName(ns, lp, prefix));
                ((Rename)this.m_copyRule).setElementTo(null);
            } else {
                ((Rename)this.m_copyRule).setElementTo(null);
                ((Rename)this.m_copyRule).setTypeCastTo(null);
            }
        }
        if ((toSelection = this.m_toTypeCB.getSelectedIndex()) == 0) {
            Variable v = this.m_toXPathBuilderPnl.getVariable();
            if (v != null) {
                to.setVariable(v.getName());
            } else {
                to.setVariable(null);
            }
            MessagePart p = this.m_toXPathBuilderPnl.getPart();
            if (p != null) {
                to.setPart(p.getName());
            } else {
                to.setPart(null);
            }
            String xpath = this.m_toXPathBuilderPnl.getXPath();
            this.m_toXPathBuilderPnl.saveCachedNS();
            to.setQuery(xpath);
        } else {
            to.setVariable(null);
            to.setPart(null);
            to.setQuery(null);
        }
    }

    @Override
    protected String loadCopyRule() {
        QName qname = ((Rename)this.m_copyRule).getElementTo();
        if (qname != null) {
            this.m_elementToNSField.setText(qname.getNamespaceURI());
            this.m_elementToLPField.setText(qname.getLocalPart());
            this.m_renameBox.setSelected(true);
            this.m_castBox.setSelected(false);
        } else {
            qname = ((Rename)this.m_copyRule).getTypeCastTo();
            if (qname != null) {
                this.m_typecastToNSField.setText(qname.getNamespaceURI());
                this.m_typecastToLPField.setText(qname.getLocalPart());
                this.m_renameBox.setSelected(false);
                this.m_castBox.setSelected(true);
            } else {
                this.m_renameBox.setSelected(true);
                this.m_castBox.setSelected(false);
            }
        }
        this.loadBPELExtTo(((TargetOpType)this.m_copyRule).getTarget());
        return null;
    }

    @Override
    protected JPanel getToPanel() {
        JPanel toPanel = new JPanel(new GridBagLayout());
        TitledBorder b = new TitledBorder(" " + BPELStringTranslator.getString("EDITOR_CPY_EDIT_TO") + " ");
        Font f = UIManager.getFont("Label.font");
        b.setTitleFont(new Font(f.getFontName(), 1, 14));
        toPanel.setBorder(b);
        toPanel.setOpaque(false);
        JPanel p = new JPanel(new GridLayout(1, 2));
        p.add(this.createQNamePanel(this.m_elementToBrowseBtn, this.m_elementToNSField, this.m_elementToLPField, BPELStringTranslator.getString("ELEMENT_TO_BTN"), BPELStringTranslator.getString("EDITOR_CGE_FAULT_NS"), BPELStringTranslator.getString("EDITOR_CGE_FAULT_LP"), this.m_renameBox));
        p.add(this.createQNamePanel(this.m_typecastToBrowseBtn, this.m_typecastToNSField, this.m_typecastToLPField, BPELStringTranslator.getString("TYPE_CAST_TO_BTN"), BPELStringTranslator.getString("NAMESPACE_URI_LBL"), BPELStringTranslator.getString("LOCAL_PART_LBL"), this.m_castBox));
        int row = 0;
        GraphUtils.addComponent((Container)toPanel, (Component)p, (int)0, (int)row++, (int)1, (int)1, (int)10, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)toPanel, (Component)this.m_toCardPnl, (int)0, (int)row++, (int)1, (int)1, (int)10, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return toPanel;
    }

    protected JPanel createQNamePanel(JButton qnameBroserBtn, JTextField nsField, JTextField localPartField, String title, String nsTitle, String lpTitle, JCheckBox jCheckBox) {
        ToolBar tb3 = new ToolBar();
        tb3.add((Component)qnameBroserBtn);
        BPELStringTranslator.setButton(jCheckBox, title);
        jCheckBox.addActionListener(this);
        jCheckBox.setFont(UIManager.getFont("TitledBorder.font"));
        jCheckBox.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        JPanel p = new JPanel(new GridBagLayout());
        int row = 0;
        JLabel lblNS = new JLabel();
        BPELStringTranslator.setLabel(lblNS, nsField, nsTitle);
        GraphUtils.addComponent((Container)p, (Component)tb3, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)lblNS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)nsField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel lblLP = new JLabel();
        BPELStringTranslator.setLabel(lblLP, localPartField, lpTitle);
        GraphUtils.addComponent((Container)p, (Component)lblLP, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)localPartField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return new ComponentBorderPane((JComponent)jCheckBox, (JComponent)p);
    }

    protected void handleElementTo() {
        QName qname;
        TypeObject to = this.getTypeObject(true);
        if (to != null && (qname = to.getQName()) != null) {
            this.m_elementToNSField.setText(qname.getNamespaceURI());
            this.m_elementToLPField.setText(qname.getLocalPart());
        }
    }

    protected void handleTypeCastTo() {
        TypeObject to = this.getTypeObject(false);
        if (to != null) {
            QName qname = to.getQName();
            this.m_typecastToNSField.setText(qname.getNamespaceURI());
            this.m_typecastToLPField.setText(qname.getLocalPart());
        }
    }

    protected TypeObject getTypeObject(boolean bElement) {
        TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
        TypeExplorer explorer = chooser.getTypeExplorer();
        explorer.setWSDLImportHandler((WSDLImportHandler)new ProjectWSDLImportHandler(this.m_graphPane, true));
        explorer.setSchemaImportHandler((SchemaImportHandler)new ProjectSchemaImportHandler(this.m_graphPane, true));
        boolean bShowElement = bElement;
        boolean bShowComplexType = !bElement;
        ProjectSchemaDataSource ds1 = new ProjectSchemaDataSource((IDEProject)this.m_graphPane.getBPELProject(), bShowComplexType, bShowElement);
        ProjectWSDLDataSource ds2 = new ProjectWSDLDataSource(this.m_graphPane.getBPELProject(), bShowComplexType, bShowElement, false);
        PartnerLinkTypesDataSource ds3 = new PartnerLinkTypesDataSource(this.m_processModel, bShowComplexType, bShowElement, false, true);
        CompoundDataSource cs = new CompoundDataSource();
        if (bShowComplexType) {
            cs.addDataSource((TreeExplorerDataSource)new SchemaTypesDataSource());
        }
        cs.addDataSource((TreeExplorerDataSource)ds1);
        cs.addDataSource((TreeExplorerDataSource)ds2);
        cs.addDataSource((TreeExplorerDataSource)ds3);
        if (chooser.display((TreeExplorerDataSource)cs) == 0) {
            return chooser.getTypeObject();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_elementToBrowseBtn) {
            this.handleElementTo();
        } else if (src == this.m_typecastToBrowseBtn) {
            this.handleTypeCastTo();
        } else if (src == this.m_renameBox) {
            if (this.m_renameBox.isSelected()) {
                this.m_castBox.setSelected(false);
            } else {
                this.m_castBox.setSelected(true);
            }
        } else if (src == this.m_castBox) {
            if (this.m_castBox.isSelected()) {
                this.m_renameBox.setSelected(false);
            } else {
                this.m_renameBox.setSelected(true);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected String getHelpTopicID() {
        String appendToTopicLookup = this.inEditMode ? "Edit" : "Create";
        return this.getClass().getName() + "." + appendToTopicLookup;
    }
}

