/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ui.SectionHeader;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ReceiveGenEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.RoleListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableAutoCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLOperationListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLPortTypeListItem;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReceiveNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink.PartnerLinkChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ReceivePartnerLinkPanel
extends JPanel
implements ActionListener {
    protected JTextField m_roleField;
    protected JComboBox m_portTypeCB;
    protected JComboBox m_roleCB;
    protected JComboBox m_operationsCB;
    protected JTextField m_varField;
    protected JButton m_varCreateBtn;
    protected JButton m_varBrowseBtn;
    protected JButton m_partnerLinkBrowseBtn;
    protected JTextField m_partnerLinkField;
    protected QName m_portType;
    protected String m_operation;
    protected Receive m_receive;
    protected ReceiveNode m_receiveNode;
    protected BPELGraphPane m_graphPane;
    protected ReceiveGenEditPage m_page;
    protected PartnerLink m_link;
    protected String m_partnerLinkName;
    protected String m_origPartnerLink;
    protected boolean m_bPartnerLinkConnectionMode = false;

    public ReceivePartnerLinkPanel(ReceiveGenEditPage page, BPELGraphPane graph) {
        this.m_page = page;
        this.m_graphPane = graph;
        this.m_receiveNode = page.m_receiveNode;
        this.createControls();
        this.layoutControls();
    }

    public void setPartnerLinkConnectionMode(String link) {
        this.m_bPartnerLinkConnectionMode = true;
        this.m_partnerLinkName = link;
        this.m_partnerLinkBrowseBtn.setEnabled(false);
    }

    public void saveChanges() {
        boolean bLinkChanged;
        WSDLPortTypeListItem item;
        PortType ptype;
        if (this.m_receive == null) {
            return;
        }
        this.m_receive.setVariable(this.m_varField.getText());
        this.m_receive.setPartnerLink(this.m_partnerLinkField.getText());
        Object obj = this.m_portTypeCB.getSelectedItem();
        if (obj instanceof WSDLPortTypeListItem && (ptype = (item = (WSDLPortTypeListItem)obj).getPortType()) != null) {
            QName qname = ptype.getQName();
            String nsURI = qname.getNamespaceURI();
            String prefix = this.m_page.m_processModel.addNamespace(nsURI);
            String local = qname.getLocalPart();
            this.m_receive.setPortType(new QName(nsURI, local, prefix));
        }
        if ((obj = this.m_operationsCB.getSelectedItem()) instanceof WSDLOperationListItem) {
            WSDLOperationListItem opItem = (WSDLOperationListItem)obj;
            this.m_receive.setOperation(opItem.getOperation().getName());
        } else if (obj != null) {
            this.m_receive.setOperation((String)obj);
        } else {
            this.m_receive.setOperation(null);
        }
        String partnerLink = this.m_receive.getPartnerLink();
        boolean bl = bLinkChanged = this.m_origPartnerLink == null && partnerLink != null || this.m_origPartnerLink != null && partnerLink == null || this.m_origPartnerLink != null && partnerLink != null && !this.m_origPartnerLink.equalsIgnoreCase(partnerLink);
        if (bLinkChanged) {
            this.m_page.updateGraphPartnerLinkConnections((Node)this.m_receiveNode);
        }
        this.m_page.fireProcessChangedEvent(28);
    }

    protected void loadControls() {
        QName qname;
        if (this.m_partnerLinkName != null) {
            this.m_partnerLinkField.setText(this.m_partnerLinkName);
        } else {
            this.m_partnerLinkField.setText(this.m_receive.getPartnerLink());
        }
        PartnerLink partnerLink = this.m_page.getPartnerLink(this.m_partnerLinkField.getText());
        if (this.m_bPartnerLinkConnectionMode) {
            this.m_link = partnerLink;
        }
        this.handlePartnerLinkSelection(partnerLink, this.m_receive.getOperation());
        this.m_varField.setText(this.m_receive.getVariable());
        this.m_origPartnerLink = this.m_receive.getPartnerLink();
        if (Helper.hasValue((String)this.m_origPartnerLink)) {
            PartnerLink l;
            this.m_link = l = this.m_page.getPartnerLink(this.m_origPartnerLink);
            if (l != null) {
                this.m_roleField.setText(l.getMyRole());
            }
        }
        this.m_portType = qname = this.m_receive.getPortType();
        if (qname != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_portTypeCB.getModel();
            boolean bSelected = false;
            for (int i = 0; i < model.getSize() && !bSelected; ++i) {
                WSDLPortTypeListItem item = (WSDLPortTypeListItem)model.getElementAt(i);
                if (!item.isEqual(qname)) continue;
                model.setSelectedItem(item);
                bSelected = true;
            }
            if (!bSelected) {
                model.setSelectedItem(BPELModelUtil.getPrefixQualifiedName((QName)qname));
            }
        }
        this.enableCreateVarButton();
    }

    protected void createControls() {
        this.m_partnerLinkBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_PLS"));
        this.m_partnerLinkBrowseBtn.addActionListener(this);
        this.m_portTypeCB = new JComboBox();
        this.m_portTypeCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("port_type_node")));
        this.m_portTypeCB.addActionListener(this);
        this.m_operationsCB = new JComboBox();
        this.m_operationsCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("operation_node")));
        this.m_operationsCB.addActionListener(this);
        this.m_partnerLinkField = new JTextField();
        this.m_partnerLinkField.setEditable(false);
        this.m_varField = new JTextField();
        this.m_varField.setEditable(false);
        this.m_varCreateBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_varCreateBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_RCV_AUTO_CRE_VAR"));
        this.m_varCreateBtn.addActionListener(this);
        this.m_varBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
        this.m_roleCB = new JComboBox();
        this.m_roleCB.addActionListener(this);
        this.m_roleCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_role_node")));
        this.m_roleField = new JTextField();
        this.m_roleField.setEditable(false);
    }

    protected void layoutControls() {
        ToolBar partnerLinkTB = new ToolBar();
        partnerLinkTB.add((Component)this.m_partnerLinkBrowseBtn);
        ToolBar varTB = new ToolBar();
        varTB.add((Component)this.m_varCreateBtn);
        varTB.add((Component)this.m_varBrowseBtn);
        JLabel plinkLbl = new JLabel();
        BPELStringTranslator.setLabel(plinkLbl, this.m_partnerLinkField, BPELStringTranslator.getString("EDITOR_RCV_PL"));
        JLabel roleLbl = new JLabel();
        BPELStringTranslator.setLabel(roleLbl, this.m_roleField, BPELStringTranslator.getString("EDITOR_RCV_MY_ROLE"));
        JLabel portLbl = new JLabel();
        BPELStringTranslator.setLabel(portLbl, this.m_portTypeCB, BPELStringTranslator.getString("EDITOR_RCV_PORT_TYPE"));
        JLabel opLbl = new JLabel();
        BPELStringTranslator.setLabel(opLbl, this.m_operationsCB, BPELStringTranslator.getString("EDITOR_RCV_OP"));
        SectionHeader partnerLinkHeader = new SectionHeader(BPELStringTranslator.getString("MY_ROLE_WEB_SERVICE_INTERFACE"));
        SectionHeader variableHeader = new SectionHeader(BPELStringTranslator.getString("VARIABLE"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        JPanel myInterfacePnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)myInterfacePnl, (Component)plinkLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)myInterfacePnl, (Component)this.m_partnerLinkField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)myInterfacePnl, (Component)partnerLinkTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)myInterfacePnl, (Component)opLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)myInterfacePnl, (Component)this.m_operationsCB, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JLabel varLbl = new JLabel();
        BPELStringTranslator.setLabel(varLbl, this.m_varField, BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_VAR"));
        row = 0;
        GraphUtils.addComponent((Container)this, (Component)partnerLinkHeader, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)myInterfacePnl, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)variableHeader, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)varLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_varField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)varTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleRoleSelection(Role r) {
        this.m_page.setModified(true);
        PortType wsdlPortType = r.getPortType();
        this.m_page.populatePortTypes(wsdlPortType, this.m_portTypeCB);
    }

    protected void handleRoleSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_roleCB.getSelectedItem();
        if (obj instanceof RoleListItem) {
            RoleListItem selItem = (RoleListItem)obj;
            Role r = selItem.getRole();
            PortType wsdlPortType = r.getPortType();
            this.m_page.populatePortTypes(wsdlPortType, this.m_portTypeCB);
        }
    }

    protected void handlePortTypeSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_portTypeCB.getSelectedItem();
        if (obj instanceof WSDLPortTypeListItem) {
            WSDLPortTypeListItem item = (WSDLPortTypeListItem)obj;
            PortType portType = item.getPortType();
            if (portType == null) {
                return;
            }
            this.m_portType = portType.getQName();
            this.m_page.populateOperations(portType, this.m_operationsCB);
            if (this.m_operation != null) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_operationsCB.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    WSDLOperationListItem op = (WSDLOperationListItem)model.getElementAt(i);
                    if (!this.m_operation.equals(op.getOperation().getName())) continue;
                    model.setSelectedItem(op);
                    break;
                }
            }
        }
    }

    protected void handleVariableBrowse() {
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_receive);
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_varField.setText(v.getName());
            } else {
                this.m_varField.setText("");
            }
        }
    }

    protected void handlePartnerLinkBrowse() {
        PartnerLinkChooser dlg = this.getPartnerLinkChooser();
        if (dlg.display() == 0) {
            PartnerLink pl;
            this.m_link = pl = dlg.getSelectedPartnerLink();
            if (pl != null) {
                this.m_partnerLinkField.setText(pl.getName());
            } else {
                this.m_partnerLinkField.setText("");
            }
            this.handlePartnerLinkSelection(pl, null);
        }
    }

    protected void handlePartnerLinkSelection(PartnerLink pl, String operation) {
        this.m_roleCB.setModel(new DefaultComboBoxModel());
        this.m_portTypeCB.setModel(new DefaultComboBoxModel());
        this.m_operationsCB.setModel(new DefaultComboBoxModel());
        this.m_roleField.setText("");
        final PartnerLink link = pl;
        if (link == null) {
            this.enableCreateVarButton();
            return;
        }
        final String myRole = link.getMyRole();
        this.m_page.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Role r = ReceivePartnerLinkPanel.this.m_page.getRoleForPartnerLinkRoleName(link, myRole);
                    if (r != null) {
                        ReceivePartnerLinkPanel.this.handleRoleSelection(r);
                        ReceivePartnerLinkPanel.this.m_page.selectOperation(ReceivePartnerLinkPanel.this.m_receive.getOperation(), ReceivePartnerLinkPanel.this.m_operationsCB);
                    }
                    ReceivePartnerLinkPanel.this.m_roleField.setText(myRole);
                    Object op = ReceivePartnerLinkPanel.this.m_operationsCB.getSelectedItem();
                    if (op instanceof WSDLOperationListItem) {
                        WSDLOperationListItem opItem = (WSDLOperationListItem)op;
                        ReceivePartnerLinkPanel.this.m_operation = opItem.getOperation().getName();
                    } else {
                        ReceivePartnerLinkPanel.this.m_operation = null;
                    }
                    ReceivePartnerLinkPanel.this.enableCreateVarButton();
                }
                finally {
                    ReceivePartnerLinkPanel.this.m_page.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void enableCreateVarButton() {
        if (this.m_link == null || this.m_operation == null || this.m_operation.length() == 0) {
            this.m_varCreateBtn.setEnabled(false);
        } else {
            this.m_varCreateBtn.setEnabled(true);
        }
    }

    protected PartnerLinkChooser getPartnerLinkChooser() {
        return new PartnerLinkChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_receive);
    }

    protected void createInputVariable() {
        Variable variable;
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
        if (this.m_link == null || this.m_portType == null || this.m_operation == null) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_RCV_ENTER_INFO"), (int)0);
            return;
        }
        String name = this.m_page.m_nameField.getText().trim();
        if (!Helper.isValidName((String)name, (boolean)false)) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (int)0);
            return;
        }
        if (Helper.hasValue((String)name) && Helper.hasValue((String)this.m_operation) && (variable = this.m_page.createVariable(this.m_page.m_processModel, (Activity)this.m_receive, this.m_link, this.m_portType, this.m_operation, name = name + "_" + this.m_operation, true)) != null) {
            VariableAutoCreationDialog dlg;
            boolean hasScope = false;
            List scopes = BPELModelUtil.getParentScopes((Activity)this.m_receive);
            if (scopes != null && scopes.size() > 0) {
                hasScope = true;
            }
            if ((dlg = new VariableAutoCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_receive, variable.getName(), variable.getMessageType().toString(), hasScope)).display() == 0) {
                this.m_varField.setText(dlg.getVariableName());
                variable.setName(dlg.getVariableName());
                if (dlg.isGlobal()) {
                    this.m_page.m_processModel.addVariable(variable);
                } else if (scopes != null && scopes.size() > 0) {
                    Scope scope = (Scope)scopes.get(0);
                    scope.addVariable(variable);
                } else {
                    this.m_page.m_processModel.addVariable(variable);
                }
            }
        }
    }

    protected void handleOperationSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_roleCB) {
            this.handleRoleSelection();
        } else if (src == this.m_portTypeCB) {
            this.handlePortTypeSelection();
        } else if (src == this.m_varBrowseBtn) {
            this.handleVariableBrowse();
        } else if (src == this.m_partnerLinkBrowseBtn) {
            this.handlePartnerLinkBrowse();
        } else if (src == this.m_varCreateBtn) {
            this.createInputVariable();
        } else if (src == this.m_operationsCB) {
            this.handleOperationSelection();
        }
    }
}

