/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.ComponentBorderPane;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ReceivePartnerLinkPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReceiveNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityEditor;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;

public class ReceiveGenEditPage
extends BaseEditingPage
implements EditorPage,
ActionListener {
    private static final int PARTNER_LINK_INDEX = 0;
    private static final String PARTNER_LINK_PANEL = "PARTNER_LINK_PANEL";
    protected JTextField m_nameField;
    protected JCheckBox m_createInstanceCheckBox;
    protected CardPanel m_cardPnl;
    protected ReceivePartnerLinkPanel m_partnerLinkPnl;
    protected JComboBox m_interactionTypeCombo;
    protected ComponentBorderPane m_borderPane;
    protected Receive m_receive;
    protected ReceiveNode m_receiveNode;

    public ReceiveGenEditPage(BPELGraphPane graphPane, ReceiveNode receiveNode) {
        super(graphPane);
        this.m_receiveNode = receiveNode;
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
        this.loadControls();
        this.setModified(true);
    }

    public void setPartnerLinkConnectionMode(String link) {
        this.m_interactionTypeCombo.setSelectedIndex(0);
        this.m_partnerLinkPnl.setPartnerLinkConnectionMode(link);
    }

    protected void createControls() {
        this.m_partnerLinkPnl = new ReceivePartnerLinkPanel(this, this.m_graphPane);
        this.m_createInstanceCheckBox = new JCheckBox(BPELStringTranslator.getString("EDITOR_RCV_CRT_INST"));
        BPELStringTranslator.setButton(this.m_createInstanceCheckBox, BPELStringTranslator.getString("EDITOR_RCV_CRT_INST_RES_I"));
        this.m_nameField = new JTextField();
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add(PARTNER_LINK_PANEL, (Component)this.m_partnerLinkPnl);
        this.m_interactionTypeCombo = new JComboBox();
        this.m_interactionTypeCombo.addActionListener(this);
        this.m_interactionTypeCombo.setRenderer(new InteractionActivityPluginListCellRenderer());
        JLabel l = new JLabel();
        BPELStringTranslator.setLabel(l, this.m_interactionTypeCombo, BPELStringTranslator.getString("INTERACTION_TYPE_LBL"));
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_interactionTypeCombo, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        this.m_borderPane = new ComponentBorderPane((JComponent)p, (JComponent)this.m_cardPnl);
    }

    protected void layoutControls() {
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_borderPane, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_createInstanceCheckBox, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_partnerLinkPnl.m_receive = this.m_receive = (Receive)model;
        DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>();
        m.insertElementAt(BPELStringTranslator.getString("PARTNER_LINK"), 0);
        InteractionActivityPluginListItem editingPlugin = null;
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null) continue;
            InteractionActivityPluginListItem item = new InteractionActivityPluginListItem(ip);
            m.addElement(item);
            InteractionActivityEditor editor = ip.createActivityEditor((Activity)this.m_receive, this);
            item.setEditor(editor);
            JComponent comp = editor.getEditorComponent();
            this.m_cardPnl.add(ip.getName(), (Component)comp);
            if (!ip.isEditorForActivity((Activity)this.m_receive)) continue;
            editingPlugin = item;
        }
        this.m_interactionTypeCombo.setModel(m);
        if (editingPlugin != null) {
            m.setSelectedItem(editingPlugin);
        } else {
            this.m_interactionTypeCombo.setSelectedIndex(0);
        }
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        if (this.m_receive == null) {
            return;
        }
        this.m_receive.setName(this.m_nameField.getText());
        this.m_receive.setCreateInstance(Boolean.valueOf(this.m_createInstanceCheckBox.isSelected()));
        InteractionActivityPluginListItem item = this.getSelectedPlugin();
        if (item != null) {
            item.getEditor().save();
            this.updateGraphPartnerLinkConnections((Node)this.m_receiveNode);
        } else {
            this.m_partnerLinkPnl.saveChanges();
        }
    }

    @Override
    public boolean validateEditorChanges() {
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    protected void loadControls() {
        this.m_nameField.setText(this.m_receive.getName());
        this.m_createInstanceCheckBox.setSelected(this.m_receive.getCreateInstance());
        this.m_partnerLinkPnl.loadControls();
    }

    protected InteractionActivityPluginListItem getSelectedPlugin() {
        Object item = this.m_interactionTypeCombo.getSelectedItem();
        if (item instanceof InteractionActivityPluginListItem) {
            return (InteractionActivityPluginListItem)item;
        }
        return null;
    }

    protected void handleInteractionTypeSelection() {
        InteractionActivityPluginListItem item = this.getSelectedPlugin();
        if (item != null) {
            this.m_cardPnl.show(item.getPlugin().getName());
        } else if (this.m_interactionTypeCombo.getSelectedIndex() == 0) {
            this.m_cardPnl.show(PARTNER_LINK_PANEL);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_interactionTypeCombo) {
            this.handleInteractionTypeSelection();
        }
    }
}

