/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLDataSourceObject;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.typeexplorer.DefaultWSDLImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.ui.ImportDialog;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.SchemaImportDialog;

public class ProjectWSDLImportHandler
extends DefaultWSDLImportHandler {
    protected BPELGraphPane m_graph;
    protected boolean m_showImport;
    protected boolean m_bShowElements;
    protected boolean m_bShowMessageTypes;

    public ProjectWSDLImportHandler(BPELGraphPane graph, boolean showImport) {
        super((IDEProject)graph.getBPELProject());
        this.m_graph = graph;
        this.m_showImport = showImport;
    }

    public ProjectWSDLImportHandler(BPELGraphPane graph, boolean showImport, boolean bShowMessageTypes, boolean bShowElements) {
        this(graph, showImport);
        this.m_bShowMessageTypes = bShowMessageTypes;
        this.m_bShowElements = bShowElements;
    }

    public WSDLDataSource getWSDLDataSource(URL url) {
        WSDLDataSourceObject obj = new WSDLDataSourceObject();
        obj.setUrl(url);
        obj.setShowComplex(false);
        obj.setShowElements(this.m_bShowElements);
        obj.setShowMessageTypes(this.m_bShowMessageTypes);
        obj.setSourceFileType(5);
        return new WSDLDataSource(obj);
    }

    protected URL getURLToImport(URL projDirURL, String fileName) {
        if (this.m_graph == null) {
            return super.getURLToImport(projDirURL, fileName);
        }
        return URLFactory.newURL((URL)this.m_graph.getBPELProject().getWSDLRoot(), (String)fileName);
    }

    public URL getURLToImport(TypeExplorer explorer) {
        if (this.m_showImport) {
            JFrame frame = null;
            frame = explorer != null ? GraphUtils.getFrame((Component)explorer) : GraphUtils.getFrame((Component)((Object)this.m_graph));
            SchemaImportDialog dlg = new SchemaImportDialog(GraphUtils.getFrame((Component)explorer), MessageBundleUtil.getCommonString((String)"TE_IMPORT_WSDL_FILE", (String)"Import WSDL File"), 1, this.m_graph);
            JCheckBox cb = dlg.getAddToProjectCheckBox();
            cb.setSelected(true);
            cb.setEnabled(false);
            if (dlg.display() == 0) {
                URL url = CommonScaUtils.handleImportDialog((IDEProject)this.m_project, (Frame)frame, (ImportDialog)dlg, (String)"WSDL", (URL)this.m_url);
                this.m_addedToProject = dlg.getAddToProject();
                dlg.saveWSDLFile();
                return url;
            }
            return null;
        }
        super.getURLToImport((TreeExplorer)explorer);
        return null;
    }
}

