/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JFrame;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.typeexplorer.DefaultSchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.ui.ImportDialog;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.SchemaImportDialog;

public class ProjectSchemaImportHandler
extends DefaultSchemaImportHandler {
    protected BPELGraphPane m_graph;
    protected boolean m_showImport;

    public ProjectSchemaImportHandler(BPELGraphPane graph, boolean showImport) {
        super((IDEProject)graph.getBPELProject());
        this.m_graph = graph;
        this.m_showImport = showImport;
    }

    public URL getURLToImport() {
        return this.getURLToImport(null);
    }

    public URL getURLToImport(TypeExplorer explorer) {
        if (this.m_showImport) {
            JFrame frame = null;
            frame = explorer != null ? GraphUtils.getFrame((Component)explorer) : GraphUtils.getFrame((Component)((Object)this.m_graph));
            SchemaImportDialog dlg = new SchemaImportDialog(frame, MessageBundleUtil.getCommonString((String)"TE_IMPORT_SCHEMA_FILE", (String)"Import Schema File"), 0, this.m_graph);
            if (dlg.display() == 0) {
                URL url = CommonScaUtils.handleImportDialog((IDEProject)this.m_project, (Frame)frame, (ImportDialog)dlg, (String)"XSD", (URL)this.m_url);
                this.m_addedToProject = dlg.getAddToProject();
                if (this.m_addedToProject) {
                    String protocol = url.getProtocol();
                    if (protocol.startsWith("http") || protocol.startsWith("esb") || protocol.startsWith("classpath")) {
                        url = this.importHttpURL(url, explorer);
                    } else if (protocol.startsWith("file")) {
                        url = this.importFileURL(url, explorer);
                    } else {
                        GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)explorer), (String)("Cannot import URL with protocol:" + protocol), (int)0);
                        url = null;
                    }
                }
                dlg.saveWSDLFile();
                return url;
            }
            return null;
        }
        super.getURLToImport((TreeExplorer)explorer);
        return null;
    }

    protected URL importHttpURL(URL url, TypeExplorer explorer) {
        URL result = super.importHttpURL(url, (TreeExplorer)explorer);
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        p.fireModelChanged((Object)this, 15, (Object)this.m_graph);
        return result;
    }

    protected URL importFileURL(URL url, TypeExplorer explorer) {
        URL result = super.importFileURL(url, (TreeExplorer)explorer);
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        p.fireModelChanged((Object)this, 15, (Object)this.m_graph);
        return result;
    }

    protected URL getURLToImport(URL projDirURL, String fileName) {
        if (this.m_graph == null) {
            return super.getURLToImport(projDirURL, fileName);
        }
        return URLFactory.newURL((URL)this.m_graph.getBPELProject().getXSDRoot(), (String)fileName);
    }
}

