/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.util.ModelUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ProcessGenEditPage
extends BaseEditingPage {
    protected static final String QUERY_LANG_NS = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    protected static final String EXPRESS_LANG_NS = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    protected JTextField m_nameField;
    protected JTextField m_targetNSField;
    protected JTextField m_queryLangField;
    protected JTextField m_expressLangField;
    protected JComboBox m_cbSupJoinFailure;
    protected JComboBox m_cbEnableInsComp;
    protected JComboBox m_cbAbstractProcess;
    protected Process m_activity;

    public ProcessGenEditPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
        this.setModified(true);
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_targetNSField = new JTextField();
        this.m_queryLangField = new JTextField();
        this.m_expressLangField = new JTextField();
        this.m_cbSupJoinFailure = new JComboBox();
        this.m_cbEnableInsComp = new JComboBox();
        this.m_cbAbstractProcess = new JComboBox();
        BooleanComboItem noItem = new BooleanComboItem(false);
        BooleanComboItem yesItem = new BooleanComboItem(true);
        this.m_cbSupJoinFailure.addItem(noItem);
        this.m_cbSupJoinFailure.addItem(yesItem);
        this.m_cbEnableInsComp.addItem(noItem);
        this.m_cbEnableInsComp.addItem(yesItem);
        this.m_cbAbstractProcess.addItem(noItem);
        this.m_cbAbstractProcess.addItem(yesItem);
    }

    protected void layoutControls() {
        JLabel lblAP = new JLabel();
        BPELStringTranslator.setLabel(lblAP, this.m_cbAbstractProcess, BPELStringTranslator.getString("EDITOR_PS_ABSTRACT_PS"));
        JLabel lblEIC = new JLabel();
        BPELStringTranslator.setLabel(lblEIC, this.m_cbEnableInsComp, BPELStringTranslator.getString("EDITOR_PS_EN_INS_COMP"));
        JLabel lblSJF = new JLabel();
        BPELStringTranslator.setLabel(lblSJF, this.m_cbSupJoinFailure, BPELStringTranslator.getString("EDITOR_PS_SUP_JOIN_FAIL"));
        JLabel lblEL = new JLabel();
        BPELStringTranslator.setLabel(lblEL, this.m_expressLangField, BPELStringTranslator.getString("EDITOR_PS_EXP_LANG"));
        JLabel lblQL = new JLabel();
        BPELStringTranslator.setLabel(lblQL, this.m_queryLangField, BPELStringTranslator.getString("EDITOR_PS_Q_LANG"));
        JLabel lblTS = new JLabel();
        BPELStringTranslator.setLabel(lblTS, this.m_targetNSField, BPELStringTranslator.getString("EDITOR_PS_TAR_NS"));
        JLabel lblName = new JLabel();
        BPELStringTranslator.setLabel(lblName, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)lblName, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblTS, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_targetNSField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblQL, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_queryLangField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblEL, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_expressLangField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblSJF, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_cbSupJoinFailure, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblEIC, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_cbEnableInsComp, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)lblAP, (int)0, (int)row, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_cbAbstractProcess, (int)1, (int)row++, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(0, 0, 5, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Process)model;
        this.loadControls();
    }

    protected void loadControls() {
        if (this.m_activity == null) {
            return;
        }
        if (this.m_activity.getName() != null) {
            this.m_nameField.setText(this.m_activity.getName());
        }
        if (this.m_activity.getTargetNamespace() != null) {
            this.m_targetNSField.setText(this.m_activity.getTargetNamespace());
        }
        if (this.m_activity.getQueryLanguage() == null) {
            this.m_queryLangField.setText("http://www.w3.org/TR/1999/REC-xpath-19991116");
        } else {
            this.m_queryLangField.setText(this.m_activity.getQueryLanguage());
        }
        if (this.m_activity.getExpressionLanguage() == null) {
            this.m_expressLangField.setText("http://www.w3.org/TR/1999/REC-xpath-19991116");
        } else {
            this.m_expressLangField.setText(this.m_activity.getExpressionLanguage());
        }
        Boolean b = this.m_activity.getEnableInstanceCompensation();
        if (b != null && b.booleanValue()) {
            this.m_cbEnableInsComp.setSelectedIndex(1);
        } else {
            this.m_cbEnableInsComp.setSelectedIndex(0);
        }
        b = this.m_activity.getAbstractProcess();
        if (b != null && b.booleanValue()) {
            this.m_cbAbstractProcess.setSelectedIndex(1);
        } else {
            this.m_cbAbstractProcess.setSelectedIndex(0);
        }
        b = this.m_activity.getSuppressJoinFailure();
        if (b != null && b.booleanValue()) {
            this.m_cbSupJoinFailure.setSelectedIndex(1);
        } else {
            this.m_cbSupJoinFailure.setSelectedIndex(0);
        }
    }

    @Override
    public boolean validateEditorChanges() {
        if (!ModelUtil.hasLength((String)this.m_nameField.getText())) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_ERROR"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setName(this.m_nameField.getText());
        this.m_activity.setTargetNamespace(this.m_targetNSField.getText());
        this.m_activity.setQueryLanguage(this.m_queryLangField.getText());
        this.m_activity.setExpressionLanguage(this.m_expressLangField.getText());
        BooleanComboItem cbItem = (BooleanComboItem)this.m_cbSupJoinFailure.getSelectedItem();
        this.m_activity.setSuppressJoinFailure(cbItem.getBooleanVal());
        cbItem = (BooleanComboItem)this.m_cbEnableInsComp.getSelectedItem();
        this.m_activity.setEnableInstanceCompensation(cbItem.getBooleanVal());
        cbItem = (BooleanComboItem)this.m_cbAbstractProcess.getSelectedItem();
        this.m_activity.setAbstractProcess(cbItem.getBooleanVal());
        this.fireProcessChangedEvent(28);
    }

    private class BooleanComboItem {
        private boolean m_bVal;
        private String m_strVal;

        public BooleanComboItem(boolean b) {
            this.m_bVal = b;
            this.m_strVal = BPELStringTranslator.getString(b ? "BPEL_YES_VALUE" : "BPEL_NO_VALUE");
        }

        public Boolean getBooleanVal() {
            return this.m_bVal ? Boolean.TRUE : Boolean.FALSE;
        }

        public String toString() {
            return this.m_strVal;
        }
    }
}

