/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ui.BaseTableModel;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinksTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink.PartnerLinkDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PartnerLinksEditPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JTable m_table;
    protected JButton m_addBtn;
    protected JButton m_editBtn;
    protected JButton m_removeBtn;
    protected BPELGraphPane m_graph;
    protected Scope m_activity;

    public PartnerLinksEditPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public List<PartnerLink> getPartnerLinks() {
        PartnerLinksTableModel model = (PartnerLinksTableModel)((Object)this.m_table.getModel());
        return new ArrayList<PartnerLink>(model.getData());
    }

    public void load(Scope a) {
        this.m_activity = a;
        if (a == null) {
            PartnerLinksTableModel model = (PartnerLinksTableModel)((Object)this.m_table.getModel());
            model.getData().clear();
            model.refresh();
            return;
        }
        PartnerLinks pls = a.getPartnerLinks();
        if (pls == null) {
            return;
        }
        Vector<PartnerLink> data = new Vector<PartnerLink>();
        PartnerLinksTableModel model = (PartnerLinksTableModel)((Object)this.m_table.getModel());
        for (PartnerLink pl : pls.getPartnerLinks()) {
            data.addElement(pl);
        }
        model.setData(data);
        this.setColumnSizes();
        this.updateButtons();
    }

    protected void setColumnSizes() {
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(ImageCache.getIcon("partner_link_node")));
                continue;
            }
            if (i == 3) {
                col.setPreferredWidth(180);
                continue;
            }
            col.setPreferredWidth(120);
        }
    }

    protected void createControls() {
        this.m_addBtn = UIHelper.createToolBarButton((int)0);
        this.m_addBtn.addActionListener(this);
        this.m_removeBtn = UIHelper.createToolBarButton((int)2);
        this.m_removeBtn.addActionListener(this);
        this.m_editBtn = UIHelper.createToolBarButton((int)1);
        this.m_editBtn.addActionListener(this);
        this.m_table = new JTable((TableModel)((Object)new PartnerLinksTableModel()));
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setAutoResizeMode(0);
        this.m_table.setRowHeight(18);
        this.setColumnSizes();
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = PartnerLinksEditPanel.this.m_table.rowAtPoint(origin);
                int column = PartnerLinksEditPanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    PartnerLinksEditPanel.this.handleEdit();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_addBtn);
        tb.add((Component)this.m_editBtn);
        tb.add((Component)this.m_removeBtn);
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, this.m_table, BPELStringTranslator.getString("EDITOR_PLS_EDIT_PNL_PLS"));
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleEdit() {
        PartnerLinkNode node = new PartnerLinkNode();
        PartnerLinkDialog dlg = new PartnerLinkDialog(GraphUtils.getFrame((Component)this), this.m_graph, node);
        PartnerLinksTableModel tabModel = (PartnerLinksTableModel)((Object)this.m_table.getModel());
        ArrayList<PartnerLink> list = new ArrayList<PartnerLink>();
        for (PartnerLink link : tabModel.getData()) {
            list.add(link);
        }
        PartnerLink p = this.getSelectedPartnerLink();
        if (dlg.edit(p, list) == 0) {
            tabModel.refresh();
        }
    }

    protected void handleCreate() {
        PartnerLinkNode node = new PartnerLinkNode();
        PartnerLinkDialog dlg = new PartnerLinkDialog(GraphUtils.getFrame((Component)this), this.m_graph, node);
        PartnerLinksTableModel tabModel = (PartnerLinksTableModel)((Object)this.m_table.getModel());
        ArrayList<PartnerLink> list = new ArrayList<PartnerLink>();
        for (PartnerLink link : tabModel.getData()) {
            list.add(link);
        }
        if (dlg.create(list) != 0) {
            return;
        }
        PartnerLink partnerLink = dlg.getPartnerLink();
        PartnerLinks pLinks = this.m_activity.getPartnerLinks();
        if (pLinks == null) {
            pLinks = this.m_activity.createPartnerLinks();
        }
        this.m_activity.addPartnerLink(partnerLink);
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        node.setUserObject(partnerLink);
        SwimLaneView swimLane = this.m_graph.getRightSwimLaneView();
        Node n = swimLane.getNode();
        model.addChildNode(n, (Node)node);
        tabModel.getData().add(partnerLink);
        tabModel.refresh();
        this.updateButtons();
    }

    protected void handleRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_table.getSelectedRows();
            PartnerLinks pLinks = this.m_activity.getPartnerLinks();
            for (int row : rows) {
                PartnerLink partnerLink = (PartnerLink)tabModel.getRowData(row);
                pLinks.deletePartnerLink(partnerLink);
                BPELGraphModel gmodel = (BPELGraphModel)this.m_graph.getModel();
                SwimLaneView swimLaneView = this.m_graph.getLeftSwimLaneView();
                View v = this.findPartnerLink(swimLaneView, partnerLink.getName());
                if (v == null) {
                    swimLaneView = this.m_graph.getRightSwimLaneView();
                    v = this.findPartnerLink(swimLaneView, partnerLink.getName());
                }
                if (v == null) {
                    return;
                }
                gmodel.deleteNode(swimLaneView.getNode(), v.getNode());
            }
            if (pLinks.getPartnerLinks().size() == 0) {
                this.m_activity.deletePartnerLinks();
            }
            tabModel.removeRows(rows);
            this.updateButtons();
        }
    }

    public View findPartnerLink(SwimLaneView parent, String name) {
        Iterator it = parent.getChildren();
        View v = null;
        while (it.hasNext()) {
            v = (View)it.next();
            PartnerLink link = (PartnerLink)v.getNode().getUserObject();
            if (!link.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    protected PartnerLink getSelectedPartnerLink() {
        ListSelectionModel model = this.m_table.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return null;
        }
        int row = model.getLeadSelectionIndex();
        PartnerLinksTableModel tabModel = (PartnerLinksTableModel)((Object)this.m_table.getModel());
        return (PartnerLink)tabModel.getRowData(row);
    }

    protected void updateButtons() {
        int numSelectedRows = this.m_table.getSelectedRowCount();
        if (numSelectedRows > 0) {
            this.m_removeBtn.setEnabled(true);
            this.m_editBtn.setEnabled(true);
        } else {
            this.m_removeBtn.setEnabled(false);
            this.m_editBtn.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleCreate();
        } else if (src == this.m_editBtn) {
            this.handleEdit();
        } else if (src == this.m_removeBtn) {
            this.handleRemove();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }
}

