/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinksEditPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;

public class PartnerLinksEditDialog
extends BPELBaseDialog
implements ActionListener,
TreeSelectionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected int m_retVal = 1;
    protected Scope m_activity;
    protected BPELGraphPane m_graph;
    protected PartnerLinksEditPanel m_panel;

    public PartnerLinksEditDialog(JFrame f, BPELGraphPane graph, Scope activity) {
        super(f, BPELStringTranslator.getString("EDITOR_EXP_PL"), true);
        this.m_graph = graph;
        this.m_activity = activity;
        this.createControls();
        this.layoutControls();
    }

    public List<PartnerLink> getPartnerLinks() {
        return this.m_panel.getPartnerLinks();
    }

    protected void createControls() {
        this.m_panel = new PartnerLinksEditPanel(this.m_graph);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_panel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 280);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.loadControls();
        this.updateButtons();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PartnerLinksEditDialog.this.m_panel.load(PartnerLinksEditDialog.this.m_activity);
                }
                finally {
                    PartnerLinksEditDialog.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void updateButtons() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.handleHelp();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    private void handleHelp() {
        String topicId = HelpSystem.getHelpTopicId(this.m_panel.getClass().getName());
        HelpSystem.showHelp(this.m_panel, topicId);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.updateButtons();
    }
}

