/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLDataSourceObject;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PartnerLinkTypesDataSource
implements TreeExplorerDataSource {
    static Icon SCHEMA_ICON = ImageCache.getIcon("schema_node");
    static Icon ELEMENT_ICON = ImageCache.getIcon("element_node");
    static Icon COMPLEX_TYPE_ICON = ImageCache.getIcon("complex_type_node");
    static Icon PARTNER_LINK_ICON = ImageCache.getIcon("partner_link_node");
    protected DefaultMutableTreeNode m_root;
    protected Process m_process;
    protected boolean m_bShowComplex;
    protected boolean m_bShowElements;
    protected boolean m_bMessageTypes;
    protected boolean m_bShowRootNode;

    public PartnerLinkTypesDataSource(Process p, boolean bShowRootNode) {
        this(p, true, true, true, bShowRootNode);
    }

    public PartnerLinkTypesDataSource(Process p, boolean bShowComplex, boolean bShowElements, boolean bShowMessageTypes, boolean bShowRootNode) {
        this.m_process = p;
        this.m_bShowComplex = bShowComplex;
        this.m_bShowElements = bShowElements;
        this.m_bMessageTypes = bShowMessageTypes;
        this.m_bShowRootNode = bShowRootNode;
    }

    public TreeExplorerTreeNode[] getRoots() {
        ArrayList<TypeExplorerTreeNode> plinkNodesLst = new ArrayList<TypeExplorerTreeNode>();
        Process p = this.m_process;
        PartnerLinks links = p.getPartnerLinks();
        if (links != null) {
            for (PartnerLink plink : links.getPartnerLinks()) {
                String wsdlLoc = plink.getWSDLLocation();
                if (wsdlLoc == null) continue;
                URL wsdlURL = null;
                try {
                    wsdlURL = new URL(wsdlLoc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                TextInfo t1 = new TextInfo();
                t1.setText(plink.getName());
                t1.setFont(TextInfo.PLAIN_FONT);
                t1.setColor(Color.black);
                NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                TypeExplorerTreeNode plinkNode = new TypeExplorerTreeNode(new Icon[]{PARTNER_LINK_ICON}, nodeTxt, (Object)"Partner Link", null);
                plinkNode.add((MutableTreeNode)new DummyNode(""));
                plinkNodesLst.add(plinkNode);
                WSDLDataSourceObject obj = new WSDLDataSourceObject();
                obj.setUrl(wsdlURL);
                obj.setShowComplex(this.m_bShowComplex);
                obj.setShowElements(this.m_bShowElements);
                obj.setShowMessageTypes(this.m_bMessageTypes);
                obj.setSourceFileType(0);
                WSDLDataSource wsdlDS = new WSDLDataSource(obj);
                TreeExplorerTreeNode[] roots = wsdlDS.getRoots();
                ArrayList<TreeExplorerTreeNode> l = new ArrayList<TreeExplorerTreeNode>();
                if (roots == null) continue;
                for (int i = 0; i < roots.length; ++i) {
                    TreeExplorerTreeNode root = roots[i];
                    l.add(root);
                }
                plinkNode.setHardCodedChildNodes(l);
            }
        }
        if (this.m_bShowRootNode) {
            TypeExplorerTreeNode root = new TypeExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_PL", "Partner Links"));
            root.setHardCodedChildNodes(plinkNodesLst);
            root.add((MutableTreeNode)new DummyNode());
            return new TreeExplorerTreeNode[]{root};
        }
        return plinkNodesLst.toArray(new TreeExplorerTreeNode[0]);
    }
}

