/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PartnerLinkSelectionDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int PROPERTY_USAGE = 1;
    public static final int IMPORT_USAGE = 2;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JList m_plList;
    protected JButton m_helpBtn;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected int m_retVal = 1;
    protected int m_usage;

    public PartnerLinkSelectionDialog(JFrame f, Map plMap, int usage) {
        super(f, "Select Partner Link", true);
        this.m_usage = usage;
        this.createControls();
        this.layoutControls();
        this.loadControls(plMap);
    }

    protected void createControls() {
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        this.m_plList = new JList();
        this.m_plList.setCellRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_link_node")));
        this.m_plList.setSelectionMode(0);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        JLabel lbl = null;
        lbl = this.m_usage == 1 ? new JLabel("Please select one partner link in order to save Property/Property Alias:") : new JLabel("Please select one partner link in order to save imported Schema/WSDL:");
        GraphUtils.addComponent((Container)c, (Component)lbl, (int)0, (int)row++, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)new JScrollPane(this.m_plList), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(2, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 10, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(400, 250);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void loadControls(Map plMap) {
        Iterator it = plMap.keySet().iterator();
        DefaultComboBoxModel<PLListItem> model = new DefaultComboBoxModel<PLListItem>();
        while (it.hasNext()) {
            try {
                String name = (String)it.next();
                URI uri = (URI)plMap.get(name);
                model.addElement(new PLListItem(name, uri.toURL()));
            }
            catch (Exception ex) {}
        }
        this.m_plList.setModel(model);
        this.m_plList.setSelectedIndex(0);
    }

    protected boolean handleOK() {
        return this.m_plList.getSelectedIndex() != -1;
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    public URL getSelectedPartnerLinkURL() {
        if (this.m_retVal != 0) {
            return null;
        }
        PLListItem item = (PLListItem)this.m_plList.getSelectedValue();
        return item == null ? null : item.m_url;
    }

    public int select() {
        this.setVisible(true);
        return this.m_retVal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (this.handleOK()) {
                this.m_retVal = 0;
                this.dispose();
            }
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            // empty if block
        }
    }

    class PLListItem {
        public String m_name;
        public URL m_url;

        public PLListItem(String name, URL url) {
            this.m_name = name;
            this.m_url = url;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

