/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Color;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLFaultDataSource;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.typeexplorer.ExceptionTreeNode;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerCellRenderer;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLImport;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PartnerLinkFaultDataSource
implements TreeExplorerDataSource {
    static Icon PARTNER_LINK_ICON = ImageCache.getIcon("partner_link_node");
    protected DefaultMutableTreeNode m_root;
    protected Process m_process;
    protected boolean m_bShowRootNode;

    public PartnerLinkFaultDataSource(Process p, boolean bShowRootNode) {
        this.m_process = p;
        this.m_bShowRootNode = bShowRootNode;
    }

    public TreeExplorerTreeNode[] getRoots() {
        ArrayList<TypeExplorerTreeNode> plinkNodesLst = new ArrayList<TypeExplorerTreeNode>();
        Process p = this.m_process;
        PartnerLinks links = p.getPartnerLinks();
        if (links != null) {
            for (PartnerLink plink : links.getPartnerLinks()) {
                String wsdlLoc = plink.getWSDLLocation();
                if (wsdlLoc == null) continue;
                URL wsdlURL = null;
                try {
                    wsdlURL = new URL(wsdlLoc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                TextInfo t1 = new TextInfo();
                t1.setText(plink.getName());
                t1.setFont(TextInfo.PLAIN_FONT);
                t1.setColor(Color.black);
                NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                TypeExplorerTreeNode plinkNode = new TypeExplorerTreeNode(new Icon[]{PARTNER_LINK_ICON}, nodeTxt, (Object)"Partner Link", null);
                plinkNode.add((MutableTreeNode)new DummyNode(""));
                plinkNodesLst.add(plinkNode);
                WSDLFaultDataSource ds = new WSDLFaultDataSource(wsdlURL);
                TreeExplorerTreeNode[] roots = ds.getRoots();
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(this.getImportedWSDLNode(wsdlURL));
                if (roots == null) continue;
                for (int i = 0; i < roots.length; ++i) {
                    TreeExplorerTreeNode root = roots[i];
                    l.add(root);
                }
                plinkNode.setHardCodedChildNodes(l);
            }
        }
        if (this.m_bShowRootNode) {
            TypeExplorerTreeNode root = new TypeExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_PL", "Partner Links"));
            root.setHardCodedChildNodes(plinkNodesLst);
            root.add((MutableTreeNode)new DummyNode());
            return new TreeExplorerTreeNode[]{root};
        }
        return plinkNodesLst.toArray(new TreeExplorerTreeNode[0]);
    }

    private TypeExplorerTreeNode getImportedWSDLNode(URL wsdlURL) {
        TypeExplorerTreeNode importedWSDLNode = new TypeExplorerTreeNode(TreeExplorerCellRenderer.DEFAULT_ICON, MessageBundleUtil.getCommonString((String)"WSDL_IMPORTED_WSDL"), null);
        importedWSDLNode.add((MutableTreeNode)new DummyNode(""));
        try {
            List list = WSDLUtil.getImports((URI)new URI(URIUtil.escapeURIString((String)wsdlURL.toString())));
            if (list != null) {
                for (WSDLImport imp : list) {
                    if (imp.isXSDImport()) continue;
                    String wsdlLoc = imp.getLocationURI();
                    URL url = new URL(wsdlLoc);
                    WSDLFaultDataSource ds = new WSDLFaultDataSource(url);
                    TreeExplorerTreeNode[] rootNodes = ds.getRoots();
                    ArrayList<TreeExplorerTreeNode> l = new ArrayList<TreeExplorerTreeNode>();
                    if (rootNodes == null) continue;
                    for (int i = 0; i < rootNodes.length; ++i) {
                        TreeExplorerTreeNode root = rootNodes[i];
                        l.add(root);
                    }
                    importedWSDLNode.setHardCodedChildNodes(l);
                }
            }
        }
        catch (Exception e) {
            ExceptionTreeNode error = new ExceptionTreeNode(e, MessageBundleUtil.getCommonString((String)"WSDL_IMPORT_ERROR"));
            importedWSDLNode.add((MutableTreeNode)error);
        }
        return importedWSDLNode;
    }
}

