/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.bpelgraph.editors.OnMessageGenEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableAutoCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLOperationListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLPortTypeListItem;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink.PartnerLinkChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class OnMessagePartnerLinkPanel
extends JPanel
implements ActionListener {
    protected JComboBox m_partnerLinkCB;
    protected JComboBox m_portTypeCB;
    protected JComboBox m_operationsCB;
    protected JTextField m_varField;
    protected JButton m_varCreateBtn;
    protected JButton m_varBrowseBtn;
    protected JButton m_newPartnerLinkBtn;
    protected JButton m_partnerLinkBrowseBtn;
    protected JTextField m_partnerLinkField;
    protected OnMessageGenEditPage m_page;
    protected BPELGraphPane m_graphPane;
    protected QName m_portType;
    protected String m_operation;
    protected PartnerLink m_link;
    protected OnMessage m_onMessage;
    protected String m_origPartnerLink;
    protected boolean m_bSettingFromModel = false;

    public OnMessagePartnerLinkPanel(OnMessageGenEditPage page) {
        this.m_page = page;
        this.m_graphPane = this.m_page.m_graphPane;
        this.createControls();
        this.layoutControls();
    }

    protected void loadControls() {
        QName qname;
        this.m_onMessage = this.m_page.m_onMessage;
        if (this.m_onMessage == null) {
            return;
        }
        this.m_bSettingFromModel = true;
        this.m_origPartnerLink = this.m_onMessage.getPartnerLink();
        this.m_varField.setText(this.m_onMessage.getVariable());
        this.m_partnerLinkField.setText(this.m_onMessage.getPartnerLink());
        this.m_portType = qname = this.m_onMessage.getPortType();
        if (qname != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_portTypeCB.getModel();
            model.setSelectedItem(BPELModelUtil.getPrefixQualifiedName((QName)qname));
        }
        this.handlePartnerLinkSelection(this.m_page.getPartnerLink(this.m_partnerLinkField.getText()), null);
        if (this.m_link == null || this.m_operation == null || this.m_operation.length() == 0) {
            this.m_varCreateBtn.setEnabled(false);
        } else {
            this.m_varCreateBtn.setEnabled(true);
        }
    }

    protected void createControls() {
        this.m_newPartnerLinkBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_newPartnerLinkBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_PLD_CREATE_TITLE") + "...");
        this.m_newPartnerLinkBtn.addActionListener(this);
        this.m_partnerLinkBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_PLS"));
        this.m_partnerLinkBrowseBtn.addActionListener(this);
        this.m_partnerLinkCB = new JComboBox();
        this.m_partnerLinkCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_link_node")));
        this.m_partnerLinkCB.addActionListener(this);
        this.m_portTypeCB = new JComboBox();
        this.m_portTypeCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("port_type_node")));
        this.m_portTypeCB.setEditable(false);
        this.m_portTypeCB.addActionListener(this);
        this.m_operationsCB = new JComboBox();
        this.m_operationsCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("operation_node")));
        this.m_operationsCB.addActionListener(this);
        this.m_varField = new JTextField();
        this.m_varField.setEditable(false);
        this.m_varCreateBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_varCreateBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_RCV_AUTO_CRE_VAR"));
        this.m_varCreateBtn.addActionListener(this);
        this.m_varBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
        this.m_partnerLinkField = new JTextField();
        this.m_partnerLinkField.setEditable(false);
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_varCreateBtn);
        tb.add((Component)this.m_varBrowseBtn);
        ToolBar partnerLinkTB = new ToolBar();
        partnerLinkTB.add((Component)this.m_partnerLinkBrowseBtn);
        JLabel plinkLbl = new JLabel();
        BPELStringTranslator.setLabel(plinkLbl, this.m_partnerLinkCB, BPELStringTranslator.getString("EDITOR_RCV_PL"));
        JLabel varLbl = new JLabel();
        BPELStringTranslator.setLabel(varLbl, this.m_varField, BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_VAR"));
        JLabel portLbl = new JLabel();
        BPELStringTranslator.setLabel(portLbl, this.m_portTypeCB, BPELStringTranslator.getString("EDITOR_RCV_PORT_TYPE"));
        JLabel opLbl = new JLabel();
        BPELStringTranslator.setLabel(opLbl, this.m_operationsCB, BPELStringTranslator.getString("EDITOR_RCV_OP"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)plinkLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_partnerLinkField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)partnerLinkTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)opLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_operationsCB, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)varLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_varField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleNewPartnerLink() {
        PartnerLink link = this.m_graphPane.createPartnerLink(null);
        if (link != null) {
            PartnerLinkListItem item = new PartnerLinkListItem(link);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_partnerLinkCB.getModel();
            model.addElement(item);
            model.setSelectedItem(item);
        }
    }

    protected void handlePartnerLinkBrowse() {
        PartnerLinkChooser dlg = this.getPartnerLinkChooser();
        if (dlg.display() == 0) {
            PartnerLink pl;
            this.m_link = pl = dlg.getSelectedPartnerLink();
            if (pl != null) {
                this.m_partnerLinkField.setText(pl.getName());
            } else {
                this.m_partnerLinkField.setText("");
            }
            this.handlePartnerLinkSelection(pl, null);
        }
    }

    protected PartnerLinkChooser getPartnerLinkChooser() {
        return new PartnerLinkChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_onMessage);
    }

    protected void handleOperationSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
    }

    protected void createInputVariable() {
        String name;
        Variable variable;
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
        if (this.m_link == null || this.m_portType == null || this.m_operation == null) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_RCV_ENTER_INFO"), (int)0);
            return;
        }
        if (Helper.hasValue((String)this.m_operation) && (variable = this.m_page.createVariable(this.m_page.m_processModel, (Activity)this.m_onMessage, this.m_link, this.m_portType, this.m_operation, name = "OnMessage_" + this.m_operation, true)) != null && variable != null) {
            VariableAutoCreationDialog dlg;
            boolean hasScope = false;
            List scopes = BPELModelUtil.getParentScopes((Activity)this.m_onMessage);
            if (scopes != null && scopes.size() > 0) {
                hasScope = true;
            }
            if ((dlg = new VariableAutoCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_onMessage, variable.getName(), variable.getMessageType().toString(), hasScope)).display() == 0) {
                this.m_varField.setText(dlg.getVariableName());
                variable.setName(dlg.getVariableName());
                if (dlg.isGlobal()) {
                    this.m_page.m_processModel.addVariable(variable);
                } else if (scopes != null && scopes.size() > 0) {
                    Scope scope = (Scope)scopes.get(0);
                    scope.addVariable(variable);
                } else {
                    this.m_page.m_processModel.addVariable(variable);
                }
            }
        }
    }

    protected void handlePartnerLinkSelection(PartnerLink pl, String operation) {
        PartnerLink link;
        this.m_page.setModified(true);
        this.m_portTypeCB.setModel(new DefaultComboBoxModel());
        this.m_operationsCB.setModel(new DefaultComboBoxModel());
        this.m_link = link = pl;
        if (link == null) {
            return;
        }
        final String myRole = link.getMyRole();
        this.m_page.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object op;
                    Role r = OnMessagePartnerLinkPanel.this.m_page.getRoleForPartnerLinkRoleName(link, myRole);
                    if (r != null) {
                        OnMessagePartnerLinkPanel.this.handleRoleSelection(r);
                        OnMessagePartnerLinkPanel.this.m_page.selectOperation(OnMessagePartnerLinkPanel.this.m_onMessage.operation(), OnMessagePartnerLinkPanel.this.m_operationsCB);
                    }
                    if ((op = OnMessagePartnerLinkPanel.this.m_operationsCB.getSelectedItem()) instanceof WSDLOperationListItem) {
                        WSDLOperationListItem opItem = (WSDLOperationListItem)op;
                        OnMessagePartnerLinkPanel.this.m_operation = opItem.getOperation().getName();
                    } else {
                        OnMessagePartnerLinkPanel.this.m_operation = null;
                    }
                    if (OnMessagePartnerLinkPanel.this.m_link == null || OnMessagePartnerLinkPanel.this.m_operation == null || OnMessagePartnerLinkPanel.this.m_operation.length() == 0) {
                        OnMessagePartnerLinkPanel.this.m_varCreateBtn.setEnabled(false);
                    } else {
                        OnMessagePartnerLinkPanel.this.m_varCreateBtn.setEnabled(true);
                    }
                }
                finally {
                    OnMessagePartnerLinkPanel.this.m_page.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void asyncLoadPortTypes(String wsdlURL) {
        try {
            final DefaultComboBoxModel<WSDLPortTypeListItem> model = new DefaultComboBoxModel<WSDLPortTypeListItem>();
            Definition def = WSDLUtil.parseWSDLDocument((URI)new URI(URIUtil.escapeURIString((String)wsdlURL)));
            Map portTypesMap = def.getPortTypes();
            for (Object key : portTypesMap.keySet()) {
                PortType portType = (PortType)portTypesMap.get(key);
                model.addElement(new WSDLPortTypeListItem(portType));
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    OnMessagePartnerLinkPanel.this.m_portTypeCB.setModel(model);
                    if (model.getSize() > 0) {
                        OnMessagePartnerLinkPanel.this.m_portTypeCB.setSelectedIndex(0);
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleRoleSelection(Role r) {
        this.m_page.setModified(true);
        PortType wsdlPortType = r.getPortType();
        this.m_page.populatePortTypes(wsdlPortType, this.m_portTypeCB);
    }

    protected void handlePortTypeSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_portTypeCB.getSelectedItem();
        if (obj instanceof WSDLPortTypeListItem) {
            WSDLPortTypeListItem item = (WSDLPortTypeListItem)obj;
            PortType portType = item.getPortType();
            if (portType == null) {
                return;
            }
            this.m_portType = portType.getQName();
            this.m_page.populateOperations(portType, this.m_operationsCB);
        }
    }

    protected void handleVariableBrowse() {
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_onMessage);
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_varField.setText(v.getName());
            } else {
                this.m_varField.setText("");
            }
        }
    }

    public void saveChanges() {
        WSDLPortTypeListItem item;
        PortType ptype;
        if (this.m_onMessage == null) {
            return;
        }
        this.m_onMessage.setVariable(this.m_varField.getText());
        this.m_onMessage.setPartnerLink(this.m_partnerLinkField.getText());
        Object obj = this.m_portTypeCB.getSelectedItem();
        if (obj instanceof WSDLPortTypeListItem && (ptype = (item = (WSDLPortTypeListItem)obj).getPortType()) != null) {
            QName qname = ptype.getQName();
            String nsURI = qname.getNamespaceURI();
            String prefix = this.m_page.m_processModel.addNamespace(nsURI);
            String local = qname.getLocalPart();
            this.m_onMessage.setPortType(new QName(nsURI, local, prefix));
        }
        if ((obj = this.m_operationsCB.getSelectedItem()) instanceof WSDLOperationListItem) {
            WSDLOperationListItem opItem = (WSDLOperationListItem)obj;
            this.m_onMessage.setOperation(opItem.getOperation().getName());
        } else if (obj != null) {
            this.m_onMessage.setOperation((String)obj);
        } else {
            this.m_onMessage.setOperation(null);
        }
        this.m_page.fireProcessChangedEvent(28);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_partnerLinkCB) {
            this.handlePartnerLinkSelection(null, null);
        } else if (src == this.m_portTypeCB) {
            this.handlePortTypeSelection();
        } else if (src == this.m_varBrowseBtn) {
            this.handleVariableBrowse();
        } else if (src == this.m_newPartnerLinkBtn) {
            this.handleNewPartnerLink();
        } else if (src == this.m_partnerLinkBrowseBtn) {
            this.handlePartnerLinkBrowse();
        } else if (src == this.m_varCreateBtn) {
            this.createInputVariable();
        } else if (src == this.m_operationsCB) {
            this.handleOperationSelection();
        }
    }
}

