/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.ComponentBorderPane;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.OnMessagePartnerLinkPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityEditor;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;

public class OnMessageGenEditPage
extends BaseEditingPage
implements ActionListener {
    private static final int PARTNER_LINK_INDEX = 0;
    private static final String PARTNER_LINK_PANEL = "PARTNER_LINK_PANEL";
    protected OnMessage m_onMessage;
    protected JComboBox m_interactionTypeCombo;
    protected ComponentBorderPane m_borderPane;
    protected PartnerLink m_link;
    protected CardPanel m_cardPnl;
    protected OnMessagePartnerLinkPanel m_partnerLinkPnl;

    public OnMessageGenEditPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_cardPnl = new CardPanel();
        this.m_partnerLinkPnl = new OnMessagePartnerLinkPanel(this);
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add(PARTNER_LINK_PANEL, (Component)this.m_partnerLinkPnl);
        this.m_interactionTypeCombo = new JComboBox();
        this.m_interactionTypeCombo.addActionListener(this);
        this.m_interactionTypeCombo.setRenderer(new InteractionActivityPluginListCellRenderer());
        JLabel l = new JLabel();
        BPELStringTranslator.setLabel(l, this.m_interactionTypeCombo, BPELStringTranslator.getString("INTERACTION_TYPE_LBL"));
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_interactionTypeCombo, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        this.m_borderPane = new ComponentBorderPane((JComponent)p, (JComponent)this.m_cardPnl);
    }

    public void setPartnerLinkConnectionMode(String link) {
    }

    void layoutControls() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)this.m_borderPane, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_onMessage = (OnMessage)model;
        DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>();
        m.insertElementAt(BPELStringTranslator.getString("PARTNER_LINK"), 0);
        InteractionActivityPluginListItem editingPlugin = null;
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null) continue;
            InteractionActivityPluginListItem item = new InteractionActivityPluginListItem(ip);
            m.addElement(item);
            InteractionActivityEditor editor = ip.createActivityEditor((Activity)this.m_onMessage, this);
            item.setEditor(editor);
            JComponent comp = editor.getEditorComponent();
            this.m_cardPnl.add(ip.getName(), (Component)comp);
            if (!ip.isEditorForActivity((Activity)this.m_onMessage)) continue;
            editingPlugin = item;
        }
        this.m_interactionTypeCombo.setModel(m);
        if (editingPlugin != null) {
            m.setSelectedItem(editingPlugin);
        } else {
            this.m_interactionTypeCombo.setSelectedIndex(0);
        }
        this.loadControls();
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    @Override
    public void saveChanges() {
        if (this.m_onMessage == null) {
            return;
        }
        InteractionActivityPluginListItem item = this.getSelectedPlugin();
        if (item != null) {
            item.getEditor().save();
        } else {
            this.m_partnerLinkPnl.saveChanges();
        }
        this.fireProcessChangedEvent(28);
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    protected void loadControls() {
        if (this.m_onMessage == null) {
            return;
        }
        this.m_partnerLinkPnl.loadControls();
    }

    protected InteractionActivityPluginListItem getSelectedPlugin() {
        Object item = this.m_interactionTypeCombo.getSelectedItem();
        if (item instanceof InteractionActivityPluginListItem) {
            return (InteractionActivityPluginListItem)item;
        }
        return null;
    }

    protected void handleInteractionTypeSelection() {
        InteractionActivityPluginListItem item = this.getSelectedPlugin();
        if (item != null) {
            this.m_cardPnl.show(item.getPlugin().getName());
        } else if (this.m_interactionTypeCombo.getSelectedIndex() == 0) {
            this.m_cardPnl.show(PARTNER_LINK_PANEL);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_interactionTypeCombo) {
            this.handleInteractionTypeSelection();
        }
    }
}

