/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.SectionHeader;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InvokeGenEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.RoleListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableAutoCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLOperationListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLPortTypeListItem;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink.PartnerLinkChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class InvokePartnerLinkPanel
extends JPanel
implements ActionListener,
KeyListener {
    protected JComboBox m_portTypeCB;
    protected JComboBox m_operationsCB;
    protected JComboBox m_roleCB;
    protected JButton m_inputVarCreateBtn;
    protected JButton m_inputVarBrowseBtn;
    protected JButton m_outputVarCreateBtn;
    protected JButton m_outputVarBrowseBtn;
    protected JButton m_partnerLinkBrowseBtn;
    protected JTextField m_outputVarField;
    protected JTextField m_partnerLinkField;
    protected JTextField m_roleField;
    protected JTextField m_inputVarField;
    protected JCheckBox m_invokeAsDetail;
    protected InvokeGenEditPage m_page;
    protected BPELGraphPane m_graphPane;
    protected JTextField m_conversationID;
    protected QName m_portType;
    protected String m_operation;
    protected String m_origPartnerLink;
    protected Invoke m_invoke;
    protected String m_partnerLinkName;
    protected PartnerLink m_link;

    public InvokePartnerLinkPanel(InvokeGenEditPage page, BPELGraphPane graph) {
        this.m_page = page;
        this.m_graphPane = graph;
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_partnerLinkBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_PLS"));
        this.m_partnerLinkBrowseBtn.addActionListener(this);
        this.m_partnerLinkField = new JTextField();
        this.m_partnerLinkField.setEditable(false);
        this.m_partnerLinkField.addKeyListener(this);
        this.m_portTypeCB = new JComboBox();
        this.m_portTypeCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("port_type_node")));
        this.m_portTypeCB.setEditable(false);
        this.m_portTypeCB.addActionListener(this);
        this.m_operationsCB = new JComboBox();
        this.m_operationsCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("operation_node")));
        this.m_operationsCB.addActionListener(this);
        this.m_inputVarField = new JTextField();
        this.m_inputVarField.setEditable(false);
        this.m_inputVarField.addKeyListener(this);
        this.m_inputVarCreateBtn = new JButton(ImageCache.getIcon("create16"));
        this.m_inputVarCreateBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_INVO_AUTO_CRE_IN_VAR"));
        this.m_inputVarCreateBtn.addActionListener(this);
        this.m_inputVarBrowseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_inputVarBrowseBtn.setToolTipText(BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_inputVarBrowseBtn.addActionListener(this);
        this.m_outputVarCreateBtn = new JButton(ImageCache.getIcon("create16"));
        this.m_outputVarCreateBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_INVO_AUTO_CRE_OUT_VAR"));
        this.m_outputVarCreateBtn.addActionListener(this);
        this.m_outputVarBrowseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_outputVarBrowseBtn.setToolTipText(BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_outputVarBrowseBtn.addActionListener(this);
        this.m_outputVarField = new JTextField();
        this.m_outputVarField.setEditable(false);
        this.m_outputVarField.addKeyListener(this);
        this.m_roleCB = new JComboBox();
        this.m_roleCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_role_node")));
        this.m_roleCB.addActionListener(this);
        this.m_roleField = new JTextField();
        this.m_roleField.setEditable(false);
        this.m_invokeAsDetail = new JCheckBox();
        BPELStringTranslator.setButton(this.m_invokeAsDetail, BPELStringTranslator.getString("INVOKE_AS_DETAIL", "&Invoke As Detail:"));
        this.m_conversationID = new JTextField();
    }

    protected void layoutControls() {
        JToolBar inputTB = new JToolBar();
        inputTB.setBorderPainted(false);
        inputTB.add(this.m_inputVarCreateBtn);
        inputTB.add(this.m_inputVarBrowseBtn);
        JToolBar outputTB = new JToolBar();
        outputTB.setBorderPainted(false);
        outputTB.add(this.m_outputVarCreateBtn);
        outputTB.add(this.m_outputVarBrowseBtn);
        JToolBar partnerLinkTB = new JToolBar();
        partnerLinkTB.setBorderPainted(false);
        partnerLinkTB.add(this.m_partnerLinkBrowseBtn);
        int row = 0;
        JLabel plinkLbl = new JLabel();
        BPELStringTranslator.setLabel(plinkLbl, this.m_partnerLinkField, BPELStringTranslator.getString("EDITOR_RCV_PL"));
        JLabel roleLbl = new JLabel();
        BPELStringTranslator.setLabel(roleLbl, this.m_roleField, BPELStringTranslator.getString("EDITOR_PLE_PT_ROLE"));
        JLabel portLbl = new JLabel();
        BPELStringTranslator.setLabel(portLbl, this.m_portTypeCB, BPELStringTranslator.getString("EDITOR_RCV_PORT_TYPE"));
        JLabel opLbl = new JLabel();
        BPELStringTranslator.setLabel(opLbl, this.m_operationsCB, BPELStringTranslator.getString("EDITOR_RCV_OP"));
        JLabel outputVarLbl = new JLabel();
        BPELStringTranslator.setLabel(outputVarLbl, this.m_outputVarField, BPELStringTranslator.getString("EDITOR_INVO_OUTPUT_VAR"));
        JLabel inputVarLbl = new JLabel();
        BPELStringTranslator.setLabel(inputVarLbl, this.m_inputVarField, BPELStringTranslator.getString("EDITOR_INVO_INPUT_VAR"));
        SectionHeader partnerLinkHeader = new SectionHeader(BPELStringTranslator.getString("PARTNER_ROLE_WEB_SERVICE_INTERFACE"));
        SectionHeader variablesHeader = new SectionHeader(BPELStringTranslator.getString("VARIABLES"));
        JLabel conversationIdLbl = new JLabel();
        BPELStringTranslator.setLabel(conversationIdLbl, this.m_conversationID, BPELStringTranslator.getString("EDITOR_CONVERSATION_ID"));
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)partnerLinkHeader, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)plinkLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_partnerLinkField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)partnerLinkTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)opLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_operationsCB, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)variablesHeader, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)inputVarLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_inputVarField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)inputTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)outputVarLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_outputVarField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(3, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)outputTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel optionsPnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)optionsPnl, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        row = 0;
        SectionHeader optionsHeader = new SectionHeader(BPELStringTranslator.getString("EDITOR_OPTIONS"));
        GraphUtils.addComponent((Container)optionsPnl, (Component)optionsHeader, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)optionsPnl, (Component)conversationIdLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)optionsPnl, (Component)this.m_conversationID, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 0, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)optionsPnl, (Component)this.m_invokeAsDetail, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 10, 5, 2), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    public void setPartnerLinkConnectionMode(String link) {
        this.m_partnerLinkName = link;
        this.m_link = this.getPartnerLink(link);
        this.m_partnerLinkField.setText(link);
        this.m_partnerLinkBrowseBtn.setEnabled(false);
    }

    protected void loadControls() {
        if (this.m_invoke == null) {
            return;
        }
        if (this.m_partnerLinkName != null) {
            this.m_partnerLinkField.setText(this.m_partnerLinkName);
        } else {
            this.m_partnerLinkField.setText(this.m_invoke.getPartnerLink());
        }
        this.m_portType = this.m_invoke.getPortType();
        this.handlePartnerLinkSelection(this.getPartnerLink(this.m_partnerLinkField.getText()), this.m_portType, this.m_invoke.getOperation());
        this.m_origPartnerLink = this.m_invoke.getPartnerLink();
        if (Helper.hasValue((String)this.m_origPartnerLink)) {
            PartnerLink l;
            this.m_link = l = this.getPartnerLink(this.m_origPartnerLink);
            if (l != null) {
                this.m_roleField.setText(l.getPartnerRole());
            }
        }
        this.m_inputVarField.setText(this.m_invoke.getInputVariable());
        this.m_outputVarField.setText(this.m_invoke.getOutputVariable());
        this.enableOutputSection(this.isOutputExist());
        this.m_invokeAsDetail.setSelected(this.m_invoke.getInvokeAsDetail());
        this.m_conversationID.setText(this.m_invoke.getConversationId());
    }

    protected PartnerLink getPartnerLink(String name) {
        List links = BPELModelUtil.getAllPartnerLinks((Process)this.m_page.m_processModel);
        if (links != null) {
            for (PartnerLink plink : links) {
                if (!plink.getName().equalsIgnoreCase(name)) continue;
                return plink;
            }
        }
        return null;
    }

    protected void saveChanges() {
        boolean bLinkChanged;
        WSDLPortTypeListItem item;
        PortType ptype;
        if (this.m_invoke == null) {
            return;
        }
        this.m_invoke.setName(this.m_page.m_nameField.getText());
        this.m_invoke.setInputVariable(this.m_inputVarField.getText());
        this.m_invoke.setOutputVariable(this.m_outputVarField.getText());
        this.m_invoke.setPartnerLink(this.m_partnerLinkField.getText());
        Object obj = this.m_portTypeCB.getSelectedItem();
        if (obj instanceof WSDLPortTypeListItem && (ptype = (item = (WSDLPortTypeListItem)obj).getPortType()) != null) {
            QName qname = ptype.getQName();
            String nsURI = qname.getNamespaceURI();
            String prefix = this.m_page.m_processModel.addNamespace(nsURI);
            String local = qname.getLocalPart();
            this.m_invoke.setPortType(new QName(nsURI, local, prefix));
        }
        if ((obj = this.m_operationsCB.getSelectedItem()) instanceof WSDLOperationListItem) {
            WSDLOperationListItem opItem = (WSDLOperationListItem)obj;
            this.m_invoke.setOperation(opItem.getOperation().getName());
        } else if (obj != null) {
            this.m_invoke.setOperation((String)obj);
        } else {
            this.m_invoke.setOperation(null);
        }
        this.m_invoke.setInvokeAsDetail(this.m_invokeAsDetail.isSelected());
        this.m_invoke.setConversationId(this.m_conversationID.getText());
        String partnerLink = this.m_invoke.getPartnerLink();
        boolean bl = bLinkChanged = this.m_origPartnerLink == null && partnerLink != null || this.m_origPartnerLink != null && partnerLink == null || this.m_origPartnerLink != null && partnerLink != null && !this.m_origPartnerLink.equalsIgnoreCase(partnerLink);
        if (bLinkChanged) {
            this.m_page.updateGraphPartnerLinkConnections((Node)this.m_page.m_invokeNode);
        }
        this.m_page.fireProcessChangedEvent(28);
    }

    protected void handleRoleSelection(Role r) {
        this.m_page.setModified(true);
        PortType wsdlPortType = r.getPortType();
        this.m_page.populatePortTypes(wsdlPortType, this.m_portTypeCB);
    }

    protected void handleRoleSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_roleCB.getSelectedItem();
        if (obj instanceof RoleListItem) {
            RoleListItem selItem = (RoleListItem)obj;
            Role r = selItem.getRole();
            PortType wsdlPortType = r.getPortType();
            this.m_page.populatePortTypes(wsdlPortType, this.m_portTypeCB);
        }
    }

    protected void handlePortTypeSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_portTypeCB.getSelectedItem();
        if (obj instanceof WSDLPortTypeListItem) {
            WSDLPortTypeListItem item = (WSDLPortTypeListItem)obj;
            PortType portType = item.getPortType();
            if (portType == null) {
                return;
            }
            this.m_portType = portType.getQName();
            this.m_page.populateOperations(portType, this.m_operationsCB);
        }
    }

    protected void handleOperationSelection() {
        this.m_page.setModified(true);
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
        this.enableOutputSection(this.isOutputExist());
    }

    public boolean isOutputExist() {
        boolean result = true;
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
        if (this.m_link == null || this.m_portType == null || this.m_operation == null) {
            result = false;
        } else {
            QName qname = BaseEditingPage.getVariableQName(this.m_link, this.m_portType, this.m_operation, false);
            if (qname == null) {
                result = false;
            }
        }
        return result;
    }

    public void enableOutputSection(boolean b) {
        this.m_outputVarField.setEnabled(b);
        this.m_outputVarCreateBtn.setEnabled(b);
        this.m_outputVarBrowseBtn.setEnabled(b);
    }

    protected void handleOutputVariableBrowse() {
        VariableChooser dlg = this.getVariableChooser();
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_outputVarField.setText(v.getName());
            } else {
                this.m_outputVarField.setText("");
            }
        }
    }

    protected void createInputVariable() {
        Variable variable;
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
        if (this.m_link == null || this.m_portType == null || this.m_operation == null) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_RCV_ENTER_INFO"), (int)0);
            return;
        }
        String name = this.m_page.m_nameField.getText().trim();
        if (!Helper.isValidName((String)name, (boolean)false)) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (int)0);
            return;
        }
        if (Helper.hasValue((String)name) && Helper.hasValue((String)this.m_operation) && (variable = this.m_page.createVariable(this.m_page.m_processModel, (Activity)this.m_invoke, this.m_link, this.m_portType, this.m_operation, name = name + "_" + this.m_operation, true)) != null) {
            VariableAutoCreationDialog dlg;
            boolean hasScope = false;
            List scopes = BPELModelUtil.getParentScopes((Activity)this.m_invoke);
            if (scopes != null && scopes.size() > 0) {
                hasScope = true;
            }
            if ((dlg = new VariableAutoCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_invoke, variable.getName(), variable.getMessageType().toString(), hasScope)).display() == 0) {
                this.m_inputVarField.setText(dlg.getVariableName());
                variable.setName(dlg.getVariableName());
                if (dlg.isGlobal()) {
                    this.m_page.m_processModel.addVariable(variable);
                } else if (scopes != null && scopes.size() > 0) {
                    Scope scope = (Scope)scopes.get(0);
                    scope.addVariable(variable);
                } else {
                    this.m_page.m_processModel.addVariable(variable);
                }
            }
        }
    }

    protected void createOutputVariable() {
        Variable variable;
        Object obj = this.m_operationsCB.getSelectedItem();
        if (obj != null) {
            this.m_operation = obj.toString();
        }
        if (this.m_link == null || this.m_portType == null || this.m_operation == null) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_RCV_ENTER_INFO"), (int)0);
            return;
        }
        String name = this.m_page.m_nameField.getText().trim();
        if (!Helper.isValidName((String)name, (boolean)false)) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (int)0);
            return;
        }
        if (name != null && name.length() > 0 && this.m_operation != null && this.m_operation.length() > 0 && (variable = this.m_page.createVariable(this.m_page.m_processModel, (Activity)this.m_invoke, this.m_link, this.m_portType, this.m_operation, name = name + "_" + this.m_operation, false)) != null) {
            VariableAutoCreationDialog dlg;
            boolean hasScope = false;
            List scopes = BPELModelUtil.getParentScopes((Activity)this.m_invoke);
            if (scopes != null && scopes.size() > 0) {
                hasScope = true;
            }
            if ((dlg = new VariableAutoCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_invoke, variable.getName(), variable.getMessageType().toString(), hasScope)).display() == 0) {
                this.m_outputVarField.setText(dlg.getVariableName());
                variable.setName(dlg.getVariableName());
                if (dlg.isGlobal()) {
                    this.m_page.m_processModel.addVariable(variable);
                } else if (scopes != null && scopes.size() > 0) {
                    Scope scope = (Scope)scopes.get(0);
                    scope.addVariable(variable);
                } else {
                    this.m_page.m_processModel.addVariable(variable);
                }
            }
        }
    }

    protected void handleInputVariableBrowse() {
        VariableChooser dlg = this.getVariableChooser();
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_inputVarField.setText(v.getName());
            } else {
                this.m_inputVarField.setText("");
            }
        }
    }

    protected void handlePartnerLinkBrowse() {
        PartnerLinkChooser dlg = this.getPartnerLinkChooser();
        if (dlg.display() == 0) {
            PartnerLink pl;
            this.m_link = pl = dlg.getSelectedPartnerLink();
            if (pl != null) {
                this.m_partnerLinkField.setText(pl.getName());
            } else {
                this.m_partnerLinkField.setText("");
            }
            this.handlePartnerLinkSelection(pl, null, null);
        }
    }

    protected void handlePartnerLinkSelection(PartnerLink pl, final QName portType, final String operation) {
        this.m_roleCB.setModel(new DefaultComboBoxModel());
        this.m_portTypeCB.setModel(new DefaultComboBoxModel());
        this.m_operationsCB.setModel(new DefaultComboBoxModel());
        this.m_roleField.setText("");
        final PartnerLink link = pl;
        if (link == null) {
            return;
        }
        final String partnerRole = link.getPartnerRole();
        this.m_page.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Role r = InvokePartnerLinkPanel.this.m_page.getRoleForPartnerLinkRoleName(link, partnerRole);
                    if (r != null) {
                        InvokePartnerLinkPanel.this.handleRoleSelection(r);
                        if (portType != null) {
                            InvokePartnerLinkPanel.this.selectPortType(portType);
                        }
                        InvokePartnerLinkPanel.this.m_page.selectOperation(operation, InvokePartnerLinkPanel.this.m_operationsCB);
                    }
                    InvokePartnerLinkPanel.this.m_roleField.setText(partnerRole);
                    Object op = InvokePartnerLinkPanel.this.m_operationsCB.getSelectedItem();
                    if (op instanceof WSDLOperationListItem) {
                        WSDLOperationListItem opItem = (WSDLOperationListItem)op;
                        InvokePartnerLinkPanel.this.m_operation = opItem.getOperation().getName();
                    } else {
                        InvokePartnerLinkPanel.this.m_operation = null;
                    }
                    if (InvokePartnerLinkPanel.this.m_link == null || InvokePartnerLinkPanel.this.m_operation == null || InvokePartnerLinkPanel.this.m_operation.length() == 0) {
                        InvokePartnerLinkPanel.this.m_inputVarCreateBtn.setEnabled(false);
                    } else {
                        InvokePartnerLinkPanel.this.m_inputVarCreateBtn.setEnabled(true);
                    }
                }
                finally {
                    InvokePartnerLinkPanel.this.m_page.enableUserInput(true);
                    InvokePartnerLinkPanel.this.enableOutputSection(InvokePartnerLinkPanel.this.isOutputExist());
                }
            }
        };
        new Thread(r).start();
    }

    protected void selectPortType(QName qname) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_portTypeCB.getModel();
        boolean bSelected = false;
        for (int i = 0; i < model.getSize() && !bSelected; ++i) {
            WSDLPortTypeListItem item = (WSDLPortTypeListItem)model.getElementAt(i);
            if (!item.toString().equals(qname.getLocalPart())) continue;
            model.setSelectedItem(item);
            bSelected = true;
        }
        if (!bSelected) {
            model.setSelectedItem(BPELModelUtil.getPrefixQualifiedName((QName)qname));
        }
    }

    protected VariableChooser getVariableChooser() {
        return new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_invoke);
    }

    protected PartnerLinkChooser getPartnerLinkChooser() {
        return new PartnerLinkChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_invoke);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_roleCB) {
            this.handleRoleSelection();
        } else if (src == this.m_portTypeCB) {
            this.handlePortTypeSelection();
        } else if (src == this.m_outputVarBrowseBtn) {
            this.handleOutputVariableBrowse();
        } else if (src == this.m_inputVarBrowseBtn) {
            this.handleInputVariableBrowse();
        } else if (src == this.m_partnerLinkBrowseBtn) {
            this.handlePartnerLinkBrowse();
        } else if (src == this.m_operationsCB) {
            this.handleOperationSelection();
        } else if (src == this.m_inputVarCreateBtn) {
            this.createInputVariable();
        } else if (src == this.m_outputVarCreateBtn) {
            this.createOutputVariable();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object src = e.getSource();
        if (src == this.m_inputVarField || src == this.m_outputVarField) {
            this.m_page.setModified(true);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

