/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.ComponentBorderPane;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InvokePartnerLinkPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityEditor;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;

public class InvokeGenEditPage
extends BaseEditingPage
implements EditorPage,
ActionListener,
KeyListener {
    private static final int PARTNER_LINK_INDEX = 0;
    private final String PARTNER_LINK_PANEL = "PARTNER_LINK_PANEL";
    protected CardPanel m_cardPnl;
    protected JTextField m_nameField;
    protected InvokePartnerLinkPanel m_partnerLinkPnl;
    protected JComboBox m_interactionTypeCombo;
    protected ComponentBorderPane m_borderPane;
    protected Invoke m_invoke;
    protected InvokeNode m_invokeNode;

    public InvokeGenEditPage(BPELGraphPane graphPane, InvokeNode invokeNode) {
        super(graphPane);
        this.m_invokeNode = invokeNode;
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_partnerLinkPnl.m_invoke = this.m_invoke = (Invoke)model;
        DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>();
        m.insertElementAt(BPELStringTranslator.getString("PARTNER_LINK"), 0);
        InteractionActivityPluginListItem editingPlugin = null;
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null) continue;
            InteractionActivityPluginListItem item = new InteractionActivityPluginListItem(ip);
            m.addElement(item);
            InteractionActivityEditor editor = ip.createActivityEditor((Activity)this.m_invoke, this);
            item.setEditor(editor);
            JComponent comp = editor.getEditorComponent();
            this.m_cardPnl.add(ip.getName(), (Component)comp);
            if (!ip.isEditorForActivity((Activity)this.m_invoke)) continue;
            editingPlugin = item;
        }
        this.m_interactionTypeCombo.setModel(m);
        if (editingPlugin != null) {
            m.setSelectedItem(editingPlugin);
        } else {
            this.m_interactionTypeCombo.setSelectedIndex(0);
        }
    }

    protected void createControls() {
        this.m_cardPnl = new CardPanel();
        this.m_interactionTypeCombo = new JComboBox();
        this.m_interactionTypeCombo.addActionListener(this);
        this.m_interactionTypeCombo.setRenderer(new InteractionActivityPluginListCellRenderer());
        JLabel l = new JLabel();
        BPELStringTranslator.setLabel(l, this.m_interactionTypeCombo, BPELStringTranslator.getString("INTERACTION_TYPE_LBL"));
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_interactionTypeCombo, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        this.m_borderPane = new ComponentBorderPane((JComponent)p, (JComponent)this.m_cardPnl);
        this.m_partnerLinkPnl = new InvokePartnerLinkPanel(this, this.m_graphPane);
        JScrollPane s = new JScrollPane(this.m_partnerLinkPnl);
        s.setBorder(null);
        this.m_cardPnl.add("PARTNER_LINK_PANEL", (Component)s);
        this.m_cardPnl.show("PARTNER_LINK_PANEL");
        this.m_nameField = new JTextField();
        this.m_nameField.addKeyListener(this);
    }

    public void setPartnerLinkConnectionMode(String link) {
        this.m_interactionTypeCombo.setSelectedIndex(0);
        this.m_partnerLinkPnl.setPartnerLinkConnectionMode(link);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JPanel partnerPnl = new JPanel(new GridBagLayout());
        partnerPnl.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_INVO_PARTNER_ROLE_WEB_I")));
        int row = 0;
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JPanel namePnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)namePnl, (Component)nameLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)namePnl, (Component)this.m_nameField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        row = 0;
        GraphUtils.addComponent((Container)this, (Component)namePnl, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_borderPane, (int)0, (int)row, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void loadData() {
        this.loadControls();
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void saveChanges() {
        InteractionActivityPluginListItem item = this.getSelectedPlugin();
        if (item != null) {
            item.getEditor().save();
            this.updateGraphPartnerLinkConnections((Node)this.m_invokeNode);
        } else {
            this.m_partnerLinkPnl.saveChanges();
        }
    }

    @Override
    public boolean validateEditorChanges() {
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    protected void loadControls() {
        if (this.m_invoke == null) {
            return;
        }
        this.m_nameField.setText(this.m_invoke.getName());
        this.m_partnerLinkPnl.loadControls();
        this.setModified(false);
    }

    protected InteractionActivityPluginListItem getSelectedPlugin() {
        Object item = this.m_interactionTypeCombo.getSelectedItem();
        if (item instanceof InteractionActivityPluginListItem) {
            return (InteractionActivityPluginListItem)item;
        }
        return null;
    }

    protected void handleInteractionTypeSelection() {
        InteractionActivityPluginListItem item = this.getSelectedPlugin();
        if (item != null) {
            this.m_cardPnl.show(item.getPlugin().getName());
        } else if (this.m_interactionTypeCombo.getSelectedIndex() == 0) {
            this.m_cardPnl.show("PARTNER_LINK_PANEL");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_interactionTypeCombo) {
            this.handleInteractionTypeSelection();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object src = e.getSource();
        if (src == this.m_nameField) {
            this.setModified(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

