/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class HeaderVariableEditPage
extends BaseEditingPage
implements ActionListener {
    public static final int SHOW_HEADER_VAR = 1;
    public static final int SHOW_INPUT_HEADER_VAR = 2;
    protected JTextField m_varField;
    protected JButton m_varBrowseBtn;
    protected JButton m_removeBtn;
    protected int m_showType;
    protected Activity m_activity;

    public HeaderVariableEditPage(BPELGraphPane graphPane, int type) {
        super(graphPane);
        this.m_showType = type;
        this.createControls();
        this.layoutControls();
    }

    void createControls() {
        this.m_varField = new JTextField();
        this.m_varBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
        this.m_removeBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("garbage_empty16"));
        this.m_removeBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_ADP_REMOVE_HEADER_VAR", "Remove Variable"));
        this.m_removeBtn.setMnemonic(BPELStringTranslator.getMnemonic("DEL_BUTTON_TEXT_Mnemonic"));
        this.m_removeBtn.addActionListener(this);
        this.m_removeBtn.setEnabled(false);
    }

    void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_varBrowseBtn);
        tb.add((Component)this.m_removeBtn);
        JLabel varLbl = new JLabel();
        String varLblStr = this.m_showType == 1 ? BPELStringTranslator.getString("EDITOR_ADP_HEADER_VAR", "Header &Variable:") : BPELStringTranslator.getString("EDITOR_ADP_INPUT_HEADER_VAR", "Input Header &Variable:");
        BPELStringTranslator.setLabel(varLbl, this.m_varField, varLblStr);
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)varLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_varField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(7, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void saveChanges() {
        String var = this.m_varField.getText();
        if (this.m_activity == null || var == null) {
            return;
        }
        if (this.m_activity instanceof Invoke) {
            ((Invoke)this.m_activity).setInputHeaderVariable(var);
        } else if (this.m_activity instanceof Reply) {
            ((Reply)this.m_activity).setInputHeaderVariable(var);
        } else if (this.m_activity instanceof OnMessage) {
            ((OnMessage)this.m_activity).setHeaderVariable(var);
        } else if (this.m_activity instanceof Receive) {
            ((Receive)this.m_activity).setHeaderVariable(var);
        }
    }

    @Override
    public void setUserObject(Object obj) {
        super.setUserObject(obj);
        this.m_activity = (Activity)obj;
        this.loadControls();
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("EDITOR_ADP_LABEL", "Headers");
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    protected void handleVariableBrowse() {
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_activity);
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                String vars = this.m_varField.getText();
                if (Helper.hasValue((String)vars)) {
                    this.m_varField.setText(vars + "," + v.getName());
                } else {
                    this.m_varField.setText(v.getName());
                }
                this.m_removeBtn.setEnabled(true);
            } else {
                this.m_varField.setText("");
                this.m_removeBtn.setEnabled(false);
            }
        }
    }

    protected void loadControls() {
        if (this.m_activity == null) {
            return;
        }
        if (this.m_activity instanceof Invoke) {
            this.m_varField.setText(((Invoke)this.m_activity).getInputHeaderVariable());
        } else if (this.m_activity instanceof Reply) {
            this.m_varField.setText(((Reply)this.m_activity).getInputHeaderVariable());
        } else if (this.m_activity instanceof OnMessage) {
            this.m_varField.setText(((OnMessage)this.m_activity).getHeaderVariable());
        } else if (this.m_activity instanceof Receive) {
            this.m_varField.setText(((Receive)this.m_activity).getHeaderVariable());
        }
        String text = this.m_varField.getText();
        if (text != null && text.trim().length() > 0) {
            this.m_removeBtn.setEnabled(true);
        }
    }

    protected void handleVariableRemove() {
        this.m_varField.setText("");
        this.m_removeBtn.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_varBrowseBtn) {
            this.handleVariableBrowse();
        } else if (src == this.m_removeBtn) {
            this.handleVariableRemove();
        }
    }
}

