/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.From;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.FromOpType;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyDialogEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageInputs;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class FromToOpTypeEditPage
extends CopyDialogEditPage {
    private int pageType;

    public FromToOpTypeEditPage(BPELGraphPane pane, CopyPageInputs in, Object copyRule, int type, boolean editMode) {
        super(pane, in, copyRule, editMode);
        this.pageType = type;
    }

    @Override
    protected void populateFromTypeCB() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_TBL_VAR"));
        model.addElement(BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_EXP_SEL"));
        model.addElement(BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_LIT_SEL"));
        this.m_fromTypeCB.setModel(model);
    }

    @Override
    protected CardPanel createFromCardPanel() {
        CardPanel fromCardPnl = new CardPanel();
        fromCardPnl.add("FROM_VARIABLE_PANEL", (Component)this.createFromVarPanel());
        fromCardPnl.add("FROM_EXPRESSION_PANEL", (Component)this.createFromExpressionPanel());
        fromCardPnl.add("FROM_LITERAL_PANEL", (Component)this.createFromLiteralPanel());
        return fromCardPnl;
    }

    @Override
    protected CardPanel createToCardPanel() {
        CardPanel toCardPnl = new CardPanel();
        toCardPnl.add("TO_VARIABLE_PANEL", (Component)this.createToVariablePanel());
        return toCardPnl;
    }

    @Override
    protected void populateToTypeCB() {
        this.m_toTypeCB.addItem(BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_TBL_VAR"));
    }

    @Override
    public void populateCopyInfo() {
        From from = ((FromOpType)this.m_copyRule).getFrom();
        To to = ((FromOpType)this.m_copyRule).getTo();
        int sel = this.m_fromTypeCB.getSelectedIndex();
        if (sel == 1) {
            from.setExpression(this.m_fromExpXPathBuilder.getText());
            from.setVariable(null);
            from.setPart(null);
            from.setQuery(null);
            this.m_fromExpXPathBuilder.saveCachedNS();
        } else if (sel == 0) {
            from.setExpression(null);
            Variable v = this.m_fromXPathBuilderPnl.getVariable();
            if (v != null) {
                from.setVariable(v.getName());
            } else {
                from.setVariable(null);
            }
            MessagePart p = this.m_fromXPathBuilderPnl.getPart();
            if (p != null) {
                from.setPart(p.getName());
            } else {
                from.setPart(null);
            }
            String xpath = this.m_fromXPathBuilderPnl.getXPath();
            this.m_fromXPathBuilderPnl.saveCachedNS();
            from.setQuery(xpath);
        } else if (sel == 2) {
            from.setLiteral(this.m_fromLiteral.getText());
            from.setExpression(null);
            from.setVariable(null);
            from.setPart(null);
            from.setQuery(null);
        }
        int toSelection = this.m_toTypeCB.getSelectedIndex();
        if (toSelection == 0) {
            Variable v = this.m_toXPathBuilderPnl.getVariable();
            if (v != null) {
                to.setVariable(v.getName());
            } else {
                to.setVariable(null);
            }
            MessagePart p = this.m_toXPathBuilderPnl.getPart();
            if (p != null) {
                to.setPart(p.getName());
            } else {
                to.setPart(null);
            }
            String xpath = this.m_toXPathBuilderPnl.getXPath();
            this.m_toXPathBuilderPnl.saveCachedNS();
            to.setQuery(xpath);
        } else {
            to.setVariable(null);
            to.setPart(null);
            to.setQuery(null);
        }
    }

    @Override
    protected String loadCopyRule() {
        String initXPath = null;
        From from = ((FromOpType)this.m_copyRule).getFrom();
        if (from != null) {
            initXPath = from.getExpression();
        }
        this.loadBPELExtFrom(from);
        this.loadBPELExtTo(((FromOpType)this.m_copyRule).getTo());
        return initXPath;
    }

    protected void loadBPELExtFrom(final From from) {
        if (from.getExpression() != null) {
            this.m_fromTypeCB.setSelectedIndex(1);
            this.m_focusComponent = this.m_fromExpXPathBuilder;
        } else if (from.getVariable() != null) {
            String varName = from.getVariable();
            String partName = from.getPart();
            String query = from.getQuery();
            boolean bSucceeded = false;
            if (varName != null && partName != null) {
                bSucceeded = this.m_fromXPathBuilderPnl.selectVariablePart(varName, partName, this.m_assignActivity, from.getQuery());
            }
            if (!bSucceeded && varName != null && query != null) {
                List qnames = this.parseToQNames(query);
                bSucceeded = this.m_fromXPathBuilderPnl.selectVariableXPathNode(varName, qnames, this.m_assignActivity);
            }
            if (!bSucceeded && varName != null) {
                this.m_fromXPathBuilderPnl.selectVariable(varName, this.m_assignActivity);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.m_fromXPathBuilderPnl.setXPath(from.getQuery());
            } else {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FromToOpTypeEditPage.this.m_fromXPathBuilderPnl.setXPath(from.getQuery());
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        } else if (from.getLiteral() != null) {
            this.m_fromLiteral.setText(from.getLiteral());
            this.m_fromTypeCB.setSelectedIndex(2);
            this.m_focusComponent = this.m_fromLiteral;
        }
    }

    protected void loadBPELExtTo(final To to) {
        if (to.getVariable() == null) {
            return;
        }
        this.m_toTypeCB.setSelectedIndex(0);
        String varName = to.getVariable();
        String partName = to.getPart();
        String query = to.getQuery();
        boolean bSucceeded = false;
        if (varName != null && partName != null) {
            bSucceeded = this.m_toXPathBuilderPnl.selectVariablePart(varName, partName, this.m_assignActivity, to.getQuery());
        }
        if (!bSucceeded && varName != null && query != null) {
            List qnames = this.parseToQNames(query);
            bSucceeded = this.m_toXPathBuilderPnl.selectVariableXPathNode(varName, qnames, this.m_assignActivity);
        }
        if (!bSucceeded && varName != null) {
            this.m_toXPathBuilderPnl.selectVariable(varName, this.m_assignActivity);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FromToOpTypeEditPage.this.m_toXPathBuilderPnl.setXPath(to.getQuery());
            }
        };
        SwingUtilities.invokeLater(r);
    }

    @Override
    protected String getHelpTopicID() {
        String appendToTopicLookup = "";
        switch (this.pageType) {
            case 2: {
                appendToTopicLookup = this.inEditMode ? "AppendRule.Edit" : "AppendRule.Create";
                break;
            }
            case 3: {
                appendToTopicLookup = this.inEditMode ? "InsertAfterRule.Edit" : "InsertAfterRule.Create";
                break;
            }
            case 4: {
                appendToTopicLookup = this.inEditMode ? "InsertBeforeRule.Edit" : "InsertBeforeRule.Create";
                break;
            }
            case 5: {
                appendToTopicLookup = this.inEditMode ? "CopyListRule.Edit" : "CopyListRule.Create";
            }
        }
        return this.getClass().getName() + "." + appendToTopicLookup;
    }
}

