/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.FlowN;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.XPathScrollPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VarNameCreationManager;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooser;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooserValidator;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class FlowNEditPage
extends BaseEditingPage
implements ActionListener {
    protected JTextField m_nameField;
    protected JScrollPane m_m_NFieldScrollPane;
    protected XPathEditorPane m_NFieldExpBuilder;
    protected JTextField m_indexVarField;
    protected JButton m_browseVarBtn;
    protected JButton m_autoCreateVarBtn;
    protected FlowN m_activity;
    protected JButton m_NFieldExpBuilderBtn;

    public FlowNEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_NFieldExpBuilder = new XPathEditorPane();
        this.m_m_NFieldScrollPane = new XPathScrollPane((Component)this.m_NFieldExpBuilder, 21, 31);
        this.m_NFieldExpBuilder.setEditable(true);
        this.m_indexVarField = new JTextField();
        this.m_browseVarBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS", "Browse Variables..."));
        this.m_browseVarBtn.addActionListener(this);
        this.m_autoCreateVarBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_autoCreateVarBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_INVO_AUTO_CRE_IN_VAR", "Auto-Create Index Variable"));
        this.m_autoCreateVarBtn.addActionListener(this);
        this.m_NFieldExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_NFieldExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder..."));
        this.m_NFieldExpBuilderBtn.addActionListener(this);
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_autoCreateVarBtn);
        tb.add((Component)this.m_browseVarBtn);
        ToolBar tb1 = new ToolBar();
        tb1.add((Component)this.m_NFieldExpBuilderBtn);
        JLabel nameLbl = new JLabel(BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel nLbl = new JLabel("N:");
        JLabel indexVarLbl = new JLabel(BPELStringTranslator.getString("INDEX_VARIABLE"));
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        BPELStringTranslator.setLabel(nLbl, this.m_m_NFieldScrollPane, "N:");
        BPELStringTranslator.setLabel(indexVarLbl, this.m_indexVarField, BPELStringTranslator.getString("INDEX_VARIABLE"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)nLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_m_NFieldScrollPane, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb1, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(4, 0, 5, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)indexVarLbl, (int)0, (int)row, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 10, 5, 5), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_indexVarField, (int)1, (int)row, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(4, 0, 5, 10), (int)0, (int)0, (double)0.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (FlowN)model;
        this.loadControls();
    }

    protected void loadControls() {
        this.m_nameField.setText(this.m_activity.getName());
        this.m_nsResolver = NSResolverFactory.getNSResolver((Activity)this.m_activity, (Process)this.m_processModel);
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)this.m_activity, this.m_nsResolver);
        this.m_NFieldExpBuilder.initializeEditorPane((VariableDataCallBack)dataCallBack, this.m_activity.getN(), this.m_nsResolver);
        this.m_indexVarField.setText(this.m_activity.getIndexVariable());
    }

    @Override
    public boolean validateEditorChanges() {
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setName(this.m_nameField.getText());
        this.m_activity.setN(this.m_NFieldExpBuilder.getText());
        this.m_activity.setIndexVariable(this.m_indexVarField.getText());
        this.fireProcessChangedEvent(28);
        this.m_NFieldExpBuilder.saveCachedNS();
    }

    protected void handleAutoCreateVariable() {
        Variable variable = (Variable)BPELParser.createImplementation(Variable.class);
        String name = this.m_nameField.getText();
        if (name == null || name.length() == 0) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("ERROR_SPECIFY_NAME"), (int)0);
            return;
        }
        String varName = this.m_nameField.getText() + "_Variable";
        varName = VarNameCreationManager.getInstance().getVariableName(this.m_processModel, (Activity)this.m_activity, varName);
        variable.setName(BPELModelUtil.getUniqueVariableName((Process)this.m_processModel, (String)varName));
        variable.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"));
        variable.setMessageType(null);
        variable.setElement(null);
        List scopes = BPELModelUtil.getParentScopes((Activity)this.m_activity);
        this.m_processModel.addNamespace("http://www.w3.org/2001/XMLSchema", "xsd");
        if (scopes != null && scopes.size() > 0) {
            Scope scope = (Scope)scopes.get(0);
            scope.addVariable(variable);
        } else {
            this.m_processModel.addVariable(variable);
        }
        this.m_indexVarField.setText(variable.getName());
    }

    protected void handleBrowseVariables() {
        VariableChooser dlg = new VariableChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, (Activity)this.m_activity);
        VariableChooserValidator validator = new VariableChooserValidator(){

            @Override
            public boolean validate(VariableChooser dlg) {
                Variable v = dlg.getSelectedVariable();
                String msg = BPELStringTranslator.formatString("ERROR_SELECT_VAR_TYPE", "{http://www.w3.org/2001/XMLSchema}int");
                QName qname = v.getVariableTypeQName();
                if (qname == null) {
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)dlg)), (String)msg, (int)0);
                    return false;
                }
                String uri = qname.getNamespaceURI();
                String local = qname.getLocalPart();
                if (uri == null || local == null) {
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)dlg)), (String)msg, (int)0);
                    return false;
                }
                if (!uri.equalsIgnoreCase("http://www.w3.org/2001/XMLSchema") || !local.equalsIgnoreCase("int")) {
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)dlg)), (String)msg, (int)0);
                    return false;
                }
                return true;
            }
        };
        dlg.setValidator(validator);
        if (dlg.display() == 0) {
            Variable v = dlg.getSelectedVariable();
            if (v != null) {
                this.m_indexVarField.setText(v.getName());
            } else {
                this.m_indexVarField.setText("");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_autoCreateVarBtn) {
            this.handleAutoCreateVariable();
        } else if (src == this.m_browseVarBtn) {
            this.handleBrowseVariables();
        } else if (src == this.m_NFieldExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_NFieldExpBuilder, (Activity)this.m_activity);
        }
    }
}

