/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.util.List;
import java.util.Vector;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Correlation;
import oracle.tip.tools.ide.common.bpelparser.iface.Correlations;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PMGeneralItem;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class CorrelationsTableModel
extends BaseTableModel {
    private static final int SET = 0;
    public static final int INITIATE = 1;
    private static final int PROPERTIES = 2;
    public static final int PATTERN = 3;
    private Activity m_activity;
    protected Process m_process;
    protected boolean m_bShowNamespace = false;

    public CorrelationsTableModel(Activity activity, Process process) {
        this.m_activity = activity;
        if (this.m_activity instanceof Invoke) {
            this.createTableItems(((Invoke)this.m_activity).getCorrelations());
        } else if (this.m_activity instanceof OnMessage) {
            this.createTableItems(((OnMessage)this.m_activity).getCorrelations());
        } else if (this.m_activity instanceof Receive) {
            this.createTableItems(((Receive)this.m_activity).getCorrelations());
        } else if (this.m_activity instanceof Reply) {
            this.createTableItems(((Reply)this.m_activity).getCorrelations());
        }
        this.m_process = process;
    }

    public Object getValueAt(int row, int col) {
        if (row < this.m_data.size()) {
            Correlation info = (Correlation)this.m_data.elementAt(row);
            switch (col) {
                case 0: {
                    return info.getSet();
                }
                case 1: {
                    return this.getInitiate(info.getInitiate());
                }
                case 3: {
                    return this.getPattern(info.getPattern());
                }
                case 2: {
                    return this.genPropString(info.getProperties());
                }
            }
            return "";
        }
        return null;
    }

    public void setValueAt(Object obj, int i, int j) {
        if (i < this.m_data.size()) {
            Correlation info = (Correlation)this.m_data.elementAt(i);
            if (j == 1) {
                PMGeneralItem pmObj = (PMGeneralItem)obj;
                if (pmObj.getValue().equals("Yes")) {
                    info.setInitiate(Boolean.TRUE);
                } else {
                    info.setInitiate(Boolean.FALSE);
                }
            } else if (j == 3) {
                PMGeneralItem pmObj = (PMGeneralItem)obj;
                info.setPattern(pmObj.getValue());
            }
        }
    }

    public int getColumnCount() {
        if (this.m_activity instanceof Invoke) {
            return 4;
        }
        return 3;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return BPELStringTranslator.getString("EDITOR_COR_TBL_MODEL_COL_SET");
            }
            case 1: {
                return BPELStringTranslator.getString("EDITOR_COR_TBL_MODEL_COL_INIT");
            }
            case 3: {
                return BPELStringTranslator.getString("EDITOR_COR_TBL_MODEL_COL_PATTERN");
            }
            case 2: {
                return BPELStringTranslator.getString("EDITOR_COR_TBL_MODEL_COL_PROP");
            }
        }
        return " ";
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1 || col == 3;
    }

    public void insertRow(Object obj) {
        this.m_data.insertElementAt(obj, this.m_data.size());
        this.fireTableDataChanged();
    }

    public void showNamespaces(boolean bShow) {
        this.m_bShowNamespace = bShow;
        this.refresh();
    }

    protected void createTableItems(Correlations cors) {
        if (cors == null) {
            return;
        }
        List list = cors.getCorrelations();
        this.setData(new Vector(list));
    }

    private String genPropString(String[] strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        if (this.m_bShowNamespace) {
            for (int i = 0; i < strs.length; ++i) {
                int index;
                if (strs[i] == null || (index = strs[i].indexOf(":")) == -1) continue;
                String namespace = this.m_process.getNamespaceForPrefix(strs[i].substring(0, index));
                strBuf.append("{" + namespace + "}");
                strBuf.append(strs[i].substring(index + 1, strs[i].length()));
                strBuf.append(" ");
            }
        } else {
            for (int i = 0; i < strs.length; ++i) {
                strBuf.append(strs[i]);
                strBuf.append(" ");
            }
        }
        return strBuf.toString();
    }

    private PMGeneralItem getInitiate(Boolean bVal) {
        boolean b;
        boolean bl = b = bVal != null ? bVal : false;
        if (b) {
            return new PMGeneralItem("Yes", "BPEL_YES_VALUE");
        }
        return new PMGeneralItem("No", "BPEL_NO_VALUE");
    }

    private PMGeneralItem getPattern(String val) {
        if (val == null || val.equals("in")) {
            return new PMGeneralItem("in", "EDITOR_COR_EDIT_PGE_IN");
        }
        if (val.equals("out")) {
            return new PMGeneralItem("out", "EDITOR_COR_EDIT_PGE_OUT");
        }
        if (val.equals("out-in")) {
            return new PMGeneralItem("out-in", "EDITOR_COR_EDIT_PGE_OUT_IN");
        }
        return new PMGeneralItem("in", "EDITOR_COR_EDIT_PGE_IN");
    }
}

