/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Correlation;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSet;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSets;
import oracle.tip.tools.ide.common.bpelparser.iface.Correlations;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationsTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PMGeneralItem;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.correlationset.CorrelationSetChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import org.w3c.dom.Element;

public class CorrelationsEditPage
extends BaseEditingPage
implements ActionListener,
ListSelectionListener {
    protected JButton m_createSetBtn;
    protected JButton m_addSetBtn;
    protected JButton m_removeSetBtn;
    protected JButton m_editSetBtn;
    protected JTable m_table;
    protected ToolBar m_toolBar;
    protected Activity m_activity;
    protected InvokeNode m_invokeNode;
    protected JCheckBox m_namespaceCB;

    public CorrelationsEditPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        if (model instanceof Activity) {
            JComboBox<PMGeneralItem> comboBox;
            this.m_activity = (Activity)model;
            CorrelationsTableModel tModel = new CorrelationsTableModel(this.m_activity, this.m_processModel);
            this.m_table.setModel((TableModel)((Object)tModel));
            this.m_table.getSelectionModel().addListSelectionListener(this);
            TableColumn tc = this.m_table.getColumnModel().getColumn(1);
            if (tc != null) {
                comboBox = new JComboBox<PMGeneralItem>();
                comboBox.addItem(new PMGeneralItem("No", "EDITOR_COR_EDIT_NO_VAL"));
                comboBox.addItem(new PMGeneralItem("Yes", "EDITOR_COR_EDIT_YES_VAL"));
                tc.setCellEditor(new DefaultCellEditor(comboBox));
            }
            if ((tc = tModel.getColumnCount() > 3 ? this.m_table.getColumnModel().getColumn(3) : null) != null) {
                comboBox = new JComboBox();
                comboBox.addItem(new PMGeneralItem("in", "EDITOR_COR_EDIT_PGE_IN"));
                comboBox.addItem(new PMGeneralItem("out", "EDITOR_COR_EDIT_PGE_OUT"));
                comboBox.addItem(new PMGeneralItem("out-in", "EDITOR_COR_EDIT_PGE_OUT_IN"));
                tc.setCellEditor(new DefaultCellEditor(comboBox));
            }
        }
    }

    @Override
    public void loadData() {
    }

    protected void createControls() {
        this.m_namespaceCB = new JCheckBox(BPELStringTranslator.getString("EDITOR_COR_EDIT_PGE_SHOW_URI"), false);
        this.m_namespaceCB.addActionListener(this);
        BPELStringTranslator.setButton(this.m_namespaceCB, BPELStringTranslator.getString("EDITOR_COR_EDIT_PGE_SHOW_URI_RES"));
        String toolTip = MessageBundleUtil.getCommonString((String)"CREATE_BTN_TOOL_TIP");
        this.m_createSetBtn = UIHelper.createToolBarButton((Icon)new ImageIcon(GraphUtils.loadImage(GlobalImageCache.class, (String)"images/new_ena.png")), (String)toolTip, (String)toolTip);
        this.m_createSetBtn.addActionListener(this);
        toolTip = MessageBundleUtil.getCommonString((String)"ADD_BTN_TOOL_TIP");
        this.m_addSetBtn = UIHelper.createToolBarButton((Icon)new ImageIcon(GraphUtils.loadImage(GlobalImageCache.class, (String)"images/create16.png")), (String)toolTip, (String)toolTip);
        this.m_addSetBtn.addActionListener(this);
        this.m_editSetBtn = UIHelper.createToolBarButton((int)1);
        this.m_editSetBtn.addActionListener(this);
        this.m_removeSetBtn = UIHelper.createToolBarButton((int)2);
        this.m_removeSetBtn.addActionListener(this);
        this.m_table = new JTable();
        this.m_toolBar = new ToolBar();
        this.m_toolBar.setBorderInsets(new Insets(0, 0, 0, 0));
        this.m_toolBar.add((Component)this.m_createSetBtn);
        this.m_toolBar.add((Component)this.m_addSetBtn);
        this.m_toolBar.add((Component)this.m_editSetBtn);
        this.m_toolBar.add((Component)this.m_removeSetBtn);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_toolBar, (int)0, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(2, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_namespaceCB, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(2, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("EDIT_CORRELATIONS");
    }

    protected void performAdd() {
        TableModel tModel;
        CorrelationSet set;
        CorrelationSetChooser chooser = new CorrelationSetChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_activity);
        if (chooser.display() == 0 && (set = chooser.getSelectedCorrelationSet()) != null && (tModel = this.m_table.getModel()) instanceof CorrelationsTableModel) {
            Vector correlations = ((CorrelationsTableModel)((Object)tModel)).getData();
            for (Object obj : correlations) {
                Correlation rel = (Correlation)obj;
                String cor = rel.getSet();
                if (!cor.equals(set.getName())) continue;
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_COR_CRE_DLG_COR_SET_EXIST_IN_COR"));
                return;
            }
            ((CorrelationsTableModel)((Object)tModel)).insertRow(this.getInitCorrelation(set));
        }
    }

    protected void performRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_table.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
        }
    }

    protected void performExpressCreate() {
        TableModel tModel;
        List csList;
        CorrelationSetCreationDialog dlg = new CorrelationSetCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_activity);
        if (dlg.create(csList = this.getCorrelationSets()) != 0) {
            return;
        }
        CorrelationSet set = dlg.getCorrelationSet();
        if (set != null && (tModel = this.m_table.getModel()) instanceof CorrelationsTableModel) {
            ((CorrelationsTableModel)((Object)tModel)).insertRow(this.getInitCorrelation(set));
        }
    }

    private List getCorrelationSets() {
        CorrelationSets sets;
        List csList = null;
        Scope scope = BPELModelUtil.getParentScope((Activity)this.m_activity);
        if (scope != null && (sets = scope.getCorrelationSets()) != null) {
            csList = sets.getCorrelationSets();
        }
        return csList;
    }

    protected void performEdit() {
        List csList;
        ListSelectionModel model = this.m_table.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return;
        }
        int row = model.getLeadSelectionIndex();
        CorrelationsTableModel tableModel = (CorrelationsTableModel)((Object)this.m_table.getModel());
        Correlation cor = (Correlation)tableModel.getRowData(row);
        String name = cor.getSet();
        CorrelationSet cs = BPELModelUtil.getCorrelation((Activity)this.m_activity, (String)name);
        if (cs == null) {
            GraphUtils.displayMessage((Component)this, (String)"Can not find the correlation", (int)0);
            return;
        }
        CorrelationSetCreationDialog dlg = new CorrelationSetCreationDialog(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_activity);
        if (dlg.edit(cs, csList = this.getCorrelationSets(), cor.getPattern()) == 0) {
            CorrelationSet set = dlg.getCorrelationSet();
            QName[] qnames = set.getProperties();
            if (qnames != null) {
                String[] props = new String[qnames.length];
                for (int i = 0; i < props.length; ++i) {
                    props[i] = qnames[i].getPrefix() + ":" + qnames[i].getLocalPart();
                }
                cor.setProperties(props);
            }
            if (!cor.getSet().equals(set.getName())) {
                cor.setSet(set.getName());
            }
            tableModel.refresh();
        }
    }

    protected void updateButtons() {
        ListSelectionModel model = this.m_table.getSelectionModel();
        this.m_removeSetBtn.setEnabled(!model.isSelectionEmpty());
        this.m_editSetBtn.setEnabled(!model.isSelectionEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addSetBtn) {
            this.performAdd();
        } else if (src == this.m_removeSetBtn) {
            this.performRemove();
        } else if (src == this.m_createSetBtn) {
            this.performExpressCreate();
        } else if (src == this.m_editSetBtn) {
            this.performEdit();
        } else if (src == this.m_namespaceCB) {
            CorrelationsTableModel model = (CorrelationsTableModel)((Object)this.m_table.getModel());
            model.showNamespaces(this.m_namespaceCB.isSelected());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    @Override
    public void saveChanges() {
        TableModel model = this.m_table.getModel();
        if (model instanceof CorrelationsTableModel) {
            Vector vec = ((CorrelationsTableModel)((Object)model)).getData();
            this.saveCorrelations(vec);
        }
    }

    protected void saveCorrelations(Vector vec) {
        Correlations cors = this.getCorrelations(vec);
        if (cors != null) {
            for (int i = 0; i < vec.size(); ++i) {
                cors.addCorrelation((Correlation)vec.get(i));
            }
        }
    }

    protected final Correlations getCorrelations(Vector vec) {
        Correlations cors = null;
        if (vec != null && vec.size() > 0) {
            cors = (Correlations)BPELParser.createImplementation(Correlations.class);
            Element activityElem = this.m_activity.getDOMElement();
            cors.createDOMElement(activityElem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        }
        if (this.m_activity instanceof Invoke) {
            ((Invoke)this.m_activity).setCorrelations(cors);
        } else if (this.m_activity instanceof OnMessage) {
            ((OnMessage)this.m_activity).setCorrelations(cors);
        } else if (this.m_activity instanceof Receive) {
            ((Receive)this.m_activity).setCorrelations(cors);
        } else if (this.m_activity instanceof Reply) {
            ((Reply)this.m_activity).setCorrelations(cors);
        }
        return cors;
    }

    protected final Correlation getInitCorrelation(CorrelationSet set) {
        Correlation c = (Correlation)BPELParser.createImplementation(Correlation.class);
        c.setSet(set.getName());
        c.setInitiate(Boolean.FALSE);
        QName[] qs = set.getProperties();
        if (qs != null) {
            String[] strs = new String[qs.length];
            for (int i = 0; i < strs.length; ++i) {
                strs[i] = qs[i].getPrefix() != null ? qs[i].getPrefix() + ":" + qs[i].getLocalPart() : this.m_processModel.getPrefixForNamespace(qs[i].getNamespaceURI()) + ":" + qs[i].getLocalPart();
            }
            c.setProperties(strs);
        }
        if (this.m_activity instanceof Invoke) {
            c.setPattern("in");
        }
        return c;
    }
}

